/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import com.tmax.jce.provider.TmaxProvider;
import java.rmi.server.RMISocketFactory;
import java.security.Policy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.ejb.util.EJBRMISocketFactory;
import jeus.jdbc.connectionpool.ConnectionPoolManager;
import jeus.jdbc.connectionpool.ServerConnectionPoolInitializer;
import jeus.jms.common.JMSProperties;
import jeus.security.resource.JeusSecurityManager;
import jeus.server.AllPermissionPolicy;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.enginecontainer.InvocationManager;
import jeus.server.enginecontainer.InvocationManagerCenter;
import jeus.servlet.property.WebProperties;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.JeusPort;
import jeus.util.JeusProperties;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.net.JeusSocketDispatcher;
import jeus.util.properties.JeusAppProperties;
import jeus.util.properties.JeusClientProperties;
import jeus.util.properties.JeusEJBProperties;
import jeus.util.properties.JeusEngineContainerProperties;
import jeus.util.properties.JeusJDBCProperties;
import jeus.util.properties.JeusJMXProperties;
import jeus.util.properties.JeusJNDIProperties;
import jeus.util.properties.JeusLogAnalyzerProperties;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusNodeClusterProperties;
import jeus.util.properties.JeusPersistenceProperties;
import jeus.util.properties.JeusPropertyValues;
import jeus.util.properties.JeusRMIProperties;
import jeus.util.properties.JeusSecurityProperties;
import jeus.util.properties.JeusSessionManagerProperties;
import jeus.util.properties.JeusSnmpProperties;
import jeus.util.properties.JeusTMProperties;
import jeus.util.properties.JeusWebManagerProperties;
import jeus.util.properties.JeusWebServerProperties;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.ListenerType;
import jeus.xml.binding.jeusDD.PoolingType;
import jeus.xml.binding.jeusDD.SecuritySslType;

public class CommonProcessInitializer {
    public static final TmaxProvider PROVIDER = new TmaxProvider();

    public static void init() throws Exception {
        InvocationManagerCenter.setInvocationManager(new InvocationManager());
        ConnectionPoolManager.setPoolInitializer(new ServerConnectionPoolInitializer());
        if (JeusManagerProperties.ENABLE_JEUSSECURITY_MANAGER) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                Policy.setPolicy(new AllPermissionPolicy());
            }
            JeusSecurityManager jsm = new JeusSecurityManager(securityManager);
            System.setSecurityManager(jsm);
        }
        try {
            RMISocketFactory factory = JeusEJBProperties.RMI_SOCKET_FACTORY_CLASS != null ? (RMISocketFactory)JeusServer.class.getClassLoader().loadClass(JeusEJBProperties.RMI_SOCKET_FACTORY_CLASS).newInstance() : new EJBRMISocketFactory();
            RMISocketFactory.setSocketFactory(factory);
        }
        catch (Throwable ex) {
            throw new JeusServerException(JeusMessage_Manager.MGR_53, ex);
        }
        JeusNetPropertyValues.printNetworkConfiguration();
        System.out.println("[RMI Configuration] Default RMI export port for this container : " + JeusManagerPropertyValues.getDefaultRMIPort());
        CommonProcessInitializer.checkSystemProperties();
    }

    public static void checkSystemProperties() {
        try {
            JeusProperties.class.newInstance();
            JeusClientProperties.class.newInstance();
            JeusEJBProperties.class.newInstance();
            JeusEngineContainerProperties.class.newInstance();
            JeusJDBCProperties.class.newInstance();
            JMSProperties.class.newInstance();
            JeusJMXProperties.class.newInstance();
            JeusJNDIProperties.class.newInstance();
            JeusLogAnalyzerProperties.class.newInstance();
            JeusManagerProperties.class.newInstance();
            JeusNodeClusterProperties.class.newInstance();
            JeusPropertyValues.class.newInstance();
            JeusRMIProperties.class.newInstance();
            JeusSecurityProperties.class.newInstance();
            JeusSessionManagerProperties.class.newInstance();
            JeusSnmpProperties.class.newInstance();
            JeusTMProperties.class.newInstance();
            JeusWebManagerProperties.class.newInstance();
            WebProperties.initSystemProperty();
            JeusWebServerProperties.class.newInstance();
            JeusPersistenceProperties.class.newInstance();
            JeusAppProperties.class.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Set p = JeusBootstrapPropertyValues.getMissingProperties();
        if (p.size() > 0) {
            for (String string : p) {
                System.out.println("[SystemProperty] The system property is set but has no corresponding jeus property, maybe typographical error : " + string);
            }
        } else {
            System.out.println("[SystemProperty] All jeus properties are confirmed");
        }
        if (JeusProperties.PRINT_SYSTEM_PROPERTIES) {
            for (Map.Entry entry : System.getProperties().entrySet()) {
                System.out.println("[SystemProperty] " + entry.getKey() + " = " + entry.getValue());
            }
        }
    }

    public static void configJeusSocketDispatcher(JeusMainDescriptor desc) {
        ListenerType listenerCfg;
        JeusSystemType sys = desc.getJeusSystem();
        List nodes = sys.getNode();
        String nodeName = VirtualDNS.LOCAL_VIRTUALNAME;
        JeusNodeType myNode = null;
        for (JeusNodeType node : nodes) {
            if (!nodeName.equals(node.getName())) continue;
            myNode = node;
            break;
        }
        if (myNode != null && (listenerCfg = myNode.getListener()) != null) {
            SecuritySslType ssl;
            int tmp;
            if (listenerCfg.isSetBacklog() && (tmp = listenerCfg.getBacklog().intValue()) > 0) {
                JeusSocketDispatcher.setBacklog((int)tmp);
            }
            if (listenerCfg.isSetSsl() && (ssl = listenerCfg.getSsl()).isSetPort()) {
                int tmp2 = ssl.getPort();
                JeusSocketDispatcher.setSSLPort((int)(tmp2 > 0 ? tmp2 : JeusPort.JeusBaseSSL));
            }
            if (listenerCfg.isSetThreadPool()) {
                PoolingType pool = listenerCfg.getThreadPool();
                JeusSocketDispatcher.setPoolMin((int)pool.getMin());
                JeusSocketDispatcher.setPoolMax((int)pool.getMax());
                JeusSocketDispatcher.setPoolPeriod((long)pool.getPeriod());
            }
        }
    }
}

