/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.cluster;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.NodeInfo;
import jeus.security.util.LoginUtil;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.ResurrectionEventListener;
import jeus.server.cluster.BeaconReceiver;
import jeus.server.cluster.ClusterPacket;
import jeus.util.ErrorMsgManager;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusNodeClusterProperties;

public class NodeEntry
implements SocketID {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.clustering");
    private static final ResurrectionEventListener[] RESURRECTION_EVENT_LISTENER = new ResurrectionEventListener[0];
    public static final int INACTIVE = 0;
    public static final int RUNNING = 1;
    public static final int FAILED = 2;
    private int status = 0;
    private final NodeInfo nodeInfo;
    private final String thisNodeName;
    private final String targetNodeName;
    private JeusServer server;
    private boolean responsibleBackup;
    private boolean isBeaconReplyReceived;
    private boolean isAlwaysNeedConnection;
    private SocketStream sockStream;
    private boolean connectionEstablished;
    private final Object connectionLock = new Object();
    private final Object statusLock = new Object();

    public NodeEntry(String targetNodeName, String thisNodeName, JeusServer server, boolean needBackup, NodeInfo nodeInfo) {
        this.nodeInfo = new NodeInfo(nodeInfo.getHost(), nodeInfo.getBasePort(), "BeaconHandler");
        this.targetNodeName = targetNodeName;
        this.thisNodeName = thisNodeName;
        this.responsibleBackup = needBackup;
        this.server = server;
        if (targetNodeName.equals(thisNodeName)) {
            this.status = 1;
        }
    }

    public NodeEntry(String nodeName, String serverName, JeusServer server, boolean needBackup) {
        this(nodeName, serverName, server, needBackup, VirtualDNS.getNodeInfo(nodeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishConnection(BeaconReceiver receiver) throws IOException, InterruptedIOException {
        if (logger.isLoggable(JeusMessage_Manager1._415_LEVEL)) {
            logger.log(JeusMessage_Manager1._415_LEVEL, JeusMessage_Manager1._415, (Object)this);
        }
        try {
            SocketStream trySockStream = receiver.connect(this);
            if (trySockStream == null) {
                throw new JeusServerException("Not connected to the node " + this.targetNodeName);
            }
            Object object = this.connectionLock;
            synchronized (object) {
                this.sockStream = trySockStream;
                this.setStatus(1);
                this.connectionEstablished = true;
            }
            if (logger.isLoggable(JeusMessage_Manager1._418_LEVEL)) {
                logger.log(JeusMessage_Manager1._418_LEVEL, JeusMessage_Manager1._418, (Object)this);
            }
        }
        catch (Throwable ex3) {
            if (logger.isLoggable(JeusMessage_Manager1._419_LEVEL)) {
                logger.log(JeusMessage_Manager1._419_LEVEL, JeusMessage_Manager1._419, (Object)this, ex3);
            }
            this.setStatus(2);
            throw new JeusServerException(JeusMessage_Manager._349, ex3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setStatus(int newStatus) {
        var2_2 = this.statusLock;
        synchronized (var2_2) {
            prevStatus = this.status;
            if (!this.isValidState(prevStatus, newStatus)) {
                return;
            }
            this.status = newStatus;
            switch (newStatus) {
                case 2: {
                    this.close();
                    JeusServer.jeusManager.sendNotification("jeus.manger.cluster.failed", "The node " + this.targetNodeName + " is failed", (Serializable)this.targetNodeName);
                    try {
                        msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_Manager._275, (Object[])new String[]{this.targetNodeName, this.thisNodeName});
                        if (this.responsibleBackup) {
                            msg = msg + ErrorMsgManager.getLocalizedString((int)JeusMessage_Manager._276);
                        }
                        if (NodeEntry.logger.isLoggable(Level.SEVERE)) {
                            NodeEntry.logger.sendEmailNotification(Level.SEVERE, msg);
                        }
                    }
                    catch (Throwable ex) {
                        if (!NodeEntry.logger.isLoggable(JeusMessage_Manager._257_LEVEL)) ** GOTO lbl22
                        NodeEntry.logger.log(JeusMessage_Manager._257_LEVEL, JeusMessage_Manager._257, ex);
                    }
lbl22:
                    // 3 sources

                    if (!this.responsibleBackup) break;
                    LoginUtil.loginCodeSubjectWithRuntimeException();
                    try {
                        this.server.backup(this.targetNodeName);
                    }
                    finally {
                        LoginUtil.logoutWithRuntimeException();
                    }
                    JeusServer.jeusManager.sendNotification("jeus.manger.cluster.backup.failed", "The backup node " + this.targetNodeName + " is failed", (Serializable)this.targetNodeName);
                    break;
                }
                case 1: {
                    if (this.responsibleBackup) {
                        NodeEntry.logger.log(JeusMessage_Manager1._519_LEVEL, JeusMessage_Manager1._519, (Object)this.targetNodeName);
                        JeusServer.jeusManager.sendNotification("jeus.manger.cluster.backup.resurrected", "The backup node " + this.targetNodeName + " is resurrected", (Serializable)this.targetNodeName);
                        if (this.server.isBackupRunning() && JeusManagerProperties.DOWN_FOR_PRIMARY_BOOT) {
                            NodeEntry.logger.log(JeusMessage_Manager1._520_LEVEL, JeusMessage_Manager1._520, (Object)this.targetNodeName);
                            LoginUtil.loginCodeSubjectWithRuntimeException();
                            try {
                                this.server.down();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            finally {
                                LoginUtil.logoutWithRuntimeException();
                            }
                        }
                    }
                    listeners = JeusServer.resurrectEventListeners.toArray(NodeEntry.RESURRECTION_EVENT_LISTENER);
                    for (i = 0; i < listeners.length; ++i) {
                        listener = listeners[i];
                        try {
                            if (NodeEntry.logger.isLoggable(JeusMessage_Manager1._420_LEVEL)) {
                                NodeEntry.logger.log(JeusMessage_Manager1._420_LEVEL, JeusMessage_Manager1._420, (Object)this.targetNodeName);
                            }
                            listener.resurrectionEventOccurred(this.targetNodeName);
                            continue;
                        }
                        catch (Throwable ex) {
                            if (!NodeEntry.logger.isLoggable(JeusMessage_Manager._258_LEVEL)) continue;
                            NodeEntry.logger.log(JeusMessage_Manager._268_LEVEL, JeusMessage_Manager._268, ex);
                        }
                    }
                    JeusServer.jeusManager.sendNotification("jeus.manger.cluster.resurrected", "The node " + this.targetNodeName + " is resurrected", (Serializable)this.targetNodeName);
                    break;
                }
                case 0: {
                    this.close();
                    JeusServer.jeusManager.sendNotification("jeus.manger.cluster.downed", "The node " + this.targetNodeName + " is downed", (Serializable)this.targetNodeName);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    private boolean isValidState(int prevStatus, int newStatus) {
        if (prevStatus == newStatus) {
            return false;
        }
        return prevStatus == 1 || newStatus == 1;
    }

    public String getTargetNodeName() {
        return this.targetNodeName;
    }

    public int getStatus() {
        return this.status;
    }

    public static void checkStatus(NodeEntry[] nodeEntries, BeaconReceiver receiver) {
        NodeEntry nodeEntry;
        ArrayList<NodeEntry> list = null;
        for (int i = 0; i < nodeEntries.length; ++i) {
            nodeEntry = nodeEntries[i];
            if (!nodeEntry.isOtherNode()) continue;
            if (nodeEntry.isConnectionEstablished()) {
                if (list == null) {
                    list = new ArrayList<NodeEntry>();
                }
                try {
                    nodeEntry.sendBeacon();
                    list.add(nodeEntry);
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(JeusMessage_Manager1._440_LEVEL)) continue;
                    logger.log(JeusMessage_Manager1._440_LEVEL, JeusMessage_Manager1._440, (Object)nodeEntry, (Throwable)ex);
                }
                continue;
            }
            if (!nodeEntry.needConnection() && !nodeEntry.isAlwaysNeedConnection()) continue;
            try {
                nodeEntry.establishConnection(receiver);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(JeusNodeClusterProperties.CLUSTER_REPLY_READ_TIMEOUT);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                nodeEntry = (NodeEntry)list.get(i);
                nodeEntry.receiveBeaconReply();
            }
        }
    }

    public boolean needConnection() {
        return this.targetNodeName.compareTo(this.thisNodeName) > 0;
    }

    private boolean isConnectionEstablished() {
        return this.connectionEstablished;
    }

    private boolean isOtherNode() {
        return !this.targetNodeName.equals(this.thisNodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBeacon() {
        block6: {
            if (logger.isLoggable(JeusMessage_Manager1._421_LEVEL)) {
                logger.log(JeusMessage_Manager1._421_LEVEL, JeusMessage_Manager1._421, (Object)this.targetNodeName);
            }
            try {
                Object object = this.connectionLock;
                synchronized (object) {
                    this.sockStream.write(ClusterPacket.beacon_byte);
                }
            }
            catch (IOException ex5) {
                this.setStatus(2);
                if (!logger.isLoggable(JeusMessage_Manager1._404_LEVEL)) break block6;
                logger.log(JeusMessage_Manager1._404_LEVEL, JeusMessage_Manager1._404, (Object)this.targetNodeName);
            }
        }
    }

    private boolean receiveBeaconReply() {
        if (logger.isLoggable(JeusMessage_Manager1._422_LEVEL)) {
            logger.log(JeusMessage_Manager1._422_LEVEL, JeusMessage_Manager1._422, (Object)this);
        }
        if (!this.isBeaconReplyReceived) {
            if (logger.isLoggable(JeusMessage_Manager1._424_LEVEL)) {
                logger.log(JeusMessage_Manager1._424_LEVEL, JeusMessage_Manager1._424, (Object)this);
            }
            this.setStatus(2);
            return false;
        }
        if (logger.isLoggable(JeusMessage_Manager1._423_LEVEL)) {
            logger.log(JeusMessage_Manager1._423_LEVEL, JeusMessage_Manager1._423, (Object)this);
        }
        this.isBeaconReplyReceived = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (logger.isLoggable(JeusMessage_Manager1._425_LEVEL)) {
            logger.log(JeusMessage_Manager1._425_LEVEL, JeusMessage_Manager1._425, (Object)this);
        }
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                if (this.sockStream != null) {
                    this.sockStream.destroy();
                    this.sockStream = null;
                }
            }
            finally {
                this.connectionEstablished = false;
            }
        }
    }

    public void setReplied() {
        this.isBeaconReplyReceived = true;
        this.setStatus(1);
    }

    public void setAlwaysNeedConnection() {
        this.isAlwaysNeedConnection = true;
    }

    public boolean isAlwaysNeedConnection() {
        return this.isAlwaysNeedConnection;
    }

    public String getHost() {
        return this.nodeInfo.getHost();
    }

    public int getBasePort() {
        return this.nodeInfo.getBasePort();
    }

    public boolean needConnect(SocketID socketID) {
        return this.nodeInfo.needConnect(socketID);
    }

    public String getVirtualID() {
        return this.nodeInfo.getVirtualID();
    }

    public int getConnectionType() {
        return this.nodeInfo.getConnectionType();
    }

    public void setConnectionType(int type) {
        this.nodeInfo.setConnectionType(type);
    }

    public String toString() {
        return "NodeEntry[nodeInfo : " + this.nodeInfo + ", status : " + this.getStatusString() + ", id : " + super.toString() + "]";
    }

    private String getStatusString() {
        return NodeEntry.getStatusString(this.status);
    }

    private static String getStatusString(int status) {
        switch (status) {
            case 0: {
                return "INACTIVE";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "FAILED";
            }
        }
        throw new RuntimeException();
    }

    public void setNotConnectable() {
    }

    public boolean isNotConnectable() {
        return false;
    }
}

