/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.cluster;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import jeus.net.AcceptorConnectionListener;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.server.cluster.BeaconReceiver;
import jeus.server.cluster.ClusterPacket;
import jeus.server.cluster.NodeEntry;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusNodeClusterProperties;

public class NodeServerEntry
implements AcceptorConnectionListener {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private BeaconReceiver receiver;
    private NodeEntry nodeEntry;

    public NodeServerEntry(Socket sock, BeaconReceiver receiver) throws IOException {
        this.receiver = receiver;
        sock.setSoTimeout(JeusNodeClusterProperties.CLUSTER_READ_TIMEOUT);
    }

    public String toString() {
        return this.nodeEntry + ", addr : " + super.toString();
    }

    public void setNodeEntry(NodeEntry nodeEntry) {
        this.nodeEntry = nodeEntry;
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (exception != null) {
            if (logger.isLoggable(JeusMessage_Manager1._513_LEVEL)) {
                logger.log(JeusMessage_Manager1._513_LEVEL, JeusMessage_Manager1._513, (Object)this.nodeEntry, (Throwable)exception);
            }
            if (this.nodeEntry != null) {
                this.nodeEntry.setStatus(2);
            }
        } else {
            if (logger.isLoggable(JeusMessage_Manager1._514_LEVEL)) {
                logger.log(JeusMessage_Manager1._514_LEVEL, JeusMessage_Manager1._514, (Object)this.nodeEntry);
            }
            if (this.nodeEntry != null) {
                this.nodeEntry.setStatus(0);
            }
        }
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) {
        NodeEntry entry = this.receiver.getNodeEntry(sockStream.getSocketID());
        ((NodeServerEntry)sockStream.getListener()).setNodeEntry(entry);
        entry.setStatus(1);
        if (logger.isLoggable(JeusMessage_Manager1._515_LEVEL)) {
            logger.log(JeusMessage_Manager1._515_LEVEL, JeusMessage_Manager1._515, (Object)this.nodeEntry);
        }
    }

    public void receiveMessage(Object obj, SocketStream sockStream, Object controlInfo) {
        byte result = ((byte[])obj)[0];
        if (logger.isLoggable(JeusMessage_Manager1._430_LEVEL)) {
            logger.log(JeusMessage_Manager1._430_LEVEL, JeusMessage_Manager1._430, new Object[]{new Byte(result), this});
        }
        try {
            if (result == ClusterPacket.beacon) {
                sockStream.write(ClusterPacket.beaconReply_byte);
                if (logger.isLoggable(JeusMessage_Manager1._431_LEVEL)) {
                    logger.log(JeusMessage_Manager1._431_LEVEL, JeusMessage_Manager1._431, (Object)this);
                }
            } else if (result == ClusterPacket.beaconReply) {
                if (logger.isLoggable(JeusMessage_Manager1._432_LEVEL)) {
                    logger.log(JeusMessage_Manager1._432_LEVEL, JeusMessage_Manager1._432, (Object)this);
                }
                this.nodeEntry.setReplied();
            }
        }
        catch (InterruptedIOException exc) {
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_Manager1._435_LEVEL)) {
                logger.log(JeusMessage_Manager1._435_LEVEL, JeusMessage_Manager1._435, (Object)this, (Throwable)ex);
            }
            this.connectionClosed(ex, sockStream);
        }
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        messageProcessor.run();
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void connectionEstablished(SocketStream sockStream) {
    }

    public void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        NodeEntry entry = this.receiver.getNodeEntry(sockStream.getSocketID());
        ((NodeServerEntry)sockStream.getListener()).setNodeEntry(entry);
        entry.setStatus(1);
        if (logger.isLoggable(JeusMessage_Manager1._516_LEVEL)) {
            logger.log(JeusMessage_Manager1._516_LEVEL, JeusMessage_Manager1._516, (Object)this.nodeEntry);
        }
        sockStream.write((Object)packet);
    }

    public void receiveRequest(Object message, SocketStream socketStream, int skipOffset) {
        throw new RuntimeException();
    }
}

