/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.enginecontainer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.xml.bind.JAXBElement;
import jeus.deploy.JeusDeploymentException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.io.runtime.ApplicationRuntimeDDFile;
import jeus.deploy.util.ContainerAutoDeployTask;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.ejb.ejbserver.EJBORBManager;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.jndi.jns.local.JNSLocal;
import jeus.jndi.jns.local.Service;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.ClusterChecker;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.J2EEDeployedObjectMBean;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEServer;
import jeus.management.j2ee.JDBCResource;
import jeus.management.j2ee.JVM;
import jeus.management.j2ee.manager.JeusProcess;
import jeus.rmi.http.JEUSCheck;
import jeus.security.base.Environment;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoginUtil;
import jeus.server.CommonProcessInitializer;
import jeus.server.JeusServerException;
import jeus.server.NodeControllerStub;
import jeus.server.RootClassLoader;
import jeus.server.enginecontainer.DownThread;
import jeus.server.enginecontainer.EngineContainerException;
import jeus.server.enginecontainer.InvocationManager;
import jeus.server.enginecontainer.ResourceManager;
import jeus.server.enginecontainer.StartThread;
import jeus.server.service.CPUMonitorService;
import jeus.server.service.ExternalResourceHandler;
import jeus.server.service.JMXExportService;
import jeus.server.service.JMXExportServiceMBean;
import jeus.server.service.JeusLogService;
import jeus.server.service.NodeListService;
import jeus.server.service.SchedulerService;
import jeus.server.service.SchedulerServiceMBean;
import jeus.server.util.EngineSync;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryManager;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.servlet.common.WebContainerManager;
import jeus.transaction.TMException;
import jeus.transaction.TMService;
import jeus.util.CUtility;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusPooledExecutorFactory;
import jeus.util.JeusPrintStream;
import jeus.util.JeusProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.JeusRuntimeException;
import jeus.util.Logger;
import jeus.util.PooledExecutorFactory;
import jeus.util.ScheduledExecutor;
import jeus.util.StatisticRefinedThreadPoolExecutor;
import jeus.util.StringUtil;
import jeus.util.UserLogger;
import jeus.util.VirtualDNS;
import jeus.util.cnet.NetUtil;
import jeus.util.logging.JeusLogManager;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.message.JeusMessage_EJB8;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.net.JeusSocketDispatcher;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusNetProperties;
import jeus.util.properties.JeusPropertyValues;
import jeus.util.properties.JeusSecurityProperties;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.AutoDeployType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.InvocationType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.LibraryRefType;
import jeus.xml.binding.jeusDD.LifecycleInvocationType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.MethodParamsType;
import jeus.xml.binding.jeusDD.SecurityDomainType;
import jeus.xml.binding.jeusDD.WebComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineContainer
implements JeusProcess,
ClusterChecker {
    public static EngineContainer container = null;
    private static final String fs = System.getProperty("file.separator");
    public static String nodeName;
    private Vector engineList = new Vector();
    private boolean isJMXManagerStarted = false;
    private static EngineContainerDescriptor desc;
    public static FileArchive jeusArchive;
    public static FileArchive containerModuleArchive;
    private static final String GENERATED_DIR = "_generated_";
    private static final String GENERATED_MODULES_DIR = "j2ee-modules";
    private static final String GENERATED_APPS_DIR = "j2ee-apps";
    private static FileArchive generatedDirArchive;
    private static FileArchive generatedAppsDirArchive;
    private static FileArchive generatedModulesDirArchive;
    public static EJBRootClassLoader rootClassLoader;
    public static J2EEServer serverMBean;
    public static JDBCResource jdbcResourceMBean;
    public static SchedulerServiceMBean schedulerMBean;
    public static JMXExportServiceMBean jmxExport;
    public static String partialContainerName;
    private ContainerAutoDeployTask task;
    private static String servletEngineName;
    protected static JeusLogger logger;
    private AtomicBoolean running = new AtomicBoolean(false);
    public Object waitForDownLock = new Object();
    public static NodeListService nodeListServiceMBean;
    private InitialContext initialCtx;
    private List resourceRefs;
    private static boolean ORBinitiated;
    private boolean isOverrideDeployhome;
    private Map lifecycleClassMap = new HashMap();
    private ExternalResourceHandler externalResourceHandler = new ExternalResourceHandler();

    protected EngineContainer() {
    }

    public EngineContainer(String[] args, JeusMainDescriptor mdesc) throws EngineContainerException {
        this.init(args, mdesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void init(String[] args, JeusMainDescriptor mdesc) throws EngineContainerException {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        EngineContainer.container = this;
        try {
            CommonProcessInitializer.configJeusSocketDispatcher(mdesc);
            if (JeusManagerProperties.USE_LISTEN_PORT_PER_CONTAINER) {
                JeusSocketDispatcher.setListenPort((int)JeusManagerPropertyValues.getContainerBasePort());
                useActiveDispatcher = true;
            } else {
                useActiveDispatcher = false;
            }
            JeusSocketDispatcher.start((boolean)useActiveDispatcher);
        }
        catch (Exception ex) {
            throw new EngineContainerException(JeusMessage_Manager.MGR_395, (Throwable)ex);
        }
        if (!JeusManagerPropertyValues.isDefaultContainer) {
            env = Environment.getSlaveConfiguration();
            system = mdesc.getJeusSystem();
            securityManagerType = system.getSecurityManager();
            if (securityManagerType != null) {
                env.enableNIO = securityManagerType.isUseNio();
                if (securityManagerType.isSetConnectRetries()) {
                    env.setRetries(securityManagerType.getConnectRetries());
                }
                if ((securityDomainsType = securityManagerType.getSecurityDomains()) != null) {
                    domains = securityDomainsType.getSecurityDomain();
                    iter = domains.iterator();
                    domainNames = new ArrayList<String>();
                    while (iter.hasNext()) {
                        securityDomainType = (SecurityDomainType)iter.next();
                        env.getDomainsInfoMap().put(securityDomainType.getName(), securityDomainType);
                        domainNames.add(securityDomainType.getName());
                    }
                    env.domains = domainNames.toArray(new String[domainNames.size()]);
                }
            }
            try {
                SecurityInstaller.installSecurity(env);
            }
            catch (Throwable e) {
                throw new JeusRuntimeException(e);
            }
        }
        sequentialStart = EngineContainer.desc.isSequentialStart();
        processedStep = 0;
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            ResourceManager.startTimer();
            InvocationManager.init(EngineContainer.desc.getInvocationManagerAction());
            if (!JeusManagerPropertyValues.isDefaultContainer) {
                try {
                    securityon = Boolean.valueOf(System.getProperty("jeus.security.enable", "true"));
                    if (securityon) {
                        if (EngineContainer.logger.isLoggable(JeusMessage_Manager.MGR_63_LEVEL)) {
                            EngineContainer.logger.log(JeusMessage_Manager.MGR_63_LEVEL, JeusMessage_Manager.MGR_63);
                        }
                    } else {
                        SecurityInstaller.disableSecurity();
                        if (EngineContainer.logger.isLoggable(JeusMessage_Manager.MGR_64_LEVEL)) {
                            EngineContainer.logger.log(JeusMessage_Manager.MGR_64_LEVEL, JeusMessage_Manager.MGR_64);
                        }
                    }
                }
                catch (Exception e) {
                    throw new EngineContainerException(JeusMessage_Manager.MGR_65, (Throwable)e);
                }
                processedStep = 1;
                J2EEManagedObject.setMEJBUtilityEnable();
                processedStep = 2;
                try {
                    JMXManager.init(EngineContainer.desc.getJMXManagerDescriptor(), JeusManagerPropertyValues.containerName, false);
                    this.isJMXManagerStarted = true;
                    JMXManager.exportJMXManager(JeusManagerPropertyValues.containerName, true);
                }
                catch (Throwable ex) {
                    throw new EngineContainerException(JeusMessage_Manager.MGR_66, ex);
                }
            }
            jeusManagerMo = this.getJeusManagerMo();
            try {
                EngineContainer.serverMBean = (J2EEServer)J2EEServer.createMBean(JeusManagerPropertyValues.containerName, jeusManagerMo, this);
                JeusManagerPropertyValues.serverMBeanObjectName = EngineContainer.serverMBean.getObjectName();
                JVM.createMBean(JeusManagerPropertyValues.containerName, EngineContainer.serverMBean.getObjectName(), this);
                if (!JeusManagerPropertyValues.isDefaultContainer) {
                    JMXUtility.setNodeObjectName(EngineContainer.serverMBean.getObjectName());
                    StatisticRefinedThreadPoolExecutor.addThreadPoolMBeans();
                    JeusLogService.createMBean(JeusManagerPropertyValues.containerName, EngineContainer.serverMBean.getObjectName(), null);
                    jmxObject = JMXExportService.createMBean(JeusManagerPropertyValues.containerName, EngineContainer.serverMBean.getObjectName(), this);
                    ((JMXExportService)jmxObject).isContainer = true;
                    EngineContainer.jmxExport = JMXUtility.getProxy((MBeanServerConnection)JMXManager.getMbeanServer(), jmxObject.getObjectName(), JMXExportServiceMBean.class, false);
                    SecurityInstaller.registerMBean(EngineContainer.serverMBean.getObjectName());
                }
                EngineContainer.jdbcResourceMBean = (JDBCResource)JDBCResource.createMBean(JeusManagerPropertyValues.containerName, EngineContainer.serverMBean.getObjectName(), this);
            }
            catch (Exception e) {
                if (EngineContainer.serverMBean != null) {
                    EngineContainer.serverMBean.destroyMBean();
                }
                throw new JeusRuntimeException(JeusMessage_Manager.MGR_67, (Throwable)e);
            }
            if (EngineContainer.logger.isLoggable(JeusMessage_Manager.MGR_68_LEVEL)) {
                EngineContainer.logger.log(JeusMessage_Manager.MGR_68_LEVEL, JeusMessage_Manager.MGR_68, (Object)JeusManagerPropertyValues.containerName);
            }
            EngineContainer.nodeListServiceMBean = (NodeListService)NodeListService.createMBean(JeusManagerPropertyValues.containerName, EngineContainer.serverMBean.getObjectName(), EngineContainer.serverMBean.getParentObjectName());
            processedStep = 3;
            if (!EngineContainer.ORBinitiated) {
                enableInteropType = EngineContainer.desc.getEnableInterop();
                v0 = enableInterop = enableInteropType != null;
                if (enableInterop) {
                    EJBORBManager.init(true, enableInteropType.getInteropSslConfig());
                } else {
                    EJBORBManager.init(false, null);
                }
                EngineContainer.ORBinitiated = true;
            }
            try {
                if (!JeusManagerPropertyValues.isDefaultContainer) {
                    JMXManager.exportSNMPAdaptor(EngineContainer.desc.getJMXManagerDescriptor(), true, JeusManagerPropertyValues.containerName);
                }
                TMService.init(EngineContainer.desc.getTransactionManagerDescriptor());
            }
            catch (TMException ex) {
                throw new EngineContainerException(JeusMessage_Manager.MGR_69, (Throwable)ex);
            }
            EJBORBManager.startOTSRecovery();
            processedStep = 4;
            schedulerMo = SchedulerService.createMBean(JeusManagerPropertyValues.containerName, EngineContainer.serverMBean.getObjectName(), this);
            EngineContainer.schedulerMBean = JMXUtility.getProxy((MBeanServerConnection)JMXManager.getMbeanServer(), schedulerMo.getObjectName(), SchedulerServiceMBean.class, false);
            EngineContainer.schedulerMBean.startService(EngineContainer.desc, this);
            processedStep = 5;
            cpuMonitorService = CPUMonitorService.getInstance();
            cpuMonitorService.startService(EngineContainer.desc, this);
            processedStep = 6;
            this.initRootClassLoader();
            this.registerResourceRefs();
            this.invokeMethod("BOOT");
            EngineContainer.serverMBean.sendNotification("jeus.enginecontainer.boot", "container booted", (Serializable)JeusManagerPropertyValues.containerName);
            sync = null;
            if (!sequentialStart) {
                sync = new EngineSync(args.length - 1);
            }
            for (i = 1; i < args.length; ++i) {
                engineName = args[i];
                try {
                    if (sequentialStart) {
                        sync = new EngineSync(1);
                        this.innerStartEngine(engineName, sync);
                        sync.waiting();
                        if (sync.getList().size() != 1) continue;
                        this.engineList.add(engineName);
                        continue;
                    }
                    this.innerStartEngine(engineName, sync);
                    continue;
                }
                catch (Throwable t) {
                    if (!EngineContainer.logger.isLoggable(JeusMessage_Manager.MGR_71_LEVEL)) continue;
                    EngineContainer.logger.log(JeusMessage_Manager.MGR_71_LEVEL, JeusMessage_Manager.MGR_71, (Object)engineName, t);
                }
            }
            if (!sequentialStart) {
                sync.waiting();
                this.engineList = sync.getList();
            }
            if (this.engineList.size() == 0) {
                throw new EngineContainerException(JeusMessage_Manager._72);
            }
            this.invokeMethod("BEFORE_DEPLOY");
            EngineContainer.serverMBean.sendNotification("jeus.enginecontainer.prestart", "container starting", null);
            this.deployApp();
            this.invokeMethod("AFTER_DEPLOY");
            EngineContainer.serverMBean.sendNotification("jeus.enginecontainer.poststart", "container started", null);
            this.invokeMethod("READY");
            if (EngineContainer.logger.isLoggable(JeusMessage_Manager._73_LEVEL)) {
                EngineContainer.logger.log(JeusMessage_Manager._73_LEVEL, JeusMessage_Manager._73, (Object)JeusManagerPropertyValues.containerName);
            }
        }
        catch (Throwable ex) {
            this.invokeMethod("BEFORE_UNDEPLOY");
            EngineContainer.undeployApp(null);
            this.invokeMethod("AFTER_UNDEPLOY");
            switch (processedStep) {
                case 6: {
                    try {
                        cpuMonitorService = CPUMonitorService.getInstance();
                        if (cpuMonitorService.isStarted()) {
                            cpuMonitorService.stopService();
                        }
                    }
                    catch (Throwable t) {
                        if (!EngineContainer.logger.isLoggable(JeusMessage_Manager1._517_LEVEL)) ** GOTO lbl171
                        EngineContainer.logger.log(JeusMessage_Manager1._517_LEVEL, JeusMessage_Manager1._517, t);
                    }
                }
lbl171:
                // 4 sources

                case 5: {
                    try {
                        if (EngineContainer.schedulerMBean != null) {
                            EngineContainer.schedulerMBean.stopService();
                        }
                    }
                    catch (Throwable t) {
                        if (!EngineContainer.logger.isLoggable(JeusMessage_Manager._74_LEVEL)) ** GOTO lbl179
                        EngineContainer.logger.log(JeusMessage_Manager._74_LEVEL, JeusMessage_Manager._74, t);
                    }
                }
lbl179:
                // 4 sources

                case 4: {
                    try {
                        TMService.shutdown();
                    }
                    catch (Throwable t) {
                        if (!EngineContainer.logger.isLoggable(JeusMessage_Manager._75_LEVEL)) ** GOTO lbl186
                        EngineContainer.logger.log(JeusMessage_Manager._75_LEVEL, JeusMessage_Manager._75, t);
                    }
                }
lbl186:
                // 4 sources

                case 3: {
                    try {
                        if (EngineContainer.serverMBean != null) {
                            EngineContainer.serverMBean.destroyMBean();
                        }
                        if (this.isJMXManagerStarted) {
                            JMXManager.stop();
                        }
                    }
                    catch (Throwable t) {
                        if (EngineContainer.logger.isLoggable(JeusMessage_Manager._76_LEVEL)) {
                            EngineContainer.logger.log(JeusMessage_Manager._76_LEVEL, JeusMessage_Manager._76, t);
                        }
                    }
                    finally {
                        this.isJMXManagerStarted = false;
                    }
                }
                case 0: {
                    if (JeusManagerPropertyValues.isDefaultContainer) break;
                    try {
                        SecurityInstaller.uninstallSecurity();
                        if (!EngineContainer.logger.isLoggable(JeusMessage_Manager._77_LEVEL)) break;
                        EngineContainer.logger.log(JeusMessage_Manager._77_LEVEL, JeusMessage_Manager._77);
                        break;
                    }
                    catch (Exception e) {
                        if (!EngineContainer.logger.isLoggable(JeusMessage_Manager._78_LEVEL)) break;
                        EngineContainer.logger.log(JeusMessage_Manager._78_LEVEL, JeusMessage_Manager._78, (Throwable)e);
                    }
                }
            }
            throw new EngineContainerException(JeusMessage_Manager._79, JeusManagerPropertyValues.containerName, ex);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    protected static JeusMainDescriptor initConfiguration(boolean isDefaultContainer, String[] args) throws EngineContainerException {
        JeusMainDescriptor mdesc;
        JeusManagerPropertyValues.isDefaultContainer = isDefaultContainer;
        try {
            JEUSCheck.isJEUS = true;
            nodeName = StringUtil.getNodeNameFromContainerName((String)JeusManagerPropertyValues.containerName);
            partialContainerName = StringUtil.getEngineContainerNameFromContainerName((String)JeusManagerPropertyValues.containerName);
            if (JeusBootstrapProperties.JEUS_HOME == null) {
                throw new EngineContainerException(JeusMessage_Manager.MGR_2);
            }
            jeusArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)JeusBootstrapProperties.JEUS_HOME);
            AbstractArchive archive = jeusArchive.getEmbeddedArchive("webhome" + File.separator + JeusManagerPropertyValues.containerName);
            if (!(archive instanceof FileArchive)) {
                throw new IllegalJeusSystemNameException("The file " + archive.getArchiveUri() + " is not directory, maybe the container name is not correct");
            }
            containerModuleArchive = (FileArchive)archive;
            generatedDirArchive = (FileArchive)containerModuleArchive.getEmbeddedArchive(GENERATED_DIR);
            generatedAppsDirArchive = (FileArchive)generatedDirArchive.getEmbeddedArchive(GENERATED_APPS_DIR);
            generatedModulesDirArchive = (FileArchive)generatedDirArchive.getEmbeddedArchive(GENERATED_MODULES_DIR);
        }
        catch (Throwable t) {
            throw new EngineContainerException(JeusMessage_Manager.MGR_60, t);
        }
        try {
            mdesc = JeusMainDescriptorJB.getJeusMainDescriptor(nodeName);
            desc = (EngineContainerDescriptor)mdesc.engineContainers.get(JeusManagerPropertyValues.containerName);
            if (!isDefaultContainer) {
                desc.initContainerLogging();
                switch (desc.getLogDestination()) {
                    case 0: {
                        Logger.createLogger("", 0);
                        break;
                    }
                    case 1: {
                        Logger.createLogger(JeusBootstrapProperties.JEUS_HOME + fs + "logs" + fs + "JeusServer" + fs + JeusManagerPropertyValues.containerName + fs + JeusManagerPropertyValues.containerName, desc.getLogBufferSize());
                        break;
                    }
                    case 2: {
                        Logger.createLogger("stdout:" + JeusBootstrapProperties.JEUS_HOME + fs + "logs" + fs + "JeusServer" + fs + JeusManagerPropertyValues.containerName + fs + JeusManagerPropertyValues.containerName, desc.getLogBufferSize());
                        break;
                    }
                }
            } else {
                logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
            }
            desc.initUserLogging();
            if (logger.isLoggable(JeusMessage_Manager.MGR_61_LEVEL)) {
                logger.log(JeusMessage_Manager.MGR_61_LEVEL, JeusMessage_Manager.MGR_61);
            }
        }
        catch (Throwable ex) {
            throw new EngineContainerException(JeusMessage_Manager.MGR_62, ex);
        }
        return mdesc;
    }

    private void initRootClassLoader() throws EJBServerException {
        try {
            EJBRootClassLoader loader;
            if (!EJBRootClassLoader.isInitialized()) {
                loader = (EJBRootClassLoader)((RootClassLoader)JeusRootClassLoader.loader).getEJBRootClassLoader();
                EJBRootClassLoader.setInitialized();
            } else {
                loader = (EJBRootClassLoader)((RootClassLoader)JeusRootClassLoader.loader).removeEJBRootClassLoader();
                loader.clear();
                loader = new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, JeusManagerPropertyValues.containerName);
                ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(loader);
            }
            rootClassLoader = loader;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB8._5079_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5079_LEVEL, "EJBServer", "initRootClassLoader", JeusMessage_EJB8._5079, ex);
            }
            throw new EJBServerException(JeusMessage_EJB8._5079, ex);
        }
    }

    private void invokeMethod(String invocationType) {
        List invokeList = desc.getLifecycleInvocation();
        for (int i = 0; i < invokeList.size(); ++i) {
            try {
                LifecycleInvocationType lifecycleInvocationType = (LifecycleInvocationType)invokeList.get(i);
                String className = lifecycleInvocationType.getClassName();
                Class<?> appClass = (Class<?>)this.lifecycleClassMap.get(lifecycleInvocationType);
                List invocationList = lifecycleInvocationType.getInvocation();
                for (int j = 0; j < invocationList.size(); ++j) {
                    try {
                        Class[] paramClasses;
                        MethodParamType method;
                        MethodParamsType paramsType;
                        InvocationType type = (InvocationType)invocationList.get(j);
                        if (!type.getInvocationType().value().equals(invocationType)) continue;
                        if (appClass == null) {
                            ClassLoader loader;
                            if (lifecycleInvocationType.isSetLibraryRef()) {
                                List list = lifecycleInvocationType.getLibraryRef();
                                ArrayList<LibraryRef> libraryRefList = new ArrayList<LibraryRef>();
                                for (LibraryRefType r : list) {
                                    libraryRefList.add(new LibraryRef(r));
                                }
                                loader = this.createClassLoaderForLibrary(libraryRefList, className);
                            } else {
                                loader = JeusRootClassLoader.loader;
                            }
                            appClass = loader.loadClass(className);
                            this.lifecycleClassMap.put(lifecycleInvocationType, appClass);
                        }
                        if ((paramsType = (method = type.getInvocationMethod()).getMethodParams()) != null) {
                            List params = paramsType.getMethodParam();
                            paramClasses = new Class[params.size()];
                            for (int k = 0; k < params.size(); ++k) {
                                String paramName = (String)params.get(k);
                                paramClasses[k] = StringUtil.getClassFromString((String)paramName, (ClassLoader)JeusRootClassLoader.loader);
                                if (paramClasses[k].isPrimitive() || paramClasses[k] == String.class || paramClasses[k].isArray() && paramClasses[k].getComponentType() == String.class) continue;
                                throw new EJBServerException(JeusMessage_EJB8._5087, paramClasses[k].getName());
                            }
                        } else {
                            paramClasses = new Class[]{};
                        }
                        Method invokeMethod = appClass.getMethod(method.getMethodName(), paramClasses);
                        Object[] args = jeus.ejb.util.StringUtil.getArgumentObjectsFromString(paramClasses, type.getInvocationArgument());
                        if (Modifier.isStatic(invokeMethod.getModifiers())) {
                            invokeMethod.invoke(null, args);
                            continue;
                        }
                        invokeMethod.invoke(appClass.newInstance(), args);
                        continue;
                    }
                    catch (Exception ex) {
                        if (!logger.isLoggable(JeusMessage_Manager1._408_LEVEL)) continue;
                        logger.log(JeusMessage_Manager1._408_LEVEL, JeusMessage_Manager1._408, (Throwable)ex);
                    }
                }
                continue;
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_Manager1._408_LEVEL)) continue;
                logger.log(JeusMessage_Manager1._408_LEVEL, JeusMessage_Manager1._408, (Throwable)ex);
            }
        }
    }

    private ClassLoader createClassLoaderForLibrary(List<LibraryRef> libraryRefList, String className) throws JeusDeploymentException {
        LibraryManager libraryManager = LibraryManager.getInstance();
        libraryManager.refresh();
        ArrayList<AbstractArchive> classpathArchiveList = new ArrayList<AbstractArchive>();
        for (LibraryRef libraryRef : libraryRefList) {
            try {
                List<ClassPathEntry> entries = libraryManager.getClassPathEntries(libraryRef);
                if (entries == null) continue;
                for (ClassPathEntry path : entries) {
                    try {
                        AbstractArchive archive = path.openArchive();
                        classpathArchiveList.add(archive);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (LibraryNotFoundException ex) {
                throw new JeusDeploymentException(ex.getMessage(), ex);
            }
        }
        ArchiveArrayClassLoader loader = ArchiveArrayClassLoader.createClassLoader(classpathArchiveList.toArray(AbstractArchive.nullArray), rootClassLoader, true, className);
        return loader;
    }

    public static void undeployApp(String moduleMBeanType) {
        block5: {
            try {
                MBeanServer server = JMXManager.getMbeanServer();
                ObjectName[] names = JMXUtility.queryJ2EEDeployedApplications(server, null, JeusManagerPropertyValues.containerName, moduleMBeanType, null);
                J2EEDeployedObjectMBean[] apps = JMXUtility.getProxy((MBeanServerConnection)server, names, J2EEDeployedObjectMBean.class, false);
                for (int i = 0; i < apps.length; ++i) {
                    J2EEDeployedObjectMBean app = apps[i];
                    try {
                        app.undeploy(true);
                        continue;
                    }
                    catch (Exception ex) {
                        if (!logger.isLoggable(JeusMessage_Manager1._406_LEVEL)) continue;
                        logger.log(JeusMessage_Manager1._406_LEVEL, JeusMessage_Manager1._406, (Object)names[i], (Throwable)ex);
                    }
                }
            }
            catch (Exception ex1) {
                if (!logger.isLoggable(JeusMessage_Manager1._407_LEVEL)) break block5;
                logger.log(JeusMessage_Manager1._407_LEVEL, JeusMessage_Manager1._407, (Throwable)ex1);
            }
        }
    }

    private ObjectName getJeusManagerMo() throws SecurityException, ServiceException {
        LoginService.loginCodeSubject();
        try {
            ObjectName objectName = JMXUtility.queryJeusManager((MBeanServerConnection)MEJBUtility.getMEJBUtility(), nodeName);
            return objectName;
        }
        catch (Exception ex) {
            throw new JeusRuntimeException(JeusMessage_Manager._80, (Throwable)ex);
        }
        finally {
            LoginService.logout();
        }
    }

    private void innerStartEngine(String engineName, EngineSync sync) throws EngineContainerException {
        try {
            String engineOption = this.getEngineOption(engineName);
            StartThread starter = new StartThread(engineName, engineOption, sync, desc, serverMBean);
            starter.start();
            if (logger.isLoggable(JeusMessage_Manager._81_LEVEL)) {
                logger.log(JeusMessage_Manager._81_LEVEL, JeusMessage_Manager._81, (Object)engineName);
            }
        }
        catch (Throwable t) {
            sync.fail();
            throw new EngineContainerException(JeusMessage_Manager._82, engineName, t);
        }
    }

    private String getEngineOption(String engineName) throws EngineContainerException {
        String engineOption = null;
        boolean retry = false;
        while (true) {
            for (int j = 0; j < EngineContainer.desc.engineNames.size(); ++j) {
                if (!engineName.equals(EngineContainer.desc.engineNames.elementAt(j))) continue;
                engineOption = (String)EngineContainer.desc.engineOptions.elementAt(j);
                break;
            }
            if (engineOption != null) {
                return engineOption;
            }
            if (retry) break;
            try {
                JeusMainDescriptor mdesc = JeusMainDescriptorJB.getJeusMainDescriptor(nodeName);
                desc = (EngineContainerDescriptor)mdesc.engineContainers.get(JeusManagerPropertyValues.containerName);
            }
            catch (Throwable t) {
                throw new EngineContainerException(JeusMessage_Manager._83, engineName, t);
            }
            retry = true;
        }
        throw new EngineContainerException(JeusMessage_Manager._84, engineName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEngine(String engineName) throws EngineContainerException {
        Vector vector = this.engineList;
        synchronized (vector) {
            EngineSync sync;
            try {
                sync = new EngineSync(1);
                this.innerStartEngine(engineName, sync);
                sync.waiting();
            }
            catch (Throwable t) {
                throw new EngineContainerException(JeusMessage_Manager._85, engineName, t);
            }
            if (sync.getList().size() == 0) {
                throw new EngineContainerException(JeusMessage_Manager._85, engineName);
            }
            this.engineList.add(engineName);
            String engineType = StringUtil.getEngineTypeFromEngineName((String)engineName);
            if (engineType.equals("ejb") || engineType.equals("servlet")) {
                this.deployRegisteredApp(engineType);
            }
        }
    }

    public void restartEngine(String engineName) throws EngineContainerException {
        if (logger.isLoggable(JeusMessage_Manager._86_LEVEL)) {
            logger.log(JeusMessage_Manager._86_LEVEL, JeusMessage_Manager._86, (Object[])new String[]{engineName, JeusManagerPropertyValues.containerName});
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        NodeControllerStub ncontroller = new NodeControllerStub();
        try {
            ncontroller.connectTo(VirtualDNS.getRealNodeName(VirtualDNS.LOCAL_VIRTUALNAME));
            ncontroller.restartContainer(JeusManagerPropertyValues.containerName);
        }
        catch (Throwable t) {
            throw new EngineContainerException(JeusMessage_Manager._87, engineName, t);
        }
        finally {
            ncontroller.disconnect();
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downEngine(String engineName) throws EngineContainerException {
        Vector vector = this.engineList;
        synchronized (vector) {
            if (!this.engineList.contains(engineName)) {
                throw new EngineContainerException(JeusMessage_Manager._88, engineName);
            }
            this.checkIfEngineDown(engineName);
            this.innerDownEngine(engineName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDownEngine(String engineName) throws EngineContainerException {
        block10: {
            Thread.interrupted();
            Object sync = new Object();
            DownThread stopper = new DownThread(engineName, sync, serverMBean);
            stopper.start();
            if (logger.isLoggable(JeusMessage_Manager._89_LEVEL)) {
                logger.log(JeusMessage_Manager._89_LEVEL, JeusMessage_Manager._89, (Object)engineName);
            }
            try {
                Object object = sync;
                synchronized (object) {
                    if (!stopper.isDowned()) {
                        sync.wait(JeusNetProperties.CHECK_TIMEOUT);
                        if (!stopper.isDowned()) {
                            throw new EngineContainerException(JeusMessage_Manager._90, engineName);
                        }
                    }
                }
                if (stopper.isSuccessful()) {
                    this.engineList.remove(engineName);
                    if (logger.isLoggable(JeusMessage_Manager._91_LEVEL)) {
                        logger.log(JeusMessage_Manager._91_LEVEL, JeusMessage_Manager._91, (Object)engineName);
                    }
                    break block10;
                }
                throw new EngineContainerException(JeusMessage_Manager._92, engineName);
            }
            catch (Throwable t) {
                CUtility.dumpThreadStack((int)CUtility.thisProcessPID);
                throw new EngineContainerException(JeusMessage_Manager._93, engineName, t);
            }
        }
    }

    private void checkIfEngineDown(String engineName) throws EngineContainerException {
        block10: {
            try {
                if (engineName.indexOf("ejb") <= 0 && engineName.indexOf("servlet") <= 0) break block10;
                LoginService.loginCodeSubject();
                try {
                    ObjectName[] objects = JMXUtility.queryJ2EEApplications(JMXManager.getMbeanServer(), JeusManagerPropertyValues.containerName);
                    if (objects.length > 0) {
                        String msg = "Some EAR application is deployed to this container, so that you cannot down only one ejb or servlet engine. try to down container : ";
                        for (int i = 0; i < objects.length; ++i) {
                            ObjectName object = objects[i];
                            msg = msg + object + ",";
                        }
                        throw new EngineContainerException(msg);
                    }
                }
                catch (IllegalJeusSystemNameException e) {
                    throw new EngineContainerException(e.getMessage(), (Throwable)e);
                }
                finally {
                    LoginService.logout();
                }
            }
            catch (Throwable t) {
                if (t instanceof EngineContainerException) {
                    throw (EngineContainerException)((Object)t);
                }
                throw new EngineContainerException(t.getMessage(), t);
            }
        }
    }

    public Vector getEngineList() {
        return this.engineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        try {
            block39: {
                block37: {
                    block36: {
                        block35: {
                            if (this.task != null) {
                                this.task.cancel();
                            }
                            this.invokeMethod("BEFORE_UNDEPLOY");
                            serverMBean.sendNotification("jeus.enginecontainer.prestop", "container stopping", null);
                            EngineContainer.undeployApp(null);
                            this.invokeMethod("AFTER_UNDEPLOY");
                            serverMBean.sendNotification("jeus.container.down", "container is downed", null);
                            try {
                                CPUMonitorService cpuMonitorService = CPUMonitorService.getInstance();
                                if (cpuMonitorService.isStarted()) {
                                    cpuMonitorService.stopService();
                                }
                            }
                            catch (Throwable t) {
                                if (!logger.isLoggable(JeusMessage_Manager1._517_LEVEL)) break block35;
                                logger.log(JeusMessage_Manager1._517_LEVEL, JeusMessage_Manager1._517, t);
                            }
                        }
                        if (schedulerMBean != null) {
                            try {
                                schedulerMBean.stopService();
                            }
                            catch (Throwable ex) {
                                if (!logger.isLoggable(JeusMessage_Manager._95_LEVEL)) break block36;
                                logger.log(JeusMessage_Manager._95_LEVEL, JeusMessage_Manager._95, ex);
                            }
                        }
                    }
                    try {
                        TMService.shutdown();
                    }
                    catch (Throwable ex) {
                        if (!logger.isLoggable(JeusMessage_Manager._96_LEVEL)) break block37;
                        logger.log(JeusMessage_Manager._96_LEVEL, JeusMessage_Manager._96, ex);
                    }
                }
                Vector list = (Vector)this.engineList.clone();
                Vector vector = this.engineList;
                synchronized (vector) {
                    for (int i = 0; i < list.size(); ++i) {
                        String engineName = (String)list.elementAt(i);
                        try {
                            this.innerDownEngine(engineName);
                            continue;
                        }
                        catch (Throwable t) {
                            if (!logger.isLoggable(JeusMessage_Manager._94_LEVEL)) continue;
                            logger.log(JeusMessage_Manager._94_LEVEL, JeusMessage_Manager._94, (Object)engineName, t);
                        }
                    }
                }
                ResourceManager.destroyTimer();
                serverMBean.sendNotification("jeus.enginecontainer.poststop", "container stopped", null);
                if (serverMBean != null) {
                    serverMBean.destroyMBean();
                    serverMBean = null;
                }
                if (this.isJMXManagerStarted) {
                    try {
                        JMXManager.stop();
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(JeusMessage_Manager._76_LEVEL)) {
                            logger.log(JeusMessage_Manager._76_LEVEL, JeusMessage_Manager._76, t);
                        }
                    }
                    finally {
                        this.isJMXManagerStarted = false;
                    }
                }
                try {
                    this.unregisterResourceRefs();
                }
                catch (JeusServerException e) {
                    e.printStackTrace();
                }
                if (!JeusManagerPropertyValues.isDefaultContainer) {
                    try {
                        SecurityInstaller.uninstallSecurity();
                        if (logger.isLoggable(JeusMessage_Manager._97_LEVEL)) {
                            logger.log(JeusMessage_Manager._97_LEVEL, JeusMessage_Manager._97);
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(JeusMessage_Manager._98_LEVEL)) break block39;
                        logger.log(JeusMessage_Manager._98_LEVEL, JeusMessage_Manager._98, (Throwable)e);
                    }
                }
            }
            if (logger.isLoggable(JeusMessage_Manager._99_LEVEL)) {
                logger.log(JeusMessage_Manager._99_LEVEL, JeusMessage_Manager._99, (Object)JeusManagerPropertyValues.containerName);
            }
            UserLogger.flush();
            UserLogger.close();
            if (!JeusManagerPropertyValues.isDefaultContainer) {
                ScheduledExecutor.getInstance().cancelAll();
                JNSLocal.down();
                JeusSocketDispatcher.destroySocketDispatcher();
                JeusLogManager.enableReset();
                Logger.flush();
                Logger.close();
            }
        }
        finally {
            this.notifyDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restart(String engineName) throws EngineContainerException {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            container.restartEngine(engineName);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public static int getPID() {
        return CUtility.thisProcessPID;
    }

    public static void main(String[] args) {
        JeusManagerPropertyValues.containerName = args[0];
        try {
            nodeName = StringUtil.getNodeNameFromContainerName((String)JeusManagerPropertyValues.containerName);
        }
        catch (IllegalJeusSystemNameException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        partialContainerName = StringUtil.getEngineContainerNameFromContainerName((String)JeusManagerPropertyValues.containerName);
        PooledExecutorFactory.setPooledExecutorFactory((PooledExecutorFactory)new JeusPooledExecutorFactory());
        JeusLoggerConfiguration.setDefaultFilePath();
        PrintStream stderr = System.err;
        JeusPrintStream.setJeusStream();
        try {
            JeusLogManager.disableReset();
            logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
            Logger.createLogger("", 0);
            Logger.setLogLevel(1);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        JeusRootClassLoader.loader = EngineContainer.class.getClassLoader();
        JeusRootClassLoader.inServer = true;
        try {
            if (JeusSecurityProperties.PROTECTKEY_MODE) {
                int tryCount;
                if (logger.isLoggable(JeusMessage_Manager1._555_LEVEL)) {
                    logger.log(JeusMessage_Manager1._555_LEVEL, JeusMessage_Manager1._555);
                }
                InputStream systemIN = System.in;
                String pass = null;
                for (tryCount = 10; tryCount > 0; --tryCount) {
                    int available = systemIN.available();
                    if (available > 0) {
                        byte[] magicBytes = new byte[4];
                        systemIN.read(magicBytes);
                        int magic = NetUtil.readInt((byte[])magicBytes, (int)0);
                        if (magic != 537395984) {
                            throw new IOException("invalid magic number");
                        }
                        byte[] lengthBytes = new byte[4];
                        systemIN.read(lengthBytes);
                        int length = NetUtil.readInt((byte[])lengthBytes, (int)0);
                        if (length <= 0 || length > 512) {
                            throw new IOException("invalid length");
                        }
                        byte[] values = new byte[length];
                        systemIN.read(values);
                        pass = new String(values);
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                }
                if (tryCount <= 0) {
                    throw new JeusRuntimeException("inputstream from server is not arrived.");
                }
                if (logger.isLoggable(JeusMessage_Manager1._556_LEVEL)) {
                    logger.log(JeusMessage_Manager1._556_LEVEL, JeusMessage_Manager1._556);
                }
                EncryptionUtil.setPasswordForSecretKey(pass);
            }
            EncryptionUtil.cacheEncryptionInfo();
            if (JeusRootClassLoader.loader instanceof RootClassLoader) {
                ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, args[0]));
            }
            JeusMainDescriptor mdesc = EngineContainer.initConfiguration(false, args);
            CommonProcessInitializer.init();
            EngineContainer container = new EngineContainer(args, mdesc);
            MEJBUtility.setClusterChecker((ClusterChecker)container);
            if (logger.isLoggable(JeusMessage_Manager._100_LEVEL)) {
                logger.log(JeusMessage_Manager._100_LEVEL, JeusMessage_Manager._100, (Object)args[0]);
            }
            Vector engines = container.getEngineList();
            String enginelist = "[";
            for (int i = 0; i < engines.size(); ++i) {
                if (i != 0) {
                    enginelist = enginelist + ",";
                }
                enginelist = enginelist + (String)engines.elementAt(i);
            }
            enginelist = enginelist + "]";
            if (logger.isLoggable(JeusMessage_Manager._101_LEVEL)) {
                logger.log(JeusMessage_Manager._101_LEVEL, JeusMessage_Manager._101, (Object[])new String[]{args[0], enginelist});
            }
            String msg = "973630ok(" + CUtility.thisProcessPID + ")" + enginelist + "973630";
            stderr.println(msg);
            container.waitForDown();
            System.exit(0);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_Manager._102_LEVEL)) {
                logger.log(JeusMessage_Manager._102_LEVEL, JeusMessage_Manager._102, (Object)args[0], ex);
            }
            Logger.flush();
            Logger.close();
            stderr.println("973630error");
            stderr.flush();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDown() {
        Object object = this.waitForDownLock;
        synchronized (object) {
            try {
                this.waitForDownLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDown() {
        Object object = this.waitForDownLock;
        synchronized (object) {
            this.waitForDownLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deployApp() throws Exception {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            if (desc.useMEJB()) {
                EngineContainer.deploySystemApp("mejb.jar");
            }
            this.deployRegisteredApp(null);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deploySystemApp(String systemAppFileName) throws Exception {
        FileArchive systemAppArchive = (FileArchive)JeusManagerPropertyValues.getModuleArchive().getEmbeddedArchive("system_app");
        InputJarArchive archive = systemAppArchive.getEmbeddedJarArchive(systemAppFileName);
        try {
            ApplicationType appType = (ApplicationType)new ApplicationRuntimeDDFile().getDeploymentDescriptor((AbstractArchive)archive);
            JeusDeploymentManager.setApplicationPath(appType, archive.getArchiveUri());
            HashMap map = appType.getInfoMap();
            map.put("isSystemApp", Boolean.TRUE);
            TargetModuleID moduleId = serverMBean.deploy(appType);
            JMXUtility.invokeWithTargetModuleID(JMXManager.getMbeanServer(), moduleId, "start", null, null);
        }
        finally {
            systemAppArchive.close();
            if (archive != null) {
                archive.close();
            }
        }
    }

    private void deployRegisteredApp(String standaloneType) {
        List applicationList = desc.getApplications();
        boolean isNotDeployingModule = false;
        for (Object application : applicationList) {
            ApplicationType applicationType = (ApplicationType)application;
            if (standaloneType != null) {
                List nameAndPathList = applicationType.getNameAndPathAndDeploymentType();
                for (JAXBElement appList : nameAndPathList) {
                    Object obj = appList.getValue();
                    if (!(obj instanceof EjbComponentType) && !(obj instanceof WebComponentType) || (!standaloneType.equals("ejb") || obj instanceof EjbComponentType) && (!standaloneType.equals("servlet") || obj instanceof WebComponentType)) continue;
                    isNotDeployingModule = true;
                }
            }
            if (isNotDeployingModule) {
                isNotDeployingModule = false;
                continue;
            }
            if (applicationType.isSetDeployWhenBooting() && !applicationType.isDeployWhenBooting().booleanValue()) continue;
            AutoDeployType autoDeploy = applicationType.getAutoDeploy();
            if (applicationType.getAbsolutePath() != null && autoDeploy != null) {
                if (autoDeploy.isSetCheckAbsolutePath()) {
                    this.task = new ContainerAutoDeployTask(applicationType);
                    long interval = autoDeploy.getAutoDeployCheckInterval();
                    ScheduledExecutor.getInstance().scheduleWithFixedDelay(this.task, interval, interval);
                    continue;
                }
                if (JeusDeploymentManager.getApplicationPath(applicationType) == null && !autoDeploy.isCheckAbsolutePath().booleanValue()) continue;
            }
            try {
                TargetModuleID moduleId = this.getServerMBean().deploy(applicationType);
                JMXUtility.invokeWithTargetModuleID(JMXManager.getMbeanServer(), moduleId, "start", null, null);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_Manager1._405_LEVEL)) continue;
                logger.log(JeusMessage_Manager1._405_LEVEL, JeusMessage_Manager1._405, (Object)JeusDeploymentManager.getNameFromPath(applicationType), t);
            }
        }
    }

    public J2EEServer getServerMBean() {
        return serverMBean;
    }

    public String[] getEngineNamesFromDescriptor() {
        Vector engineNames = desc.getEngineNames();
        return engineNames.toArray(new String[engineNames.size()]);
    }

    public static String getFirstServletEngine() {
        if (servletEngineName != null) {
            return servletEngineName;
        }
        if (container == null) {
            servletEngineName = WebContainerManager.ENGINE_CONTROLLER.getEngineName();
            return servletEngineName;
        }
        Vector engineList = container.getEngineList();
        for (int s = 0; s < engineList.size(); ++s) {
            String temp = (String)engineList.get(s);
            if (temp.indexOf("_servlet_") < 0) continue;
            servletEngineName = temp;
            return servletEngineName;
        }
        return null;
    }

    public ArrayList getAppHomeList() throws IOException {
        List appPathList = desc.getEngineContainerRoot().getApplicationPath();
        ArrayList<String> pathArchives = new ArrayList<String>();
        if (appPathList.size() == 0) {
            pathArchives.add(JeusProperties.JEUS_APP_HOME);
        } else {
            for (int i = 0; i < appPathList.size(); ++i) {
                String pathname = (String)appPathList.get(i);
                File pathFile = new File(pathname);
                if (pathFile.isAbsolute()) {
                    pathArchives.add(pathFile.getAbsolutePath());
                    continue;
                }
                pathArchives.add(JeusBootstrapProperties.JEUS_HOME + File.separator + pathname);
            }
        }
        pathArchives.add(JeusProperties.AUTO_DEPLOY_DIR);
        return pathArchives;
    }

    @Override
    public String getNodeName() {
        return VirtualDNS.LOCAL_VIRTUALNAME;
    }

    @Override
    public String getContainerName() {
        return JeusManagerPropertyValues.containerName;
    }

    public static boolean isDown() {
        return container != null && !EngineContainer.container.running.get();
    }

    private void registerResourceRefs() throws NamingException, JeusServerException {
        if (this.initialCtx == null) {
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.localbindings", "true");
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            this.initialCtx = new InitialContext(envs);
        }
        if (this.resourceRefs == null) {
            this.resourceRefs = desc.getResourceRefs();
        }
        for (int i = 0; i < this.resourceRefs.size(); ++i) {
            JndiInfoType info = (JndiInfoType)this.resourceRefs.get(i);
            this.initialCtx.bind(info.getRefName(), (Object)new LinkRef(info.getExportName()));
        }
        this.externalResourceHandler.bindResources(desc.getEngineContainerRoot().getExternalResource());
    }

    private void unregisterResourceRefs() throws JeusServerException {
        if (this.initialCtx == null || this.resourceRefs == null) {
            return;
        }
        for (int i = 0; i < this.resourceRefs.size(); ++i) {
            JndiInfoType info = (JndiInfoType)this.resourceRefs.get(i);
            try {
                this.initialCtx.unbind(info.getRefName());
                continue;
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        this.initialCtx = null;
        this.resourceRefs = null;
        this.externalResourceHandler.destroyResources();
        Service.clearLocalBindings();
    }

    public boolean isInWorkingCluster(String nodeName) {
        if (nodeListServiceMBean == null) {
            return nodeName.equals(VirtualDNS.LOCAL_VIRTUALNAME);
        }
        return nodeListServiceMBean.isInWorkingCluster(nodeName);
    }

    public static FileArchive getDeploymentHome() {
        return containerModuleArchive;
    }

    public FileArchive getGeneratedDirHome() {
        return generatedDirArchive;
    }

    public FileArchive getGeneratedAppsDirHome() {
        return generatedAppsDirArchive;
    }

    public FileArchive getGeneratedModulesDirHome() {
        return generatedModulesDirArchive;
    }

    public static AbstractArchive getArchiveFromDeploymentHome(String path) throws IOException {
        return containerModuleArchive.getEmbeddedArchive(path);
    }

    static {
        ORBinitiated = false;
        EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + VirtualDNS.LOCAL_VIRTUALNAME + JeusPropertyValues.fs + "security", (Provider)CommonProcessInitializer.PROVIDER);
    }
}

