/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.enginecontainer;

import java.util.ArrayList;
import java.util.List;
import jeus.server.enginecontainer.ResourceSet;
import jeus.util.trace.ManagedResource;

public class InvocationStack {
    private final List stack = new ArrayList();

    public synchronized void push(boolean stateless) {
        ResourceSet resources = new ResourceSet(stateless);
        this.stack.add(resources);
    }

    public synchronized ResourceSet pop() {
        if (this.stack.isEmpty()) {
            return new ResourceSet(false);
        }
        return (ResourceSet)this.stack.remove(this.stack.size() - 1);
    }

    public synchronized void addResource(ManagedResource resource) {
        if (this.stack.isEmpty()) {
            return;
        }
        ResourceSet resources = (ResourceSet)this.stack.get(this.stack.size() - 1);
        resources.add(resource);
    }

    public synchronized void removeResource(ManagedResource resource) {
        if (this.stack.isEmpty()) {
            return;
        }
        ResourceSet resources = (ResourceSet)this.stack.get(this.stack.size() - 1);
        resources.remove(resource);
    }

    public synchronized void shutdownAll() {
        for (ResourceSet resources : this.stack) {
            resources.shutdownAll();
        }
    }
}

