/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.enginecontainer;

import java.util.Iterator;
import java.util.LinkedList;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.trace.ManagedResource;

public class ResourceSet {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private final LinkedList resources = new LinkedList();
    private final boolean stateless;

    public ResourceSet(boolean stateless) {
        this.stateless = stateless;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public synchronized void add(ManagedResource resource) {
        this.resources.addLast(resource);
    }

    public synchronized void remove(ManagedResource resource) {
        this.resources.remove(resource);
    }

    public synchronized boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public synchronized void releaseAll() {
        if (!this.stateless) {
            return;
        }
        this.shutdownAll();
    }

    public synchronized void shutdownAll() {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            try {
                ManagedResource resource = (ManagedResource)it.next();
                resource.close();
            }
            catch (Throwable t) {
                logger.log(JeusMessage_Manager._108_LEVEL, JeusMessage_Manager._108, (Object)this.resources, t);
            }
        }
    }

    public String resourcesToString() {
        StringBuffer buffer = new StringBuffer(128);
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            buffer.append("\n").append(it.next()).append("\n");
        }
        return buffer.toString();
    }
}

