/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.enginecontainer;

import java.io.Serializable;
import java.util.StringTokenizer;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.ejb.EJBEngine;
import jeus.jms.server.JMSServer;
import jeus.management.j2ee.J2EEServer;
import jeus.server.enginecontainer.EngineContainerException;
import jeus.server.util.EngineSync;
import jeus.servlet.deployment.WebContainer;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.webserver.WebServerProxyFactory;
import jeus.webserver.WebServerProxyImpl;

public class StartThread
extends Thread {
    private String engineName;
    private String engineOption;
    private EngineSync sync = null;
    public static String webContainer = null;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private EngineContainerDescriptor desc;
    private J2EEServer serverMBean;

    public StartThread(String engineName, String engineOption, EngineSync sync, EngineContainerDescriptor desc, J2EEServer serverMBean) {
        super("jeus.server.enginecontainer.StartThread");
        this.engineName = engineName;
        this.engineOption = engineOption;
        this.sync = sync;
        this.desc = desc;
        this.serverMBean = serverMBean;
    }

    public void run() {
        try {
            this.serverMBean.sendNotification("jeus.engine.preboot", "engine is booting", (Serializable)((Object)this.engineName));
            StringTokenizer arguments = new StringTokenizer(this.engineOption);
            int numArgs = arguments.countTokens();
            String[] args = new String[numArgs + 1];
            args[0] = this.engineName;
            for (int i = 0; i < numArgs; ++i) {
                args[i + 1] = arguments.nextToken();
            }
            String type = StringUtil.getEngineTypeFromEngineName((String)this.engineName);
            this.desc.initEngineLogging(type);
            if (type.equals("servlet")) {
                webContainer = this.engineName;
                WebContainer.main(args);
            } else if (type.equals("ejb")) {
                EJBEngine.main(args);
            } else if (type.equals("jms")) {
                JMSServer.main((String[])args);
            } else if (type.equals("ws")) {
                WebServerProxyImpl proxy = WebServerProxyFactory.getWebServerProxyImpl();
                if (!proxy.boot(args)) {
                    throw new EngineContainerException(JeusMessage_Manager._110, this.engineName);
                }
            } else {
                throw new EngineContainerException(JeusMessage_Manager._111, this.engineName);
            }
            if (logger.isLoggable(JeusMessage_Manager._112_LEVEL)) {
                logger.log(JeusMessage_Manager._112_LEVEL, JeusMessage_Manager._112, (Object)this.engineName);
            }
            this.serverMBean.sendNotification("jeus.engine.postboot.success", "engine is booted successfully", (Serializable)((Object)this.engineName));
            this.sync.success(this.engineName);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Manager._113_LEVEL)) {
                logger.log(JeusMessage_Manager._113_LEVEL, JeusMessage_Manager._113, (Object)this.engineName, t);
            }
            this.serverMBean.sendNotification("jeus.engine.postboot.fail", "engine boot is failed", (Serializable)new Object[]{this.engineName, t});
            this.sync.fail();
        }
    }
}

