/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Permission;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.NamingException;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MBSCAlreadyClosedException;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.VirtualTerminal;
import jeus.server.enginecontainer.DefaultEngineContainer;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.server.service.JEUSService;
import jeus.server.util.EngineSync;
import jeus.util.CUtility;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.JeusException;
import jeus.util.JeusLocalizedException;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.cnet.NetUtil;
import jeus.util.logging.JeusLogManager;
import jeus.util.message.JeusMessage_JMX;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.properties.JeusEngineContainerProperties;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusPropertyValues;

public class ContainerManagerService
extends JEUSService
implements ContainerManagerServiceMBean,
NotificationListener {
    public static final String[] REPLICATE_PROPERTY_PREFIXS = StringUtil.makeArrayFromCommaString((String)JeusManagerProperties.REPLICATE_SYSTEM_PROPERTIES, (String[])new String[]{"jeus."});
    private static final String fs = File.separator;
    private static final String clsp = File.pathSeparator;
    private final Hashtable containers = new Hashtable(10);
    private final Hashtable terminals = new Hashtable(10);
    private Vector initializingContainerProcesses;
    private Vector initializingContainerTerminals;
    private Vector initializingContainerNames;
    private boolean isNativeThread = false;
    private boolean isServerJVM = true;
    private boolean isOldJVM = false;
    private boolean isNTService = false;
    private JeusServer server;
    private Vector bootedContainerList = null;
    private JEUSManagerMBean jeusManagerMBean;
    public static ResourcePermission containerManagerPermission;
    private Hashtable pidMap = new Hashtable();
    private static final long CONTAINER_REFORK_DURATION_TIME = 120000L;
    private static final int CONTAINER_REFORK_TRY_COUNT = 5;
    private long reforkCheckTime = -1L;
    private int reforkCount;

    public ContainerManagerService() {
        this.pidMap.put(VirtualDNS.LOCAL_VIRTUALNAME, new Integer(CUtility.thisProcessPID));
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ContainerManagerService mo = new ContainerManagerService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "ContainerManagerService");
    }

    public void startService(Object obj) throws JeusException {
        LoginService.checkCodeSubject();
        try {
            this.server = (JeusServer)obj;
            this.initializingContainerProcesses = new Vector(10);
            this.initializingContainerTerminals = new Vector(10);
            this.initializingContainerNames = new Vector(10);
            String sdkVer = JeusEngineContainerProperties.JVM_VERSION;
            if (sdkVer.equals("old")) {
                this.isOldJVM = true;
            } else if (!sdkVer.equals("hotspot")) {
                this.isServerJVM = false;
            }
            this.isNativeThread = JeusEngineContainerProperties.JVM_NATIVE;
            this.isNTService = JeusEngineContainerProperties.JVM_NT_SERVICE;
            this.jeusManagerMBean = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, JEUSManagerMBean.class, true);
            this.jeusManagerMBean.addNotificationListener(this, null, null);
            this.server.setContainerManagerServiceName(this.getObjectName());
        }
        catch (Exception ex) {
            this.destroyMBean();
            throw new JeusException(JeusMessage_Manager._123, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEngines(String hostName, JeusMainDescriptor desc) {
        EngineSync sync = null;
        boolean isSequentialStart = desc.isSerialStart();
        if (!isSequentialStart) {
            sync = new EngineSync(desc.engineContainers.size());
        } else {
            this.bootedContainerList = new Vector();
        }
        if (!isSequentialStart) {
            Hashtable hashtable = this.containers;
            synchronized (hashtable) {
                for (EngineContainerDescriptor ecdesc : desc.engineContainers.values()) {
                    String containerName2 = ecdesc.getName();
                    if (ecdesc.isStartOnBoot()) {
                        try {
                            this.innerStartContainer(hostName, ecdesc, null, sync, false);
                        }
                        catch (Throwable t) {
                            if (!logger.isLoggable(JeusMessage_Manager._124_LEVEL)) continue;
                            logger.log(JeusMessage_Manager._124_LEVEL, JeusMessage_Manager._124, (Object)containerName2, t);
                        }
                        continue;
                    }
                    sync.decrease();
                }
            }
        }
        for (EngineContainerDescriptor ecdesc : desc.engineContainers.values()) {
            String containerName = ecdesc.getName();
            if (!ecdesc.isStartOnBoot()) continue;
            try {
                sync = new EngineSync(1);
                Hashtable containerName2 = this.containers;
                synchronized (containerName2) {
                    this.innerStartContainer(hostName, ecdesc, null, sync, false);
                }
                sync.waiting();
                if (sync.getList().size() != 1) continue;
                this.bootedContainerList.add(containerName);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_Manager._124_LEVEL)) continue;
                logger.log(JeusMessage_Manager._124_LEVEL, JeusMessage_Manager._124, (Object)containerName, t);
            }
        }
        if (logger.isLoggable(JeusMessage_Manager._125_LEVEL)) {
            logger.log(JeusMessage_Manager._125_LEVEL, JeusMessage_Manager._125);
        }
        if (!isSequentialStart) {
            sync.waiting();
            this.bootedContainerList = sync.getList();
        }
    }

    public Vector getBootedContainerList() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)containerManagerPermission);
        return this.bootedContainerList;
    }

    private void innerStartContainer(String nodeName, EngineContainerDescriptor ecdesc, Vector enginelist, EngineSync sync, boolean restart) throws Exception {
        String containerName = ecdesc.getName();
        try {
            Hashtable gr;
            if (restart) {
                gr = (Hashtable)this.containers.get(nodeName);
                if (gr != null) {
                    gr.remove(containerName);
                    if (gr.size() == 0) {
                        this.containers.remove(nodeName);
                    }
                }
                this.terminals.remove(containerName);
                this.pidMap.remove(containerName);
                if (!this.checkContainerRefork()) {
                    throw new JeusServerException("failed to restart the " + containerName + " container because the restart's count was in excess of " + 5 + " during " + 120000L + "ms");
                }
            } else {
                gr = (Hashtable)this.containers.get(nodeName);
                if (gr != null && gr.containsKey(containerName)) {
                    throw new JeusServerException(JeusMessage_Manager._126, containerName);
                }
                if (this.initializingContainerNames.contains(containerName)) {
                    throw new JeusServerException(JeusMessage_Manager._127, containerName);
                }
            }
            if (enginelist == null) {
                enginelist = ecdesc.engineNames;
            }
            if (StringUtil.isDefaultContainerName((String)containerName)) {
                VirtualTerminal vt = DefaultEngineContainer.createContainer(containerName, enginelist, sync, this.getContainerID(ecdesc), this);
                this.initializingContainerProcesses.add(new Object());
                this.initializingContainerTerminals.add(vt);
                this.initializingContainerNames.add(containerName);
            } else {
                String cmd = this.getDefaultCommand(ecdesc);
                for (int i = 0; i < enginelist.size(); ++i) {
                    cmd = cmd + " " + enginelist.elementAt(i);
                }
                if (logger.isLoggable(JeusMessage_Manager._128_LEVEL)) {
                    logger.log(JeusMessage_Manager._128_LEVEL, JeusMessage_Manager._128, (Object[])new String[]{containerName, cmd});
                }
                Runtime runtime = Runtime.getRuntime();
                Process container = runtime.exec(cmd);
                String passwordForSecretKey = EncryptionUtil.getPasswordForSecretKey();
                if (passwordForSecretKey != null) {
                    OutputStream containerOS = container.getOutputStream();
                    byte[] magicBytes = new byte[4];
                    NetUtil.writeInt((byte[])magicBytes, (int)0, (int)537395984);
                    containerOS.write(magicBytes);
                    byte[] lengthBytes = new byte[4];
                    NetUtil.writeInt((byte[])lengthBytes, (int)0, (int)passwordForSecretKey.length());
                    containerOS.write(lengthBytes);
                    containerOS.write(passwordForSecretKey.getBytes());
                    containerOS.flush();
                }
                VirtualTerminal vt = new VirtualTerminal(container, nodeName, ecdesc, sync, this);
                vt.start();
                this.initializingContainerProcesses.add(container);
                this.initializingContainerTerminals.add(vt);
                this.initializingContainerNames.add(containerName);
            }
            if (logger.isLoggable(JeusMessage_Manager._129_LEVEL)) {
                logger.log(JeusMessage_Manager._129_LEVEL, JeusMessage_Manager._129, (Object)containerName);
            }
        }
        catch (Throwable t) {
            sync.fail();
            throw new JeusServerException(JeusMessage_Manager._130, containerName, t);
        }
    }

    private boolean checkContainerRefork() {
        long currentTime = System.currentTimeMillis();
        if (this.reforkCheckTime == -1L) {
            this.reforkCheckTime = currentTime;
        }
        if (currentTime - this.reforkCheckTime <= 120000L) {
            ++this.reforkCount;
        } else {
            this.reforkCount = 0;
            this.reforkCheckTime = currentTime;
        }
        return this.reforkCount < 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContainer(String nodeName, String containerName, Vector enginelist, VirtualTerminal vt) {
        Hashtable hashtable = this.containers;
        synchronized (hashtable) {
            this.removeInitializedContainer(vt);
            Hashtable<String, Vector> gr = (Hashtable<String, Vector>)this.containers.get(nodeName);
            if (gr == null) {
                gr = new Hashtable<String, Vector>();
                this.containers.put(nodeName, gr);
            }
            gr.put(containerName, enginelist);
            if (!(vt instanceof DefaultEngineContainer.BootThread)) {
                this.terminals.put(containerName, vt);
                this.pidMap.put(containerName, new Integer(vt.getPID()));
            } else {
                this.pidMap.put(containerName, new Integer(CUtility.thisProcessPID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void containerFailure(VirtualTerminal vt) {
        Hashtable hashtable = this.containers;
        synchronized (hashtable) {
            this.removeInitializedContainer(vt);
        }
    }

    private void removeInitializedContainer(VirtualTerminal vt) {
        int index = this.initializingContainerTerminals.indexOf(vt);
        if (index >= 0) {
            this.initializingContainerTerminals.remove(index);
            this.initializingContainerProcesses.remove(index);
            this.initializingContainerNames.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartContainer(String group, String containerName) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)containerManagerPermission);
        try {
            this.downContainer(group, containerName);
            this.startContainer(group, containerName);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean downEngine(String nodeName, String engineName) {
        Hashtable gr;
        Vector container;
        String containerName;
        block24: {
            block23: {
                LoginUtil.checkPermissionWithCodeSubject((Permission)containerManagerPermission);
                if (this.server.isBooted()) break block23;
                if (logger.isLoggable(JeusMessage_Manager._133_LEVEL)) {
                    logger.log(JeusMessage_Manager._133_LEVEL, JeusMessage_Manager._133, (Object[])new String[]{engineName, this.server.getServerState()});
                }
                boolean bl = false;
                LoginUtil.logoutWithRuntimeException();
                return bl;
            }
            Hashtable hashtable = this.containers;
            // MONITORENTER : hashtable
            containerName = null;
            container = null;
            gr = (Hashtable)this.containers.get(nodeName);
            if (gr != null) break block24;
            if (logger.isLoggable(JeusMessage_Manager._316_LEVEL)) {
                logger.log(JeusMessage_Manager._316_LEVEL, JeusMessage_Manager._316, (Object)nodeName);
            }
            boolean bl = false;
            // MONITOREXIT : hashtable
            LoginUtil.logoutWithRuntimeException();
            return bl;
        }
        Enumeration con2 = gr.keys();
        while (con2.hasMoreElements()) {
            String conName = (String)con2.nextElement();
            container = (Vector)gr.get(conName);
            if (!container.contains(engineName)) continue;
            containerName = conName;
            break;
        }
        if (containerName == null) {
            if (logger.isLoggable(JeusMessage_Manager._317_LEVEL)) {
                logger.log(JeusMessage_Manager._317_LEVEL, JeusMessage_Manager._317, (Object)engineName);
            }
            boolean con2 = false;
            // MONITOREXIT : hashtable
            LoginUtil.logoutWithRuntimeException();
            return con2;
        }
        try {
            J2EEServerMBean serverMBean = this.getJ2EEServerMBean(containerName);
            serverMBean.downEngine(engineName);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_Manager._318_LEVEL)) {
                logger.log(JeusMessage_Manager._318_LEVEL, JeusMessage_Manager._318, (Object)engineName, ex);
            }
            boolean bl = false;
            // MONITOREXIT : hashtable
            LoginUtil.logoutWithRuntimeException();
            return bl;
        }
        try {
            container.remove(engineName);
            if (container.size() == 0) {
                gr.remove(containerName);
                ObjectName containerObjectName = this.innerDownContainer(containerName);
                LoginUtil.loginCodeSubjectWithRuntimeException();
                try {
                    this.jeusManagerMBean.removeChild(containerObjectName);
                }
                finally {
                    LoginUtil.logoutWithRuntimeException();
                }
            }
            if (gr.size() == 0) {
                this.containers.remove(nodeName);
            }
            // MONITOREXIT : hashtable
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    protected void makePermissions() {
        super.makePermissions();
        containerManagerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"containerManager");
    }

    private J2EEServerMBean getJ2EEServerMBean(String containerName) throws IOException {
        ObjectName containerObjectName = this.getContainerObjectName(containerName);
        MEJBUtility util = MEJBUtility.getMEJBUtility();
        return JMXUtility.getProxy((MBeanServerConnection)util, containerObjectName, J2EEServerMBean.class, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean downContainer(String nodeName, String containerName) {
        block15: {
            LoginUtil.checkPermissionWithCodeSubject((Permission)ContainerManagerService.containerManagerPermission);
            if (this.server.isBooted()) break block15;
            if (ContainerManagerService.logger.isLoggable(JeusMessage_Manager._134_LEVEL)) {
                ContainerManagerService.logger.log(JeusMessage_Manager._134_LEVEL, JeusMessage_Manager._134, (Object[])new String[]{containerName, this.server.getServerState()});
            }
            var3_3 = false;
            LoginUtil.logoutWithRuntimeException();
            return var3_3;
        }
        var3_4 = this.containers;
        synchronized (var3_4) {
            gr = (Hashtable)this.containers.get(nodeName);
            if (gr != null) ** break block16
            if (ContainerManagerService.logger.isLoggable(JeusMessage_Manager._132_LEVEL)) {
                ContainerManagerService.logger.log(JeusMessage_Manager._132_LEVEL, JeusMessage_Manager._132, (Object)nodeName);
            }
            var5_7 = false;
        }
        LoginUtil.logoutWithRuntimeException();
        return var5_7;
        {
            block18: {
                if (containerName != null && !containerName.equals("")) break block18;
                this.containers.remove(nodeName);
                en = gr.keys();
                while (en.hasMoreElements()) {
                    containerObjectName = this.innerDownContainer((String)en.nextElement());
                    this.jeusManagerMBean.removeChild(containerObjectName);
                }
                ** GOTO lbl47
            }
            if (gr.remove(containerName) != null) ** break block17
            if (ContainerManagerService.logger.isLoggable(JeusMessage_Manager._132_LEVEL)) {
                ContainerManagerService.logger.log(JeusMessage_Manager._132_LEVEL, JeusMessage_Manager._132, (Object)nodeName);
            }
            en = false;
        }
        LoginUtil.logoutWithRuntimeException();
        return en;
        {
            containerObjectName = this.innerDownContainer(containerName);
            this.jeusManagerMBean.removeChild(containerObjectName);
            if (gr.size() == 0) {
                this.containers.remove(nodeName);
            }
lbl47:
            // 4 sources

            // MONITOREXIT @DISABLED, blocks:[4, 5, 6] lbl45 : MonitorExitStatement: MONITOREXIT : var3_4
            {
                catch (Throwable var7_12) {
                    throw var7_12;
                }
            }
            var3_5 = true;
            return var3_5;
        }
        {
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downAllContainers() {
        LoginUtil.checkPermissionWithCodeSubject((Permission)containerManagerPermission);
        try {
            if (!this.server.isBooted()) {
                if (logger.isLoggable(JeusMessage_Manager._135_LEVEL)) {
                    logger.log(JeusMessage_Manager._135_LEVEL, JeusMessage_Manager._135, (Object)this.server.getServerState());
                }
                boolean bl = false;
                return bl;
            }
            Hashtable hashtable = this.containers;
            synchronized (hashtable) {
                Enumeration key = this.containers.keys();
                while (key.hasMoreElements()) {
                    Hashtable gr = (Hashtable)this.containers.remove(key.nextElement());
                    Enumeration en = gr.keys();
                    while (en.hasMoreElements()) {
                        ObjectName containerObjectName = this.innerDownContainer((String)en.nextElement());
                        this.jeusManagerMBean.removeChild(containerObjectName);
                    }
                }
                DefaultEngineContainer.defaultContainer = null;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    private ObjectName innerDownContainer(String containerName) {
        J2EEServerMBean server;
        VirtualTerminal vt = (VirtualTerminal)this.terminals.remove(containerName);
        this.pidMap.remove(containerName);
        ObjectName containerObjectName = this.getContainerObjectName(containerName);
        try {
            server = JMXUtility.getProxy((MBeanServerConnection)MEJBUtility.getMEJBUtility(), containerObjectName, J2EEServerMBean.class, false);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_Manager._136_LEVEL)) {
                logger.log(JeusMessage_Manager._136_LEVEL, JeusMessage_Manager._136, (Object)containerName, ex);
            }
            throw new JeusRuntimeException("Cannot get the MBean for container " + containerName, ex);
        }
        ContainerDownRunnable r = new ContainerDownRunnable(server, containerName, vt);
        if (vt == null) {
            r.run();
        } else {
            vt.waitForContainerDown(r);
        }
        if (logger.isLoggable(JeusMessage_Manager._141_LEVEL)) {
            logger.log(JeusMessage_Manager._141_LEVEL, JeusMessage_Manager._141, (Object)containerName);
        }
        return containerObjectName;
    }

    private ObjectName getContainerObjectName(String containerName) {
        ObjectName[] names = this.jeusManagerMBean.getj2eeServerNames();
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            if (!name.getKeyProperty("name").equals(containerName)) continue;
            return name;
        }
        throw new JeusRuntimeException("The MBean for container " + containerName + " does not exist");
    }

    private String getDefaultCommand(EngineContainerDescriptor ecdesc) throws JeusServerException {
        String jrePath = System.getProperty("java.home");
        String cmd = jrePath + File.separator + "bin" + File.separator + "java ";
        try {
            String is64bits;
            String jeusbootpath;
            if (!this.isOldJVM) {
                cmd = this.isServerJVM ? cmd + "-server" : cmd + "-classic";
            }
            if (this.isNativeThread) {
                cmd = cmd + " -native";
            }
            if (this.isNTService) {
                cmd = cmd + " -Xrs";
            }
            if ((jeusbootpath = JeusEngineContainerProperties.JEUS_BOOT_PATH) != null && !jeusbootpath.equals("")) {
                cmd = fs.equals("/") ? cmd + " " + jeusbootpath : cmd + " \"" + this.preProcessFilePath(jeusbootpath) + "\"";
            } else {
                jeusbootpath = System.getProperty("jeus.boot.path." + ecdesc.getName().substring(ecdesc.getName().lastIndexOf("_") + 1));
                if (jeusbootpath != null && !jeusbootpath.equals("")) {
                    cmd = fs.equals("/") ? cmd + " " + jeusbootpath : cmd + " \"" + this.preProcessFilePath(jeusbootpath) + "\"";
                }
            }
            if (fs.equals("/")) {
                cmd = cmd + " -Xbootclasspath/p:";
                cmd = cmd + JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "system" + fs + "extension.jar";
            } else {
                cmd = cmd + " \"-Xbootclasspath/p:";
                cmd = cmd + JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "system" + fs + "extension.jar";
            }
            if (!fs.equals("/")) {
                cmd = cmd + "\"";
            }
            cmd = cmd + " -classpath ";
            cmd = fs.equals("/") ? cmd + JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "system" + fs + "bootstrap.jar" : cmd + "\"" + JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "system" + fs + "bootstrap.jar";
            String resourcePath = JeusEngineContainerProperties.JEUS_USER_RESOURCE;
            if (resourcePath != null) {
                cmd = cmd + clsp + resourcePath;
            } else {
                resourcePath = System.getProperty("jeus.user.resource." + ecdesc.getName().substring(ecdesc.getName().lastIndexOf("_") + 1));
                if (resourcePath != null) {
                    cmd = cmd + clsp + resourcePath;
                }
            }
            if (!fs.equals("/")) {
                cmd = cmd + "\"";
            }
            if (!ecdesc.getUserClassPath().equals("")) {
                cmd = fs.equals("/") ? cmd + " -Djeus.server.classpath=" + ecdesc.getUserClassPath() : cmd + " \"-Djeus.server.classpath=" + this.preProcessFilePath(ecdesc.getUserClassPath()) + "\"";
            }
            if ((is64bits = JeusManagerProperties.VM_BITS) != null && is64bits.equals("64")) {
                cmd = cmd + " -d64";
            }
            cmd = fs.equals("/") ? cmd + " -Djava.security.policy=" + JeusBootstrapProperties.JEUS_HOME + fs + "config" + fs + "security" + fs + "policy" : cmd + " \"-Djava.security.policy=" + JeusBootstrapProperties.JEUS_HOME + fs + "config" + fs + "security" + fs + "policy\"";
            cmd = cmd + " -Djava.util.logging.manager=" + JeusLogManager.class.getName();
            cmd = cmd + " " + ecdesc.getCommandOption();
            if (!JeusBootstrapPropertyValues.isUpperJDK5() && cmd.indexOf("-Dsun.boot.library.path") == -1) {
                cmd = fs.equals("/") ? cmd + " -Dsun.boot.library.path=" + JeusProperties.JEUS_HOME + fs + "lib" + fs + "system" + clsp + JeusEngineContainerProperties.SUN_BOOT_LIB_PATH : cmd + " \"-Dsun.boot.library.path=" + this.preProcessFilePath(JeusProperties.JEUS_HOME + fs + "lib" + fs + "system" + clsp + JeusEngineContainerProperties.SUN_BOOT_LIB_PATH) + "\"";
            }
            for (int i = 0; i < JeusPropertyValues.propertiesForContainer.length; ++i) {
                String value;
                String property = JeusPropertyValues.propertiesForContainer[i];
                if (cmd.indexOf("-D" + property) >= 0 || (value = System.getProperty(property)) == null) continue;
                cmd = fs.equals("/") ? cmd + " -D" + property + "=" + value : cmd + " \"-D" + property + "=" + this.preProcessFilePath(value) + "\"";
            }
            Properties properties = System.getProperties();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String property = (String)e.nextElement();
                String value = System.getProperty(property);
                cmd = this.putSystemProperty(cmd, property, value);
            }
            cmd = cmd + " -Djava.naming.factory.initial=jeus.jndi.JNSContextFactory -Djava.naming.factory.url.pkgs=jeus.jndi.jns.url";
            if (JeusServer.defaultORBClassName != null) {
                cmd = cmd + " -Dorg.omg.CORBA.ORBClass=jeus.transaction.ots.JORB -Djeus.CORBA.ORBClass=" + JeusServer.defaultORBClassName;
            }
            boolean isProtectMode = false;
            if (EncryptionUtil.getPasswordForSecretKey() != null) {
                isProtectMode = true;
            }
            cmd = cmd + " -Djeus.server.protectmode=" + isProtectMode;
            String profileArg = JeusEngineContainerProperties.PROFILE_EXECUTOR;
            cmd = profileArg != null && !profileArg.equals("") ? cmd + " " + profileArg + " jeus.server.enginecontainer.EngineContainerBootstrapper " + ecdesc.getName() : ((profileArg = System.getProperty("jeus.profile.executor." + ecdesc.getName().substring(ecdesc.getName().lastIndexOf("_") + 1))) != null && !profileArg.equals("") ? cmd + " " + profileArg + " jeus.server.enginecontainer.EngineContainerBootstrapper " + ecdesc.getName() : cmd + " jeus.server.enginecontainer.EngineContainerBootstrapper " + ecdesc.getName());
            return cmd;
        }
        catch (Throwable ex) {
            throw new JeusServerException(JeusMessage_Manager._142, cmd, ex);
        }
    }

    private String putSystemProperty(String cmd, String property, String value) {
        if (cmd.indexOf("-D" + property) < 0 && StringUtil.isStartWith((String)property, (String[])REPLICATE_PROPERTY_PREFIXS) && value != null) {
            cmd = fs.equals("/") ? cmd + " -D" + property + "=" + value : cmd + " \"-D" + property + "=" + this.preProcessFilePath(value) + "\"";
        }
        return cmd;
    }

    int getContainerID(EngineContainerDescriptor edesc) throws JeusServerException {
        return edesc.getEngineContainerRoot().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNodeList() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)containerManagerPermission);
        if (!this.server.isBooted()) {
            if (logger.isLoggable(JeusMessage_Manager._143_LEVEL)) {
                logger.log(JeusMessage_Manager._143_LEVEL, JeusMessage_Manager._143, (Object)this.server.getServerState());
            }
            return new Vector();
        }
        Vector v = new Vector();
        Hashtable hashtable = this.containers;
        synchronized (hashtable) {
            Enumeration gr = this.containers.keys();
            while (gr.hasMoreElements()) {
                v.add(gr.nextElement());
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getContainerList(String nodeName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)containerManagerPermission);
        if (!this.server.isBooted()) {
            if (logger.isLoggable(JeusMessage_Manager._144_LEVEL)) {
                logger.log(JeusMessage_Manager._144_LEVEL, JeusMessage_Manager._144, (Object[])new String[]{nodeName, this.server.getServerState()});
            }
            return new Vector();
        }
        Hashtable gr = null;
        Vector list = new Vector();
        Hashtable hashtable = this.containers;
        synchronized (hashtable) {
            if (nodeName != null) {
                gr = (Hashtable)this.containers.get(nodeName);
            } else {
                Collection values = this.containers.values();
                if (!values.isEmpty()) {
                    gr = (Hashtable)values.iterator().next();
                }
            }
            if (gr == null) {
                if (logger.isLoggable(JeusMessage_Manager._316_LEVEL)) {
                    logger.log(JeusMessage_Manager._316_LEVEL, JeusMessage_Manager._316);
                }
                return list;
            }
            Enumeration e = gr.keys();
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
        }
        return list;
    }

    public Vector getAllContainerList(String group) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)containerManagerPermission);
        if (!this.server.isBooted()) {
            if (logger.isLoggable(JeusMessage_Manager._144_LEVEL)) {
                logger.log(JeusMessage_Manager._144_LEVEL, JeusMessage_Manager._144, (Object[])new String[]{group, this.server.getServerState()});
            }
            return new Vector();
        }
        Vector<String> list = new Vector<String>();
        JeusMainDescriptor desc = null;
        try {
            desc = JeusServer.readJeusMainDescriptor(group);
        }
        catch (JeusServerException e) {
            e.printStackTrace();
        }
        for (EngineContainerDescriptor ecdesc : desc.engineContainers.values()) {
            list.add(ecdesc.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getEngineList(String group, String containerName) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)containerManagerPermission);
        if (!this.server.isBooted()) {
            if (logger.isLoggable(JeusMessage_Manager._319_LEVEL)) {
                logger.log(JeusMessage_Manager._319_LEVEL, JeusMessage_Manager._319, (Object[])new String[]{group, this.server.getServerState()});
            }
            return new Vector();
        }
        Vector list = new Vector();
        Hashtable hashtable = this.containers;
        synchronized (hashtable) {
            Hashtable gr = (Hashtable)this.containers.get(group);
            if (gr == null) {
                if (logger.isLoggable(JeusMessage_Manager._145_LEVEL)) {
                    logger.log(JeusMessage_Manager._145_LEVEL, JeusMessage_Manager._145, (Object)group);
                }
                return list;
            }
            list = (Vector)gr.get(containerName);
        }
        if (list == null) {
            if (logger.isLoggable(JeusMessage_Manager._146_LEVEL)) {
                logger.log(JeusMessage_Manager._146_LEVEL, JeusMessage_Manager._146, (Object)containerName);
            }
            return new Vector();
        }
        return (Vector)list.clone();
    }

    public Map getPIDMap() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)containerManagerPermission);
        return this.pidMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startEngine(String group, String name) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)containerManagerPermission);
        try {
            String containerName;
            if (!this.server.isBooted()) {
                if (logger.isLoggable(JeusMessage_Manager._148_LEVEL)) {
                    logger.log(JeusMessage_Manager._148_LEVEL, JeusMessage_Manager._148, (Object[])new String[]{name, this.server.getServerState()});
                }
                boolean bl = false;
                return bl;
            }
            JeusMainDescriptor desc = JeusServer.readJeusMainDescriptor(group);
            EngineContainerDescriptor ecdesc = ContainerManagerService.getEngineContainerDescriptorFromEngineName(desc, name);
            Hashtable hashtable = this.containers;
            synchronized (hashtable) {
                containerName = ecdesc.getName();
                Hashtable gr = (Hashtable)this.containers.get(group);
                if (gr != null && gr.get(containerName) != null) {
                    Vector engines = (Vector)gr.get(containerName);
                    if (engines.contains(name)) {
                        throw new JeusServerException(JeusMessage_Manager._152, name);
                    }
                    try {
                        J2EEServerMBean serverMBean = this.getJ2EEServerMBean(containerName);
                        serverMBean.startEngine(name);
                    }
                    catch (Throwable ex) {
                        throw new JeusServerException(JeusMessage_Manager._153, new String[]{name, containerName}, ex);
                    }
                    ((Vector)gr.get(containerName)).add(name);
                    boolean bl = true;
                    return bl;
                }
            }
            Vector<String> enginelist = new Vector<String>();
            enginelist.add(name);
            containerName = ecdesc.getName();
            if (!this.startContainer(group, containerName, ecdesc, enginelist, false)) {
                throw new JeusServerException(JeusMessage_Manager._154, new String[]{containerName, name});
            }
            if (logger.isLoggable(JeusMessage_Manager._150_LEVEL)) {
                logger.log(JeusMessage_Manager._150_LEVEL, JeusMessage_Manager._150, new Object[]{name, containerName});
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public static EngineContainerDescriptor getEngineContainerDescriptorFromEngineName(JeusMainDescriptor desc, String name) throws JeusServerException {
        EngineContainerDescriptor ecdesc2 = null;
        for (EngineContainerDescriptor ecdesc2 : desc.engineContainers.values()) {
            if (ecdesc2.engineNames.contains(name)) break;
            ecdesc2 = null;
        }
        if (ecdesc2 == null) {
            throw new JeusServerException(JeusMessage_Manager._151, name);
        }
        return ecdesc2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAllContainer(String hostName) throws JeusServerException {
        LoginUtil.checkPermissionWithCodeSubject((Permission)containerManagerPermission);
        try {
            if (!this.server.isBooted()) {
                if (logger.isLoggable(JeusMessage_Manager._156_LEVEL)) {
                    logger.log(JeusMessage_Manager._156_LEVEL, JeusMessage_Manager._156, (Object[])new String[]{hostName, this.server.getServerState()});
                }
                boolean bl = false;
                return bl;
            }
            JeusMainDescriptor desc = JeusServer.readJeusMainDescriptor(hostName);
            EngineSync sync = null;
            boolean isSequentialStart = desc.isSerialStart();
            Vector bootedEngList = null;
            if (!isSequentialStart) {
                sync = new EngineSync(desc.engineContainers.size());
            } else {
                bootedEngList = new Vector();
            }
            String containerName = "";
            if (!isSequentialStart) {
                Hashtable hashtable = this.containers;
                synchronized (hashtable) {
                    for (EngineContainerDescriptor ecdesc : desc.engineContainers.values()) {
                        try {
                            containerName = ecdesc.getName();
                            this.innerStartContainer(hostName, ecdesc, null, sync, false);
                        }
                        catch (Throwable t) {
                            if (!logger.isLoggable(JeusMessage_Manager._124_LEVEL)) continue;
                            logger.log(JeusMessage_Manager._124_LEVEL, JeusMessage_Manager._124, (Object)containerName, t);
                        }
                    }
                }
            }
            Iterator i = desc.engineContainers.values().iterator();
            while (i.hasNext()) {
                try {
                    EngineContainerDescriptor ecdesc = (EngineContainerDescriptor)i.next();
                    containerName = ecdesc.getName();
                    sync = new EngineSync(1);
                    Hashtable hashtable = this.containers;
                    synchronized (hashtable) {
                        this.innerStartContainer(hostName, ecdesc, null, sync, false);
                    }
                    sync.waiting();
                    if (sync.getList().size() != 1) continue;
                    bootedEngList.add(containerName);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_Manager._124_LEVEL)) continue;
                    logger.log(JeusMessage_Manager._124_LEVEL, JeusMessage_Manager._124, (Object)containerName, t);
                }
            }
            if (!isSequentialStart) {
                sync.waiting();
                bootedEngList = sync.getList();
            }
            boolean bl = bootedEngList.size() == desc.engineContainers.size();
            return bl;
        }
        catch (Throwable t) {
            throw new JeusServerException(JeusMessage_Manager._157, t);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public boolean startContainer(String group, String containerName) {
        return this.startContainer(group, containerName, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startContainer(String group, String containerName, EngineContainerDescriptor ecdesc, Vector enginelist, boolean restart) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)containerManagerPermission);
        try {
            EngineSync sync;
            if (!this.server.isBooted()) {
                if (logger.isLoggable(JeusMessage_Manager._158_LEVEL)) {
                    logger.log(JeusMessage_Manager._158_LEVEL, JeusMessage_Manager._158, (Object[])new String[]{containerName, this.server.getServerState()});
                }
                boolean bl = false;
                return bl;
            }
            if (ecdesc == null) {
                JeusMainDescriptor desc = JeusMainDescriptorJB.getJeusMainDescriptor(group);
                ecdesc = (EngineContainerDescriptor)desc.engineContainers.get(containerName);
                if (ecdesc == null) {
                    throw new JeusServerException("The Container does not exist : " + containerName);
                }
            }
            Hashtable hashtable = this.containers;
            synchronized (hashtable) {
                sync = new EngineSync(1);
                this.innerStartContainer(group, ecdesc, enginelist, sync, restart);
            }
            sync.waiting();
            if (sync.getList().size() == 0) {
                throw new JeusServerException(JeusMessage_Manager._339, containerName);
            }
            if (logger.isLoggable(JeusMessage_Manager._149_LEVEL)) {
                logger.log(JeusMessage_Manager._149_LEVEL, JeusMessage_Manager._149, (Object)containerName);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Manager._124_LEVEL)) {
                logger.log(JeusMessage_Manager._124_LEVEL, JeusMessage_Manager._124, (Object)containerName, t);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public Enumeration getVirtualTerminals() {
        LoginService.checkCodeSubject();
        return this.terminals.elements();
    }

    public synchronized void removeVirtualTerminal(String group, String containerName) {
        Hashtable gr = (Hashtable)this.containers.get(group);
        if (gr != null) {
            gr.remove(containerName);
            if (gr.size() == 0) {
                this.containers.remove(group);
            }
        }
        this.terminals.remove(containerName);
        this.pidMap.remove(containerName);
    }

    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            this.jeusManagerMBean.removeNotificationListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.destroyMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopContainers() {
        Hashtable hashtable = this.containers;
        synchronized (hashtable) {
            for (int i = 0; i < this.initializingContainerTerminals.size(); ++i) {
                block12: {
                    VirtualTerminal vt = (VirtualTerminal)this.initializingContainerTerminals.remove(i);
                    String initContainerName = vt.getContainerName();
                    this.initializingContainerProcesses.remove(i);
                    if (!(vt instanceof DefaultEngineContainer.BootThread)) {
                        vt.down();
                        try {
                            vt.kill();
                        }
                        catch (Throwable t) {
                            if (!logger.isLoggable(JeusMessage_Manager._159_LEVEL)) break block12;
                            logger.log(JeusMessage_Manager._159_LEVEL, JeusMessage_Manager._159, (Object)initContainerName, t);
                        }
                    }
                }
                this.initializingContainerNames.remove(i);
            }
            Enumeration key = this.containers.keys();
            while (key.hasMoreElements()) {
                Hashtable gr = (Hashtable)this.containers.remove(key.nextElement());
                Enumeration en = gr.keys();
                while (en.hasMoreElements()) {
                    ObjectName containerObjectName = this.innerDownContainer((String)en.nextElement());
                    LoginUtil.loginCodeSubjectWithRuntimeException();
                    try {
                        this.jeusManagerMBean.removeChild(containerObjectName);
                    }
                    finally {
                        LoginUtil.logoutWithRuntimeException();
                    }
                }
            }
            DefaultEngineContainer.defaultContainer = null;
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        block5: {
            String type = notification.getType();
            if (type.equals("jeus.server.started")) {
                this.startEngines(VirtualDNS.LOCAL_VIRTUALNAME, JeusMainDescriptorJB.getLocalJeusMainDescriptor());
            } else if (type.equals("jeus.server.stopping")) {
                try {
                    this.stopContainers();
                }
                catch (Throwable ex1) {
                    if (!logger.isLoggable(JeusMessage_Manager._160_LEVEL)) break block5;
                    logger.log(JeusMessage_Manager._160_LEVEL, JeusMessage_Manager._160, ex1);
                }
            }
        }
    }

    public String getJeusType() {
        return "ContainerManagerService";
    }

    private String preProcessFilePath(String original) {
        if (!original.endsWith("\\")) {
            return original;
        }
        int count = 0;
        int length = original.length() - 1;
        int fsIndex = length - 1;
        do {
            ++count;
        } while ((fsIndex = original.indexOf("\\", --length)) == length);
        if (count % 2 == 1) {
            return original.concat("\\");
        }
        return original;
    }

    private static class ContainerDownRunnable
    implements Runnable {
        private final J2EEServerMBean server;
        private final String containerName;
        private final VirtualTerminal vt;

        public ContainerDownRunnable(J2EEServerMBean server, String containerName, VirtualTerminal vt) {
            this.server = server;
            this.containerName = containerName;
            this.vt = vt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block16: {
                try {
                    MEJBUtility.setNotRetry((boolean)true);
                    this.server.down();
                }
                catch (Throwable ex) {
                    boolean normalExit = false;
                    if (ex instanceof JeusLocalizedException) {
                        Throwable nested;
                        JeusLocalizedException e = (JeusLocalizedException)ex;
                        if (e.getMessageNumber() == JeusMessage_JMX.JMX_06 && (nested = e.getCause()) instanceof NamingException) {
                            normalExit = true;
                        }
                    } else if (ex instanceof UndeclaredThrowableException && (ex.getCause() instanceof MBSCAlreadyClosedException || ex.getCause() instanceof IOException)) {
                        normalExit = true;
                    }
                    if (normalExit) break block16;
                    if (JEUSService.logger.isLoggable(JeusMessage_Manager._137_LEVEL)) {
                        JEUSService.logger.log(JeusMessage_Manager._137_LEVEL, JeusMessage_Manager._137, (Object)this.containerName, ex);
                    }
                    if (this.vt == null) {
                        if (JEUSService.logger.isLoggable(JeusMessage_Manager._138_LEVEL)) {
                            JEUSService.logger.log(JeusMessage_Manager._138_LEVEL, JeusMessage_Manager._138);
                        }
                        break block16;
                    }
                    try {
                        this.vt.kill();
                        if (JEUSService.logger.isLoggable(JeusMessage_Manager._139_LEVEL)) {
                            JEUSService.logger.log(JeusMessage_Manager._139_LEVEL, JeusMessage_Manager._139, (Object)this.containerName);
                        }
                    }
                    catch (Throwable t) {
                        if (JEUSService.logger.isLoggable(JeusMessage_Manager._140_LEVEL)) {
                            JEUSService.logger.log(JeusMessage_Manager._140_LEVEL, JeusMessage_Manager._140, (Object)this.containerName, ex);
                        }
                    }
                }
                finally {
                    MEJBUtility.setNotRetry((boolean)false);
                }
            }
        }
    }
}

