/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.JAXRResource;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.service.JAXRResourceServiceMBean;
import jeus.server.service.JEUSService;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.JaxrEntryType;
import jeus.xml.binding.jeusDD.JaxrPropertyType;
import jeus.xml.binding.jeusDD.JaxrSourceType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.ResourceType;

public class JAXRResourceService
extends JEUSService
implements JAXRResourceServiceMBean {
    private ResourcePermission jaxrResourcePermission;
    private static final List NULL_JAXR_ENTRY = new ArrayList();

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        JAXRResourceService mo = new JAXRResourceService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "JAXRResourceService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.jaxrResourcePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"jaxrResource");
    }

    public String getJeusType() {
        return "JAXRResourceService";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName bindJaxrResource(JaxrEntryType jaxrEntry) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.jaxrResourcePermission);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("jeus.jndi.jns.forcedbindings", "true");
        env.put("jeus.jndi.jns.replicatebindings", "false");
        ObjectName objName = null;
        try {
            InitialContext ctx = new InitialContext(env);
            ctx.rebind(jaxrEntry.getExportName(), this.createBindingObject(jaxrEntry));
            objName = JAXRResource.reCreateMBean(jaxrEntry.getExportName(), this.getObjectName(), jaxrEntry).getObjectName();
        }
        catch (InstanceAlreadyExistsException iae) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
        return objName;
    }

    public void startService(Object obj) throws JeusException {
        JeusServer server = (JeusServer)obj;
        LoginService.checkCodeSubject();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("jeus.jndi.jns.forcedbindings", "true");
        env.put("jeus.jndi.jns.replicatebindings", "false");
        try {
            InitialContext ctx = new InitialContext(env);
            JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
            List jaxrEntries = this.getJaxrEntries(desc);
            for (int i = 0; i < jaxrEntries.size(); ++i) {
                JaxrEntryType jaxrEntry = (JaxrEntryType)jaxrEntries.get(i);
                ctx.rebind(jaxrEntry.getExportName(), this.createBindingObject(jaxrEntry));
                try {
                    JAXRResource.createMBean(jaxrEntry.getExportName(), this.getObjectName(), jaxrEntry);
                    continue;
                }
                catch (InstanceAlreadyExistsException iae) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            this.destroyMBean();
            throw new JeusServerException(JeusMessage_Manager._167, e);
        }
    }

    public void stopService() throws JeusException {
        LoginService.checkCodeSubject();
        this.destroyMBean();
    }

    private List getJaxrEntries(JeusMainDescriptor desc) {
        JeusSystemType jeusSystem = desc.getJeusSystem();
        ResourceType resource = jeusSystem.getResource();
        if (resource == null) {
            return NULL_JAXR_ENTRY;
        }
        JaxrSourceType jaxrSource = resource.getJaxrSource();
        if (jaxrSource == null) {
            return NULL_JAXR_ENTRY;
        }
        return jaxrSource.getJaxrEntry();
    }

    private Object createBindingObject(JaxrEntryType jaxrEntry) throws JAXRException {
        String factoryClassName = jaxrEntry.getConnectionFactoryClassName();
        if (factoryClassName == null || factoryClassName.trim().length() == 0) {
            factoryClassName = "jeus.webservices.registry.ConnectionFactoryImpl";
        }
        ConnectionFactory connectionFactory = this.newConnectionFactory(factoryClassName);
        Properties confProps = new Properties();
        if (jaxrEntry.getQueryManagerURL() != null) {
            confProps.put("javax.xml.registry.queryManagerURL", jaxrEntry.getQueryManagerURL());
        }
        if (jaxrEntry.getLifeCycleManagerURL() != null) {
            confProps.put("javax.xml.registry.lifeCycleManagerURL", jaxrEntry.getLifeCycleManagerURL());
        }
        if (jaxrEntry.getAuthenticationMethod() != null) {
            confProps.put("javax.xml.registry.security.authenticationMethod", jaxrEntry.getAuthenticationMethod());
        }
        if (jaxrEntry.getJaxrProperty() != null) {
            List jaxrProperties = jaxrEntry.getJaxrProperty();
            for (int i = 0; i < jaxrProperties.size(); ++i) {
                JaxrPropertyType jaxrProperty = (JaxrPropertyType)jaxrProperties.get(i);
                confProps.put(jaxrProperty.getName(), jaxrProperty.getValue());
            }
        }
        connectionFactory.setProperties(confProps);
        return connectionFactory;
    }

    private ConnectionFactory newConnectionFactory(String factoryClassName) throws JAXRException {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new JAXRException(x.toString(), (Throwable)x);
        }
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(factoryClassName) : classLoader.loadClass(factoryClassName);
            return (ConnectionFactory)spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new JAXRException("Provider " + factoryClassName + " not found", (Throwable)x);
        }
        catch (Exception x) {
            throw new JAXRException("Provider " + factoryClassName + " could not be instantiated: " + x, (Throwable)x);
        }
    }
}

