/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.descriptor.jeusserver.MailSessionDescriptor;
import jeus.jndi.objectfactory.MailSessionResource;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.JavaMailResource;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.service.JEUSService;
import jeus.server.service.JavaMailResourceServiceMBean;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.MailEntryType;

public class JavaMailResourceService
extends JEUSService
implements JavaMailResourceServiceMBean {
    private ResourcePermission javaMailPermission;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        JavaMailResourceService mo = new JavaMailResourceService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "JavaMailResourceService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.javaMailPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"javaMailResource");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("jeus.jndi.jns.forcedbindings", "true");
            env.put("jeus.jndi.jns.replicatebindings", "false");
            InitialContext ctx = new InitialContext(env);
            JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
            Enumeration e = desc.mailSession.elements();
            while (e.hasMoreElements()) {
                MailSessionDescriptor maildesc = (MailSessionDescriptor)e.nextElement();
                ctx.rebind(maildesc.getExportName(), (Object)new MailSessionResource(maildesc.properties));
                try {
                    JavaMailResource.createMBean(maildesc.getExportName(), JeusServer.jeusManager.getObjectName(), maildesc);
                }
                catch (InstanceAlreadyExistsException iae) {}
            }
        }
        catch (Throwable e) {
            this.destroyMBean();
            throw new JeusServerException(JeusMessage_Manager._167, e);
        }
    }

    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        this.destroyMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName bindMailResource(MailEntryType mailEntryType) {
        LoginUtil.checkPermissionWithCodeSubject((Permission)this.javaMailPermission);
        ObjectName objName = null;
        try {
            MailSessionDescriptor maildesc = JeusMainDescriptorJB.getMailSessionDescriptor(mailEntryType);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("jeus.jndi.jns.forcedbindings", "true");
            env.put("jeus.jndi.jns.replicatebindings", "false");
            InitialContext ctx = new InitialContext(env);
            ctx.rebind(maildesc.getExportName(), (Object)new MailSessionResource(maildesc.properties));
            try {
                objName = JavaMailResource.reCreateMBean(maildesc.getExportName(), JeusServer.jeusManager.getObjectName(), maildesc).getObjectName();
            }
            catch (InstanceAlreadyExistsException iae) {
                // empty catch block
            }
        }
        catch (Throwable e) {
            ObjectName objectName = null;
            return objectName;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
        return objName;
    }

    public String getJeusType() {
        return "JavaMailResourceService";
    }
}

