/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.loganalyzer.StackTraceResult;
import jeus.loganalyzer.StackTraceService;
import jeus.loganalyzer.analysis.AccessLogParser;
import jeus.loganalyzer.analysis.Channel;
import jeus.loganalyzer.analysis.ErrorLogParser;
import jeus.loganalyzer.analysis.LogParser;
import jeus.loganalyzer.analysis.Task;
import jeus.loganalyzer.analysis.TaskStatus;
import jeus.loganalyzer.common.RuleInfo;
import jeus.loganalyzer.util.LogConstants;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServerException;
import jeus.server.service.JEUSService;
import jeus.server.service.LogAnalyzerServiceMBean;
import jeus.tool.util.FileUtil;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.properties.JeusPropertyValues;

public class LogAnalyzerService
extends JEUSService
implements LogAnalyzerServiceMBean {
    private ResourcePermission logAnalyzerPermission;
    private StackTraceService stackTraceService;
    private LogParser parser;
    private String fs = JeusBootstrapPropertyValues.fs;
    private String resultDir = JeusPropertyValues.JEUS_LOGANALYZER_HOME + this.fs + "__task__";
    private ArrayList threadGroups = new ArrayList();

    public LogAnalyzerService() {
        this.stackTraceService = new StackTraceService();
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        LogAnalyzerService mo = new LogAnalyzerService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "LogAnalyzerService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.logAnalyzerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"logAnalyzer");
    }

    public void startService(Object obj) throws JeusServerException {
    }

    public void stopService() throws JeusServerException {
    }

    public StackTraceResult stackTrace(String pattern, String fileName, long startPos) throws IOException {
        return this.stackTraceService.stackTrace(pattern, fileName, startPos);
    }

    public void executeAnalyzer(RuleInfo ri) throws Exception {
        this.parser = ri.getLoggerType().equals("ACCESS_LOGGER") ? new AccessLogParser(ri) : new ErrorLogParser(ri);
        Channel channel = new Channel(ri.getTaskName(), 1);
        channel.startWorker();
        channel.putRequest(this.parser);
        this.threadGroups.add(channel.getThreadGroup());
    }

    public String[] getColumns(String taskname, String result) {
        File file = new File(this.resultDir + this.fs + taskname);
        if (!file.exists() || !file.isDirectory()) {
            return new String[0];
        }
        return this.getTitleColumns(result);
    }

    private String[] getTitleColumns(String result) {
        if (result.startsWith("CLIENTIP_STATISTICS")) {
            return LogConstants.ip_columnNames;
        }
        if (result.startsWith("REQUESTURI_STATISTICS")) {
            return LogConstants.uri_columnNames;
        }
        if (result.startsWith("TIME")) {
            return LogConstants.time_columnNames;
        }
        if (result.startsWith("DAY") || result.startsWith("MONTH") || result.startsWith("WEEK") || result.startsWith("YEAR")) {
            return LogConstants.day_columnNames;
        }
        if (result.endsWith("errorlog") || result.endsWith("accesslog")) {
            return LogConstants.contents;
        }
        return LogConstants.pattern_columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[][] getData(String taskname, String result, int rowsLen, int columsLen) throws Exception {
        String path = this.resultDir + this.fs + taskname + this.fs + "report";
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            return new String[0][0];
        }
        ObjectInputStream oin = null;
        RandomAccessFile resultFile = null;
        String[][] data = new String[rowsLen][columsLen];
        try {
            FileInputStream fin = new FileInputStream(path + this.fs + "Idx" + this.fs + result + ".idx");
            oin = new ObjectInputStream(fin);
            Long[] idxing = (Long[])oin.readObject();
            resultFile = new RandomAccessFile(path + this.fs + result + ".txt", "r");
            for (int i = 0; i < rowsLen; ++i) {
                resultFile.seek(idxing[i]);
                String line = resultFile.readLine();
                StringTokenizer token = new StringTokenizer(line, "\t");
                int j = 0;
                while (token.hasMoreTokens()) {
                    data[i][j] = token.nextToken();
                    ++j;
                }
            }
        }
        finally {
            if (oin != null) {
                oin.close();
            }
            if (resultFile != null) {
                resultFile.close();
            }
        }
        return data;
    }

    public String[][] getRows(String taskname, String result, int pageSize, int page) throws Exception {
        int columsLen = this.getColumns(taskname, result).length;
        int rowsLen = this.getTotalRowsCount(taskname, result);
        String[][] data = null;
        data = result.endsWith("accesslog") || result.endsWith("errorlog") ? this.getFilterData(taskname, result, rowsLen, columsLen) : this.getData(taskname, result, rowsLen, columsLen);
        int start = (page - 1) * pageSize;
        int count = rowsLen - start;
        if (count > pageSize) {
            count = pageSize;
        }
        String[][] rows = new String[count][columsLen];
        for (int i = 0; i < count; ++i) {
            rows[i] = data[start + i];
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[][] getFilterData(String taskname, String result, int rowsLen, int columsLen) throws Exception {
        String path = this.resultDir + this.fs + taskname + this.fs + "report";
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            return new String[0][0];
        }
        BufferedReader resultFile = null;
        String[][] data = new String[rowsLen][columsLen];
        try {
            resultFile = new BufferedReader(new FileReader(path + this.fs + result + ".txt"));
            int i = 0;
            String line = null;
            while ((line = resultFile.readLine()) != null) {
                if (line.equals("<<__Exception__>>")) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(line + "\n");
                    while (!(line = resultFile.readLine()).equals("<<__!Exception__>>")) {
                        buf.append(line + "\n");
                    }
                    buf.append(line + "\n");
                    data[i][0] = buf.toString();
                } else {
                    data[i][0] = line;
                }
                ++i;
            }
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] getTasks() throws Exception {
        File node = new File(this.resultDir);
        File[] childs = node.listFiles();
        String taskName = null;
        String fileName = null;
        ArrayList<Task> taskList = new ArrayList<Task>();
        ObjectInputStream oin = null;
        try {
            for (int i = 0; childs != null && i < childs.length; ++i) {
                if (!childs[i].isDirectory()) continue;
                taskName = childs[i].getName();
                File[] child = childs[i].listFiles();
                for (int j = 0; child != null && j < child.length; ++j) {
                    fileName = child[j].getName();
                    if (!fileName.equals(taskName + ".ser")) continue;
                    FileInputStream fin = new FileInputStream(child[j].getAbsolutePath());
                    oin = new ObjectInputStream(fin);
                    Task task = null;
                    try {
                        while (true) {
                            task = (Task)oin.readObject();
                        }
                    }
                    catch (IOException e) {
                        fin.close();
                        if (task == null) continue;
                        if (task.getStatus() == TaskStatus.RUNNING && !this.checkTask(task.getThreadID())) {
                            task.setStatus(TaskStatus.FAILED);
                            this.reSaveSerFile(task, child[j].getAbsolutePath());
                        }
                        taskList.add(task);
                    }
                }
            }
        }
        finally {
            if (oin != null) {
                oin.close();
            }
        }
        if (taskList.size() > 0) {
            return taskList.toArray(new Task[taskList.size()]);
        }
        return new Task[0];
    }

    private boolean checkTask(String threadId) {
        boolean checkFlag = false;
        if (threadId == null) {
            return checkFlag;
        }
        if (this.threadGroups != null) {
            ThreadGroup[] groups = this.threadGroups.toArray(new ThreadGroup[this.threadGroups.size()]);
            for (int i = 0; i < groups.length; ++i) {
                Thread[] threadList = new Thread[groups[i].activeCount()];
                int length = groups[i].enumerate(threadList, false);
                for (int j = 0; j < length; ++j) {
                    if (!threadList[j].getName().equals(threadId)) continue;
                    checkFlag = true;
                }
            }
        }
        return checkFlag;
    }

    private void reSaveSerFile(Task task, String serPath) throws IOException {
        FileOutputStream fos = new FileOutputStream(serPath);
        ObjectOutputStream statusWriter = new ObjectOutputStream(fos);
        statusWriter.reset();
        statusWriter.writeObject(task);
        statusWriter.flush();
        statusWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRowsCount(String taskname, String result) throws IOException {
        int totalRows = 0;
        Properties resultList = new Properties();
        File file = new File(this.resultDir + this.fs + taskname, "resultList");
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            resultList.load(fin);
            String value = resultList.getProperty(result);
            if (value != null) {
                value = value.trim();
                totalRows = Integer.parseInt(value);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return totalRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResultNames(String taskname) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.resultDir + this.fs + taskname + this.fs + "resultList"));
            String line = null;
            while ((line = in.readLine()) != null) {
                StringTokenizer token = new StringTokenizer(line, "=");
                list.add(token.nextToken());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public synchronized void removeTask(String taskname) throws Exception {
        File node = new File(this.resultDir + this.fs + taskname);
        if (node.isDirectory()) {
            File[] child = node.listFiles();
            for (int i = 0; child != null && i < child.length; ++i) {
                String fileName = child[i].getName();
                if (!fileName.equals(taskname + ".ser")) continue;
                FileUtil.rmdir(node.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExcelPath(String taskname, String filename) throws IOException {
        String destPath = this.resultDir + this.fs + taskname + this.fs + "html" + this.fs + filename + ".html";
        String path = this.resultDir + this.fs + taskname + this.fs + "report";
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            return new String("");
        }
        File dest = new File(destPath);
        if (!dest.exists()) {
            if (dest.getParent() != null) {
                new File(dest.getParent()).mkdirs();
            }
            StringBuffer buf = this.generateHTML(path, filename);
            BufferedWriter htmlFile = null;
            try {
                htmlFile = new BufferedWriter(new FileWriter(destPath));
                htmlFile.write(buf.toString());
                htmlFile.flush();
            }
            finally {
                if (htmlFile != null) {
                    htmlFile.close();
                }
            }
        }
        return destPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer generateHTML(String path, String filename) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader resultFile = null;
        StringTokenizer tokens = null;
        try {
            resultFile = new BufferedReader(new FileReader(path + this.fs + filename + ".txt"));
            String line = null;
            buf.append("<html><br>\n");
            buf.append("<head><title>" + filename + "</title></head><br>\n");
            buf.append("<body><br>\n");
            buf.append("<table border=1><br>\n");
            String[] columns = this.getTitleColumns(filename);
            buf.append("<tr>\n");
            for (int i = 0; i < columns.length; ++i) {
                buf.append("<td>" + columns[i] + "</td>\n");
            }
            buf.append("</tr>\n");
            while ((line = resultFile.readLine()) != null) {
                tokens = new StringTokenizer(line, "\t");
                buf.append("<tr>\n");
                while (tokens.hasMoreTokens()) {
                    buf.append("<td>" + tokens.nextToken() + "</td>\n");
                }
                buf.append("</tr>\n");
            }
            buf.append("</table><br>\n</body><br>\n</html>\n");
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
            }
        }
        return buf;
    }

    public String getJeusType() {
        return "LogAnalyzerService";
    }
}

