/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.schedule.ContainerSchedulerService;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.service.ContainerService;
import jeus.server.service.ContainerServiceMBean;
import jeus.server.service.SchedulerServiceMBean;
import jeus.util.JeusException;

public class SchedulerService
extends ContainerService
implements SchedulerServiceMBean {
    private ResourcePermission schedulerPermission;
    private ContainerSchedulerService schedulerService = new ContainerSchedulerService();
    private boolean isNodeService;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        SchedulerService mo = new SchedulerService();
        return mo.createMBean(srvName, "JeusService", parent, ContainerServiceMBean.parentKeyMap, "SchedulerService");
    }

    public String getJeusType() {
        return "SchedulerService";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.schedulerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"scheduler");
    }

    public void startService(Object obj) throws JeusException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.schedulerPermission);
        this.isNodeService = true;
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        if (desc.isSchedulerEnabled() && !this.schedulerService.isStarted()) {
            this.schedulerService.startNodeService(desc.getSchedulerThreadPool(), desc.getJobDescriptor());
        }
    }

    public void startService(EngineContainerDescriptor desc, EngineContainer container) throws JeusException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.schedulerPermission);
        this.isNodeService = false;
        if (desc.isSchedulerEnabled() && !this.schedulerService.isStarted()) {
            this.schedulerService.startContainerService(desc.getSchedulerThreadPool(), desc.getJobDescriptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.schedulerPermission);
        try {
            if (this.isNodeService) {
                this.schedulerService.stopNodeService();
            } else {
                this.schedulerService.stopContainerService();
            }
        }
        finally {
            this.destroyMBean();
        }
    }
}

