/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.net.URL;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.descriptor.jeusserver.URLDescriptor;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.URLResource;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.service.JEUSService;
import jeus.server.service.URLResourceServiceMBean;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.UrlEntryType;

public class URLResourceService
extends JEUSService
implements URLResourceServiceMBean {
    private ResourcePermission urlResourcePermission;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        URLResourceService mo = new URLResourceService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "URLResourceService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.urlResourcePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"urlResource");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("jeus.jndi.jns.forcedbindings", "true");
            env.put("jeus.jndi.jns.replicatebindings", "false");
            InitialContext ctx = new InitialContext(env);
            JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
            Enumeration e = desc.urls.elements();
            while (e.hasMoreElements()) {
                URLDescriptor urldesc = (URLDescriptor)e.nextElement();
                String exportName = urldesc.getExportName();
                String url = urldesc.getURL();
                ctx.rebind(exportName, (Object)new URL(url));
                try {
                    URLResource.createMBean(exportName, JeusServer.jeusManager.getObjectName(), urldesc);
                }
                catch (InstanceAlreadyExistsException iae) {
                    // empty catch block
                }
                if (!logger.isLoggable(JeusMessage_Manager._194_LEVEL)) continue;
                logger.log(JeusMessage_Manager._194_LEVEL, JeusMessage_Manager._194, new Object[]{exportName, url});
            }
        }
        catch (Throwable e) {
            this.stopService();
            throw new JeusServerException(JeusMessage_Manager._195, e);
        }
    }

    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        this.destroyMBean();
    }

    public ObjectName bindURLResource(UrlEntryType urlEntryType) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.urlResourcePermission);
        ObjectName objName = null;
        try {
            URLDescriptor desc = new URLDescriptor();
            if (urlEntryType.getExportName() != null) {
                desc.setExportName(urlEntryType.getExportName());
            }
            if (urlEntryType.getUrl() != null) {
                desc.setURL(urlEntryType.getUrl());
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("jeus.jndi.jns.forcedbindings", "true");
            env.put("jeus.jndi.jns.replicatebindings", "false");
            InitialContext ctx = new InitialContext(env);
            ctx.rebind(urlEntryType.getExportName(), (Object)new URL(urlEntryType.getUrl()));
            try {
                objName = URLResource.reCreateMBean(urlEntryType.getExportName(), JeusServer.jeusManager.getObjectName(), desc).getObjectName();
            }
            catch (InstanceAlreadyExistsException iae) {}
        }
        catch (Throwable e) {
            return null;
        }
        return objName;
    }

    public String getJeusType() {
        return "URLResourceService";
    }
}

