/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.archive;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.InputJarArchive;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.ejb.util.JeusRemoteClassLoader;
import jeus.server.enginecontainer.EngineContainer;
import jeus.service.archive.ArchiveClassLoader;
import jeus.servlet.loader.ApplicationClassReleaser;
import jeus.util.JeusCollections;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_EJB;
import jeus.util.message.JeusMessage_EJB11;

public class ArchiveArrayClassLoader
extends ArchiveClassLoader
implements JeusRemoteClassLoader {
    public static final String ISOLATED_CLASSLOADING = "ISOLATED";
    protected static final Semaphore semaphore = new Semaphore(1, true);
    protected final EJBRootClassLoader parent;
    protected boolean isIsolated;
    protected String loaderName;
    protected int count;
    private final Vector classftpArchives;

    public static ArchiveArrayClassLoader createClassLoader(AbstractArchive[] archives, EJBRootClassLoader parent, boolean isIsolated, String moduleName) {
        return new ArchiveArrayClassLoader(archives, parent, isIsolated, moduleName);
    }

    private ArchiveArrayClassLoader(EJBRootClassLoader parent) {
        super(parent);
        this.classftpArchives = new Vector();
        this.parent = parent;
    }

    private ArchiveArrayClassLoader(AbstractArchive[] archives, EJBRootClassLoader parent, boolean isIsolated, String loaderName) {
        block5: {
            super(archives, (ClassLoader)parent);
            this.classftpArchives = new Vector();
            this.parent = parent;
            this.isIsolated = isIsolated;
            this.loaderName = loaderName;
            try {
                EngineContainer.rootClassLoader.load(loaderName, this, isIsolated);
            }
            catch (Throwable e) {
                throw new JeusRuntimeException(e);
            }
            if (!isIsolated) {
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e) {
                    if (!logger.isLoggable(JeusMessage_EJB.EJB_35_LEVEL)) break block5;
                    logger.log(JeusMessage_EJB.EJB_35_LEVEL, JeusMessage_EJB.EJB_35, (Throwable)e);
                }
            }
        }
    }

    public synchronized void clear() {
        if (this.closed) {
            return;
        }
        ApplicationClassReleaser.releaseApplicationClasses(this);
        for (Object classftpArchive : this.classftpArchives) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Close the archive: {0}", (Object)((InputJarArchive)classftpArchive).getArchiveUri());
            }
            try {
                ((InputJarArchive)classftpArchive).close();
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "Could not close the archive: " + ((InputJarArchive)classftpArchive).getArchiveUri(), (Throwable)e);
            }
        }
        super.clear();
    }

    public URL getResource(String name) {
        this.logIfClosed(name);
        if (this.isIsolated) {
            URL url = this.parent != null ? this.parent.getResourceFromSuper(name) : ArchiveArrayClassLoader.getSystemResource(name);
            if (url == null) {
                url = this.findResource(name);
            }
            return url;
        }
        return this.parent.getResource(name);
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class classObj;
        this.logIfClosed(className);
        Object obj = this.findLoadedClassFromTable(className);
        if (obj instanceof Class) {
            classObj = (Class)obj;
        } else if (this.isIsolated) {
            try {
                classObj = this.parent.loadClassIsolated(className, false);
            }
            catch (ClassNotFoundException ex) {
                Class classObj2 = this.loadClassWithoutDelegation(className);
                if (classObj2 != null) {
                    if (resolve) {
                        this.resolveClass(classObj2);
                    }
                    return classObj2;
                }
                throw new ClassNotFoundException(className, ex);
            }
        } else {
            classObj = this.parent.loadClass(className, false);
        }
        if (resolve) {
            this.resolveClass(classObj);
        }
        return classObj;
    }

    public String getCodeBasePath(String className) {
        AbstractArchive archive = this.getCorrespondingArchive(className);
        String archivePath = archive.getClassFtpUri(this.count);
        return archivePath.replace(File.separatorChar, '/');
    }

    public AbstractArchive getCorrespondingArchive(String className) {
        AbstractArchive archive;
        this.checkIllegalState();
        String aClass = ArchiveArrayClassLoader.getEntryName(className);
        for (Object classftpArchive : this.classftpArchives) {
            archive = (AbstractArchive)classftpArchive;
            try {
                if (!archive.contains(aClass)) continue;
                return archive;
            }
            catch (IOException e) {
            }
        }
        archive = super.getCorrespondingArchive(className);
        return archive;
    }

    public void setCount(int count) {
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllClasses() throws ClassNotFoundException {
        try {
            super.loadAllClasses();
        }
        finally {
            this.releaseLock();
        }
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.isIsolated) {
            return this.findResourcesWithoutDelegate(name);
        }
        return JeusCollections.dummyEnumeration;
    }

    public void releaseLock() {
        if (!this.isIsolated) {
            semaphore.release();
        }
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public void addClassFTPArchive(InputJarArchive classFtpJar) {
        this.classftpArchives.add(classFtpJar);
    }

    public ClassLoader getNewTempClassLoader() {
        this.checkIllegalState();
        ArchiveArrayClassLoader loader = new ArchiveArrayClassLoader(this.parent);
        this.initNewTempClassLoader(loader);
        loader.isIsolated = this.isIsolated;
        loader.loaderName = this.loaderName;
        loader.count = this.count;
        return loader;
    }

    protected void logIfClosed(String resourceName) {
        if (this.closed && logger.isLoggable(JeusMessage_EJB11._8001_LEVEL)) {
            logger.log(JeusMessage_EJB11._8001_LEVEL, JeusMessage_EJB11._8001, new Object[]{this.loaderName, this.toString(), this.closedTime, Thread.currentThread().toString(), Thread.currentThread().getContextClassLoader().toString(), resourceName}, new Throwable("trace exception"));
        }
    }
}

