/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.persistence.spi.ClassTransformer;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.InputJarArchive;
import jeus.persistence.container.TransformableClassLoader;
import jeus.util.ClassUtil;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;

public class ArchiveClassLoader
extends ClassLoader
implements TransformableClassLoader {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb");
    protected static final Object NOT_FOUND = new Object();
    protected static final Object NOT_LOADED = new Object();
    protected AbstractArchive[] archives;
    protected String classPath;
    protected List<ClassTransformer> classTransformers;
    protected volatile boolean closed;
    protected String closedTime;
    protected final ConcurrentMap<String, Object> classTable = new ConcurrentHashMap<String, Object>();
    protected final ConcurrentMap<String, AbstractArchive> classArchiveMap = new ConcurrentHashMap<String, AbstractArchive>();
    protected final ConcurrentMap<String, Object> resourceMap = new ConcurrentHashMap<String, Object>();

    protected ArchiveClassLoader(ClassLoader parent) {
        super(parent);
    }

    public ArchiveClassLoader(AbstractArchive[] archives, ClassLoader parent) {
        super(parent);
        assert (archives != null);
        this.archives = archives;
        if (System.getSecurityManager() != null) {
            for (AbstractArchive archive : archives) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("archive: " + archive.getArchiveUri() + ", codeSource=" + archive.getCodeSource() + ", permissions=" + archive.getPermissionCollection());
                }
                assert (archive.getCodeSource() != null) : "code source is not set properly";
                ProtectionDomain pd = new ProtectionDomain(archive.getCodeSource(), archive.getPermissionCollection(), this, null);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("ProtectionDomain: " + pd);
                }
                archive.setProtectionDomain(pd);
            }
        }
        StringBuffer classPath = new StringBuffer();
        for (AbstractArchive archive : archives) {
            classPath.append(archive.getArchiveUri()).append(File.pathSeparator);
        }
        this.classPath = classPath.toString();
        this.registerClasses();
    }

    public ArchiveClassLoader(String[] classpath, ClassLoader parent) {
        this(ArchiveHelper.openArchives((String[])classpath), parent);
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void registerClasses() {
        this.checkIllegalState();
        for (AbstractArchive archive : this.archives) {
            Enumeration classes = archive.entries();
            while (classes.hasMoreElements()) {
                int index;
                String aClass = (String)classes.nextElement();
                if (aClass.startsWith("WEB-INF") || aClass.startsWith("META-INF") || !aClass.endsWith(".class") || this.classTable.putIfAbsent(aClass = aClass.substring(0, index = aClass.lastIndexOf(".class")).replace('/', '.'), NOT_LOADED) != null) continue;
                this.classArchiveMap.putIfAbsent(aClass, archive);
            }
        }
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class classObj;
        block5: {
            this.logIfClosed(className);
            Object obj = this.findLoadedClassFromTable(className);
            if (obj instanceof Class) {
                classObj = (Class)obj;
            } else {
                try {
                    classObj = this.getParent().loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    classObj = this.loadClassWithoutDelegation(className);
                    if (classObj != null) break block5;
                    throw new ClassNotFoundException(className, ex);
                }
            }
        }
        if (resolve) {
            this.resolveClass(classObj);
        }
        return classObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassWithoutDelegation(String className) {
        if (this.closed) {
            return null;
        }
        Object classEntry = this.classTable.get(className);
        if (classEntry instanceof Class) {
            return (Class)classEntry;
        }
        Object[] names = StringUtil.getNormalizedClassName((String)className);
        if (names != null) {
            Class classObj = this.loadClassWithoutDelegation((String)names[0]);
            if (classObj == null) {
                return null;
            }
            classObj = ClassUtil.getArrayClass(classObj, (Integer)names[1]);
            this.classTable.put(className, classObj);
            return classObj;
        }
        ArchiveClassLoader archiveClassLoader = this;
        synchronized (archiveClassLoader) {
            classEntry = this.classTable.get(className);
            if (classEntry instanceof Class) {
                return (Class)classEntry;
            }
            Class classObj = this.findAndPutLoadedClass(className);
            if (classObj != null) {
                return classObj;
            }
            AbstractArchive archive = (AbstractArchive)this.classArchiveMap.get(className);
            classObj = this.findClass0(className, archive);
            if (classObj != null) {
                this.classTable.put(className, classObj);
            }
            return classObj;
        }
    }

    public Object findLoadedClassFromTable(String className) {
        if (this.closed) {
            return null;
        }
        Object obj = this.classTable.get(className);
        if (obj != null) {
            Class loadedClass;
            if (!(obj instanceof Class) && (loadedClass = this.findAndPutLoadedClass(className)) != null) {
                obj = loadedClass;
            }
            return obj;
        }
        Object[] simpleClassNames = StringUtil.getNormalizedClassName((String)className);
        if (simpleClassNames != null) {
            String name = (String)simpleClassNames[0];
            obj = this.classTable.get(name);
            if (!(obj instanceof Class)) {
                Class loadedClass = this.findAndPutLoadedClass(name);
                if (loadedClass != null) {
                    loadedClass = ClassUtil.getArrayClass(loadedClass, (Integer)simpleClassNames[1]);
                    this.classTable.put(className, loadedClass);
                    obj = loadedClass;
                }
            } else {
                obj = ClassUtil.getArrayClass((Class)obj, (Integer)simpleClassNames[1]);
            }
            return obj;
        }
        return this.findAndPutLoadedClass(className);
    }

    private Class findAndPutLoadedClass(String className) {
        if (this.closed) {
            return null;
        }
        Class<?> obj = this.findLoadedClass(className);
        if (obj != null) {
            this.classTable.put(className, obj);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass0(String name, AbstractArchive archive) {
        Class clazz;
        InputStream is;
        if (this.closed) {
            return null;
        }
        boolean searchArchive = archive == null;
        String entryName = ArchiveClassLoader.getEntryName(name);
        if (searchArchive) {
            archive = (AbstractArchive)this.classArchiveMap.get(name);
            if (archive == null) {
                for (int k = 0; k < this.archives.length && !(archive = this.archives[k]).contains(entryName); ++k) {
                }
            }
            if (archive == null) {
                return null;
            }
        }
        if ((is = archive.getEntry(entryName)) == null) {
            return null;
        }
        if (searchArchive) {
            this.classArchiveMap.putIfAbsent(name, archive);
        }
        try {
            clazz = this.defineClass(is, name, archive.getProtectionDomain());
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error in loading class [" + name + "]", ex);
            }
        }
        try {
            is.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class cls = this.findClass0(name, null);
        if (cls == null) {
            throw new ClassNotFoundException(name);
        }
        return cls;
    }

    protected Class defineClass(InputStream is, String name, ProtectionDomain pd) throws IOException {
        String packageName;
        int lastPackageSep;
        int j;
        byte[] abyte0 = new byte[1024];
        int l = 0;
        while ((j = is.read(abyte0, l, abyte0.length - l)) != -1) {
            if ((l += j) < abyte0.length) continue;
            byte[] abyte1 = new byte[l * 2];
            System.arraycopy(abyte0, 0, abyte1, 0, l);
            abyte0 = abyte1;
        }
        if (l != abyte0.length) {
            byte[] abyte2 = new byte[l];
            System.arraycopy(abyte0, 0, abyte2, 0, l);
            abyte0 = abyte2;
        }
        if ((lastPackageSep = name.lastIndexOf(46)) != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
            try {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException iae) {
                logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, (Throwable)iae);
            }
        }
        if (this.classTransformers != null && this.classTransformers.size() > 0) {
            for (ClassTransformer transformer : this.classTransformers) {
                try {
                    byte[] transformed = transformer.transform((ClassLoader)this, name, null, pd, abyte0);
                    if (transformed == null) continue;
                    abyte0 = transformed;
                    if (!logger.isLoggable(Level.FINE)) continue;
                    Object[] params = new String[]{transformer.getClass().getName(), name};
                    logger.log(Level.FINE, "ClassTransformer {0} transformed {1} class", params);
                }
                catch (IllegalClassFormatException ex) {
                    if (logger.isLoggable(JeusMessage_EJB11._7192_LEVEL)) {
                        logger.log(JeusMessage_EJB11._7192_LEVEL, JeusMessage_EJB11._7192, (Object)name, (Throwable)ex);
                    }
                    throw new ClassFormatError(ex.getMessage());
                }
            }
        }
        return this.defineClass(name, abyte0, 0, abyte0.length, pd);
    }

    public void setCorrespondingArchiveForClass(String className, AbstractArchive archive) {
        this.checkIllegalState();
        this.classArchiveMap.put(className, archive);
    }

    public AbstractArchive getCorrespondingArchive(String className) {
        this.checkIllegalState();
        AbstractArchive archive = null;
        String aClass = ArchiveClassLoader.getEntryName(className);
        archive = (AbstractArchive)this.classArchiveMap.get(className);
        if (archive == null) {
            int i;
            for (i = 0; i < this.archives.length; ++i) {
                archive = this.archives[i];
                try {
                    if (!archive.contains(aClass)) continue;
                    this.classArchiveMap.put(className, archive);
                    return archive;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (i == this.archives.length) {
                throw new RuntimeException("There is no archive that contains the class " + className);
            }
        }
        return archive;
    }

    public void loadAllClasses() throws ClassNotFoundException {
        this.checkIllegalState();
        for (String className : this.classTable.keySet()) {
            Object classObj = this.classTable.get(className);
            if (classObj instanceof Class) continue;
            try {
                this.classTable.put(className, this.loadClass(className));
            }
            catch (NoClassDefFoundError ex) {
                throw ex;
            }
            catch (ClassNotFoundException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new JeusRuntimeException("class : " + className + ", message : " + ex.getMessage(), ex);
            }
        }
    }

    public Enumeration findResources(String name) throws IOException {
        return this.findResourcesWithoutDelegate(name);
    }

    public Enumeration findResourcesWithoutDelegate(String name) throws IOException {
        if (this.closed) {
            this.logIfClosed(name);
            return null;
        }
        ArrayList<URL> list = new ArrayList<URL>(this.archives.length);
        for (int k = 0; k < this.archives.length; ++k) {
            try {
                URL url = this.findResource0(this.archives[k], name);
                if (url == null) continue;
                list.add(url);
                continue;
            }
            catch (IOException e) {
                if (!logger.isLoggable(JeusMessage_EJB11._7186_LEVEL)) continue;
                logger.log(JeusMessage_EJB11._7186_LEVEL, JeusMessage_EJB11._7186, new Object[]{this.archives[k], name}, (Throwable)e);
            }
        }
        return Collections.enumeration(list);
    }

    public URL findResource(String name) {
        if (this.closed) {
            this.logIfClosed(name);
            return null;
        }
        Object url = this.resourceMap.get(name);
        if (url != null) {
            if (url == NOT_FOUND) {
                return null;
            }
            return (URL)url;
        }
        for (int k = 0; k < this.archives.length; ++k) {
            block6: {
                try {
                    url = this.findResource0(this.archives[k], name);
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_EJB11._7186_LEVEL)) break block6;
                    logger.log(JeusMessage_EJB11._7186_LEVEL, JeusMessage_EJB11._7186, new Object[]{this.archives[k], name}, (Throwable)e);
                }
            }
            if (url == null) continue;
            this.resourceMap.put(name, url);
            return (URL)url;
        }
        this.resourceMap.put(name, NOT_FOUND);
        return null;
    }

    private URL findResource0(AbstractArchive archive, String name) throws IOException {
        if (this.closed) {
            return null;
        }
        if (archive instanceof InputJarArchive) {
            if (archive.contains(name)) {
                InternalURLStreamHandler handler = new InternalURLStreamHandler((InputJarArchive)archive, name);
                URL ret = archive.getEntryURL(name, (URLStreamHandler)handler);
                handler.tieUrl(ret);
                return ret;
            }
        } else {
            URL ret = archive.getEntryURL(name);
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToClassList(String className) throws ClassNotFoundException {
        this.checkIllegalState();
        ArchiveClassLoader archiveClassLoader = this;
        synchronized (archiveClassLoader) {
            Object obj = this.findLoadedClassFromTable(className);
            if (obj == null || !(obj instanceof Class)) {
                this.classTable.put(className, this.findClass(className));
            }
        }
    }

    public boolean isIncluded(String className) {
        this.checkIllegalState();
        return this.classTable.containsKey(className);
    }

    public ClassLoader getNewTempClassLoader() {
        this.checkIllegalState();
        ArchiveClassLoader loader = new ArchiveClassLoader(this.getParent());
        return this.initNewTempClassLoader(loader);
    }

    protected ArchiveClassLoader initNewTempClassLoader(ArchiveClassLoader loader) {
        loader.archives = this.archives;
        loader.classPath = this.classPath;
        loader.classTable.putAll(this.classTable);
        for (String key : this.classTable.keySet()) {
            this.classTable.put(key, NOT_LOADED);
        }
        loader.classArchiveMap.putAll(this.classArchiveMap);
        loader.resourceMap.putAll(this.resourceMap);
        return loader;
    }

    public synchronized void addTransformer(ClassTransformer transformer) {
        if (this.classTransformers == null) {
            this.classTransformers = new ArrayList<ClassTransformer>();
        }
        this.classTransformers.add(transformer);
    }

    public synchronized void clear() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closedTime = new Date().toString();
        for (int k = 0; k < this.archives.length; ++k) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Close the archive: {0}", (Object)this.archives[k].getArchiveUri());
            }
            try {
                this.archives[k].close();
                continue;
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "Could not close the archive: " + this.archives[k].getArchiveUri(), (Throwable)e);
            }
        }
        this.classTable.clear();
        this.classArchiveMap.clear();
        this.resourceMap.clear();
    }

    protected final void checkIllegalState() {
        if (this.closed) {
            throw new IllegalStateException("Could not access closed ClassLoader");
        }
    }

    protected void logIfClosed(String resourceName) {
    }

    protected static String getEntryName(String className) {
        Object[] temp = StringUtil.getNormalizedClassName((String)className);
        if (temp != null) {
            className = (String)temp[0];
        }
        return className.replace('.', '/') + ".class";
    }

    private class InternalJarURLConnection
    extends JarURLConnection {
        private URL mURL;
        private InputJarArchive mArchive;
        private String mName;

        public InternalJarURLConnection(URL url, InputJarArchive archive, String name) throws MalformedURLException {
            super(url);
            this.mArchive = archive;
            this.mName = name;
        }

        public JarFile getJarFile() throws IOException {
            return this.mArchive.getJarFile();
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return this.mArchive.getEntry(this.mName);
        }
    }

    private class InternalURLStreamHandler
    extends URLStreamHandler {
        private URL mURL;
        private InputJarArchive mArchive;
        private String mName;

        public InternalURLStreamHandler(InputJarArchive archive, String name) {
            this.mArchive = archive;
            this.mName = name;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            if (u != this.mURL) {
                throw new IOException("Cannot open a foreign URL; this.url=" + this.mURL + "; foreign.url=" + u);
            }
            return new InternalJarURLConnection(u, this.mArchive, this.mName);
        }

        public void tieUrl(URL url) {
            this.mURL = url;
        }
    }
}

