/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.library;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.VersionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryInfo
implements Comparable<LibraryInfo> {
    private final String libraryName;
    private final VersionInfo specificationVersion;
    private final VersionInfo implementationVersion;
    private final List<Path> pathes = new LinkedList<Path>();

    public LibraryInfo(String libraryName, String specificationVersion, String implementationVersion) {
        this.libraryName = libraryName;
        this.specificationVersion = new VersionInfo(specificationVersion);
        this.implementationVersion = new VersionInfo(implementationVersion);
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public VersionInfo getSpecificationVersion() {
        return this.specificationVersion;
    }

    public VersionInfo getImplementationVersion() {
        return this.implementationVersion;
    }

    public void addClassesDir(String dir) {
        this.pathes.add(new Path(dir, PathType.CLASSES));
    }

    public void addJar(String s) {
        this.pathes.add(new Path(s, PathType.JAR));
    }

    public void addJarDir(String dir) {
        this.pathes.add(new Path(dir, PathType.JARDIR));
    }

    public List<ClassPathEntry> calculateClassPath(String baseDir) {
        LinkedList<ClassPathEntry> list = new LinkedList<ClassPathEntry>();
        for (Path path : this.pathes) {
            File file = new File(path.path);
            if (!file.isAbsolute()) {
                file = new File(baseDir, path.path);
            }
            switch (path.pathType) {
                case CLASSES: {
                    list.add(new ClassPathEntry(file.getAbsolutePath(), false));
                    break;
                }
                case JAR: {
                    list.add(new ClassPathEntry(file.getAbsolutePath(), true));
                    break;
                }
                case JARDIR: {
                    if (!file.isDirectory()) break;
                    for (File f : file.listFiles()) {
                        if (!f.getName().toLowerCase().endsWith(".jar")) continue;
                        list.add(new ClassPathEntry(f.getAbsolutePath(), true));
                    }
                    break;
                }
            }
        }
        return list;
    }

    @Override
    public int compareTo(LibraryInfo o) {
        return this.compareTo(o.specificationVersion, o.implementationVersion);
    }

    public int compareTo(VersionInfo specVersion, VersionInfo implVersion) {
        int result = this.specificationVersion.compareTo(specVersion);
        if (result != 0) {
            return result;
        }
        return this.implementationVersion.compareTo(implVersion);
    }

    private static class Path {
        String path;
        PathType pathType;

        public Path(String path, PathType pathType) {
            this.path = path;
            this.pathType = pathType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PathType {
        CLASSES,
        JAR,
        JARDIR;

    }
}

