/*
 * Decompiled with CFR 0.152.
 */
package jeus.service.library;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBException;
import jeus.service.descriptor.LibrariesDescriptorFile;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryInfo;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.service.library.VersionInfo;
import jeus.util.JeusBootstrapProperties;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Deploy;
import jeus.xml.binding.jeusDD.LibrariesType;
import jeus.xml.binding.jeusDD.LibraryFilesIncludeType;
import jeus.xml.binding.jeusDD.LibraryFilesModeType;
import jeus.xml.binding.jeusDD.LibraryFilesType;
import jeus.xml.binding.jeusDD.LibraryType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.deploy");
    private LibrariesDescriptorFile descriptorFile;
    private LibrariesType librariesType;
    private HashMap<String, List<LibraryInfo>> librariesMap = new HashMap();
    private static String fs = File.separator;
    private static final String SHARED_LIB_DIR = JeusBootstrapProperties.JEUS_HOME + fs + "lib" + fs + "shared";
    private static final String SHARED_LIB_CONFIG = SHARED_LIB_DIR + fs + "libraries.xml";
    private static final LibraryManager instance = new LibraryManager();

    private LibraryManager() {
        this.descriptorFile = new LibrariesDescriptorFile(SHARED_LIB_CONFIG);
    }

    public static LibraryManager getInstance() {
        return instance;
    }

    public final synchronized void refresh() {
        Throwable exception;
        block14: {
            if (!this.descriptorFile.existsDescriptorFile()) {
                this.librariesMap.clear();
                this.librariesType = null;
                return;
            }
            exception = null;
            try {
                LibrariesType newone = (LibrariesType)this.descriptorFile.getConfigDescriptor(this.librariesType);
                if (newone == this.librariesType) break block14;
                assert (newone instanceof LibrariesType);
                this.librariesType = newone;
                for (LibraryType library : this.librariesType.getLibrary()) {
                    String name = library.getLibraryName();
                    String specVersion = library.getSpecificationVersion();
                    String implVersion = library.getImplementationVersion();
                    if (name == null || name.equals("")) continue;
                    LibraryInfo libraryInfo = new LibraryInfo(name, specVersion, implVersion);
                    List files = library.getFiles();
                    for (LibraryFilesType file : files) {
                        String dir = file.getDir();
                        LibraryFilesModeType mode = file.getMode();
                        if (mode == null || LibraryFilesModeType.JAR == mode) {
                            if (!file.isSetInclude()) {
                                libraryInfo.addJarDir(dir);
                                continue;
                            }
                            for (LibraryFilesIncludeType include : file.getInclude()) {
                                String includeName = include.getName();
                                libraryInfo.addJar(dir + "/" + includeName);
                            }
                            continue;
                        }
                        if (LibraryFilesModeType.CLASSES == mode) {
                            libraryInfo.addClassesDir(dir);
                            continue;
                        }
                        assert (false);
                    }
                    List<LibraryInfo> libraryInfos = this.librariesMap.get(name);
                    if (libraryInfos == null) {
                        libraryInfos = new LinkedList<LibraryInfo>();
                        this.librariesMap.put(name, libraryInfos);
                    }
                    libraryInfos.add(libraryInfo);
                }
            }
            catch (IOException ex) {
                exception = ex;
            }
            catch (JAXBException ex) {
                exception = ex;
            }
        }
        if (exception != null && logger.isLoggable(JeusMessage_Deploy._11_LEVEL)) {
            logger.log(JeusMessage_Deploy._11_LEVEL, JeusMessage_Deploy._11, (Object)SHARED_LIB_CONFIG, exception);
        }
    }

    public synchronized List<ClassPathEntry> getClassPathEntries(LibraryRef ref) throws LibraryNotFoundException {
        List<LibraryInfo> libraryInfoList = this.librariesMap.get(ref.getLibraryName());
        if (libraryInfoList == null) {
            if (logger.isLoggable(JeusMessage_Deploy._12_LEVEL)) {
                logger.log(JeusMessage_Deploy._12_LEVEL, JeusMessage_Deploy._12, (Object)ref);
            }
            if (ref.isFailOnError()) {
                throw new LibraryNotFoundException("Could not resolve the library reference " + ref);
            }
            return null;
        }
        VersionInfo refSpecVersion = ref.getSpecificationVersion();
        VersionInfo refImplVersion = ref.getImplementationVersion();
        LibraryInfo found = null;
        for (LibraryInfo library : libraryInfoList) {
            VersionInfo libSpecVersion = library.getSpecificationVersion();
            int c1 = libSpecVersion.compareTo(refSpecVersion);
            if (ref.isSpecificationVersionExactMatch() ? c1 != 0 : c1 < 0) continue;
            VersionInfo libImplVersion = library.getImplementationVersion();
            int c2 = libImplVersion.compareTo(refImplVersion);
            if (!ref.isImplementationVersionExactMatch() ? c2 < 0 : c2 != 0) continue;
            if (found == null) {
                found = library;
                continue;
            }
            if (library.compareTo(found) <= 0) continue;
            found = library;
        }
        if (found == null) {
            if (logger.isLoggable(JeusMessage_Deploy._12_LEVEL)) {
                logger.log(JeusMessage_Deploy._12_LEVEL, JeusMessage_Deploy._12, (Object)ref);
            }
            if (ref.isFailOnError()) {
                throw new LibraryNotFoundException("Could not resolve the library reference " + ref);
            }
            return null;
        }
        return found.calculateClassPath(SHARED_LIB_DIR);
    }
}

