/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.base;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jeus.servlet.cache.base.EntryRefreshPolicy;
import jeus.servlet.cache.web.filter.ResponseContent;

public class CacheEntry
extends SoftReference
implements Serializable {
    private static final byte NOT_YET = -1;
    public static final int INDEFINITE_EXPIRY = -1;
    private EntryRefreshPolicy policy = null;
    private Set groups = null;
    private String key;
    private boolean wasFlushed = false;
    private long created = -1L;
    private long lastUpdate = -1L;

    public CacheEntry(String key, Object content, ReferenceQueue refQueue) {
        this(key, content, refQueue, null, null);
    }

    public CacheEntry(String key, Object content, ReferenceQueue refQueue, EntryRefreshPolicy policy) {
        this(key, content, refQueue, policy, null);
    }

    public CacheEntry(String key, Object content, ReferenceQueue refQueue, EntryRefreshPolicy policy, String[] groups) {
        super(content, refQueue);
        this.key = key;
        if (groups != null) {
            this.groups = new HashSet(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                this.groups.add(groups[i]);
            }
        }
        this.policy = policy;
        this.created = System.currentTimeMillis();
        if (content != null) {
            this.lastUpdate = System.currentTimeMillis();
            this.wasFlushed = false;
        }
    }

    public Object getContent() {
        return this.get();
    }

    public long getCreated() {
        return this.created;
    }

    public synchronized void setGroups(String[] groups) {
        if (groups != null) {
            this.groups = new HashSet(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                this.groups.add(groups[i]);
            }
        } else {
            this.groups = null;
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void setGroups(Collection groups) {
        this.groups = groups != null ? new HashSet(groups) : null;
        this.lastUpdate = System.currentTimeMillis();
    }

    public Set getGroups() {
        return this.groups;
    }

    public String getKey() {
        return this.key;
    }

    public void setLastUpdate(long update) {
        this.lastUpdate = update;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isNew() {
        return this.lastUpdate == -1L;
    }

    public int getSize() {
        int size = this.key.length() * 2 + 4;
        if (this.get().getClass() == String.class) {
            size += this.get().toString().length() * 2 + 4;
        } else if (this.get() instanceof ResponseContent) {
            size += ((ResponseContent)this.get()).getSize();
        } else {
            return -1;
        }
        return size + 17;
    }

    public void flush() {
        this.wasFlushed = true;
    }

    public boolean needsRefresh(int refreshPeriod) {
        boolean needsRefresh = this.lastUpdate == -1L ? true : (this.wasFlushed ? true : (refreshPeriod == 0 ? true : (this.policy != null ? this.policy.needsRefresh(this) : refreshPeriod >= 0 && System.currentTimeMillis() >= this.lastUpdate + (long)refreshPeriod * 1000L)));
        return needsRefresh;
    }
}

