/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.web;

import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import jeus.servlet.cache.base.AbstractCacheAdministrator;
import jeus.servlet.cache.base.Cache;
import jeus.servlet.cache.base.CacheEntry;
import jeus.servlet.cache.base.WebCacheConfig;
import jeus.servlet.cache.base.events.ScopeEvent;
import jeus.servlet.cache.base.events.ScopeEventListener;
import jeus.servlet.cache.base.events.ScopeEventType;
import jeus.servlet.cache.util.CacheUtil;
import jeus.servlet.cache.web.ServletCache;
import jeus.servlet.engine.Context;
import jeus.util.message.JeusMessage_WebContainer11;

public class ServletCacheAdministrator
extends AbstractCacheAdministrator
implements Serializable {
    private static final String CACHE_USE_HOST_DOMAIN_KEY = "cache.use.host.domain.in.key";
    private static final String CACHE_KEY_KEY = "cache.key";
    public static final String DEFAULT_CACHE_KEY = "_jeuscache_default_key_";
    public static final String DEFAULT_CACHE_CAPACITY_KEY = "_default_cache_capacity_";
    public static final String DEFAULT_CACHE_DF_KEY = "_default_cache_df_";
    public static final String CACHE_CAPACITY_KEY_SUFFIX = "_cache_capacity_";
    public static final String CACHE_DF_KEY_SUFFIX = "_cache_df_";
    public static final String CACHE_POSTFIX = "_jeuscache";
    public static final String SESSION_SCOPE_NAME = "session";
    public static final String APPLICATION_SCOPE_NAME = "application";
    private static final String CACHE_ADMINISTRATOR_KEY = "__jeuscache_admin";
    public static final String HASH_KEY_SCOPE = "scope";
    public static final String HASH_KEY_SESSION_ID = "sessionId";
    public static final String HASH_KEY_CONTEXT_TMPDIR = "context.tempdir";
    private static final String FILE_SEPARATOR = "/";
    private static final char FILE_SEPARATOR_CHAR = "/".charAt(0);
    private static final short AVERAGE_KEY_LENGTH = 30;
    private static final String m_strBase64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private Map flushTimes;
    private transient ServletContext context;
    private String cacheKey = "_jeuscache_default_key_";
    private boolean useHostDomainInKey = true;
    private HashMap namedCacheMap = new HashMap();

    private ServletCacheAdministrator(ServletContext context) {
        this.flushTimes = new HashMap();
        this.context = context;
    }

    public static synchronized ServletCacheAdministrator getInstance(ServletContext context) {
        ServletCacheAdministrator admin = (ServletCacheAdministrator)context.getAttribute(CACHE_ADMINISTRATOR_KEY);
        if (admin == null) {
            admin = new ServletCacheAdministrator(context);
            context.setAttribute(CACHE_ADMINISTRATOR_KEY, (Object)admin);
            if (logger.isLoggable(JeusMessage_WebContainer11._11000_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11000_LEVEL, JeusMessage_WebContainer11._11000, (Object)((Context)context).getContextName());
            }
        }
        if (admin.context == null) {
            admin.context = context;
        }
        return admin;
    }

    public static void destroyInstance(ServletContext context) {
        ServletCacheAdministrator admin = (ServletCacheAdministrator)context.getAttribute(CACHE_ADMINISTRATOR_KEY);
        if (admin != null) {
            Cache cache = (Cache)context.getAttribute(admin.getCacheKey());
            if (cache != null) {
                admin.finalizeListeners(cache);
                context.removeAttribute(admin.getCacheKey());
                context.removeAttribute(CACHE_ADMINISTRATOR_KEY);
                cache = null;
                if (logger.isLoggable(JeusMessage_WebContainer11._11002_LEVEL)) {
                    logger.log(JeusMessage_WebContainer11._11002_LEVEL, JeusMessage_WebContainer11._11002, (Object)((Context)context).getContextName());
                }
            }
            admin = null;
        }
    }

    public Cache getCache(HttpServletRequest request, int scope, int size, boolean async, float df) {
        if (scope == 4) {
            return this.getAppScopeCache(this.context, size, async, df);
        }
        if (scope == 3) {
            return this.getSessionScopeCache(this.context, request.getSession(true), size, async, df);
        }
        throw new RuntimeException("The supplied scope value of " + scope + " is invalid. Acceptable values are PageContext.APPLICATION_SCOPE and PageContext.SESSION_SCOPE");
    }

    public Cache getAppScopeCache(ServletContext context, int size, boolean async, float df) {
        return this.getAppScopeCache(context, null, size, async, df);
    }

    public Cache getAppScopeCache(ServletContext context, String name, int size, boolean async, float df) {
        Cache cache;
        String cacheKey = this.getCacheKey(name);
        Object obj = context.getAttribute(cacheKey);
        if (obj == null || !(obj instanceof Cache)) {
            if (logger.isLoggable(JeusMessage_WebContainer11._11003_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11003_LEVEL, JeusMessage_WebContainer11._11003, (Object)((Context)context).getContextName());
            }
            WebCacheConfig cacheConfig = new WebCacheConfig("javax.servlet.jsp.jspApplication", null, size, async, df);
            cache = this.createCache(4, null, cacheConfig);
            context.setAttribute(cacheKey, (Object)cache);
        } else {
            Object dfAtt;
            Object sizeAtt;
            if (DEFAULT_CACHE_KEY.equals(cacheKey)) {
                sizeAtt = context.getAttribute(DEFAULT_CACHE_CAPACITY_KEY);
                dfAtt = context.getAttribute(DEFAULT_CACHE_DF_KEY);
            } else {
                sizeAtt = context.getAttribute("_" + name + CACHE_CAPACITY_KEY_SUFFIX);
                dfAtt = context.getAttribute("_" + name + CACHE_DF_KEY_SUFFIX);
            }
            this.configCacheMapDynamically((Cache)obj, sizeAtt, dfAtt);
            cache = (Cache)obj;
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configCacheMapDynamically(Cache cache, Object sizeObject, Object dfObject) {
        Cache cache2;
        if (sizeObject != null) {
            int capacityAtt = Integer.parseInt((String)sizeObject);
            cache2 = cache;
            synchronized (cache2) {
                int currentCapacity = cache.getCapacity();
                if (capacityAtt != currentCapacity) {
                    cache.setCapacity(capacityAtt);
                }
            }
        }
        if (sizeObject != null) {
            float dfAtt = Float.parseFloat((String)dfObject);
            cache2 = cache;
            synchronized (cache2) {
                float currentDf = cache.getDecreaseFactor();
                if (dfAtt != currentDf) {
                    cache.setDecreaseFactor(dfAtt);
                }
            }
        }
    }

    public Cache getSessionScopeCache(ServletContext context, HttpSession session, int size, boolean async, float df) {
        return this.getSessionScopeCache(context, null, session, size, async, df);
    }

    public Cache getSessionScopeCache(ServletContext context, String name, HttpSession session, int size, boolean async, float df) {
        Cache cache;
        String cacheKey = this.getCacheKey(name);
        Object obj = session.getAttribute(cacheKey);
        if (obj == null || !(obj instanceof Cache)) {
            if (logger.isLoggable(JeusMessage_WebContainer11._11004_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11004_LEVEL, JeusMessage_WebContainer11._11004, new Object[]{((Context)context).getContextName(), session.getId()});
            }
            WebCacheConfig cacheConfig = new WebCacheConfig("javax.servlet.jsp.jspSession", session.getId(), size, async, df);
            cache = this.createCache(3, session.getId(), cacheConfig);
            session.setAttribute(cacheKey, (Object)cache);
        } else {
            Object dfAtt;
            Object sizeAtt;
            if (DEFAULT_CACHE_KEY.equals(cacheKey)) {
                sizeAtt = session.getAttribute(DEFAULT_CACHE_CAPACITY_KEY);
                dfAtt = session.getAttribute(DEFAULT_CACHE_DF_KEY);
            } else {
                sizeAtt = session.getAttribute("_" + name + CACHE_CAPACITY_KEY_SUFFIX);
                dfAtt = session.getAttribute("_" + name + CACHE_DF_KEY_SUFFIX);
            }
            this.configCacheMapDynamically((Cache)obj, sizeAtt, dfAtt);
            cache = (Cache)obj;
        }
        return cache;
    }

    public String getCacheKey() {
        return this.getCacheKey(null);
    }

    public String getCacheKey(String name) {
        if (name != null) {
            return name;
        }
        return this.cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushTime(Date date, int scope) {
        if (logger.isLoggable(JeusMessage_WebContainer11._11005_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11005_LEVEL, JeusMessage_WebContainer11._11005, new Object[]{CacheUtil.getScopeAsString(scope), date});
        }
        Map map = this.flushTimes;
        synchronized (map) {
            if (date == null) {
                if (logger.isLoggable(JeusMessage_WebContainer11._11006_LEVEL)) {
                    logger.log(JeusMessage_WebContainer11._11006_LEVEL, JeusMessage_WebContainer11._11006, new Object[]{CacheUtil.getScopeAsString(scope), date});
                }
                throw new IllegalArgumentException("setFlushTime called with a null date.");
            }
            this.dispatchScopeEvent(ScopeEventType.SCOPE_FLUSHED, scope, date, null);
            this.flushTimes.put(new Integer(scope), date);
        }
    }

    public void setFlushTime(int scope) {
        this.setFlushTime(new Date(), scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFlushTime(int scope) {
        Map map = this.flushTimes;
        synchronized (map) {
            return (Date)this.flushTimes.get(new Integer(scope));
        }
    }

    public boolean isScopeFlushed(CacheEntry cacheEntry, int scope) {
        Date flushDateTime = this.getFlushTime(scope);
        if (flushDateTime != null) {
            long lastUpdate = cacheEntry.getLastUpdate();
            return flushDateTime.getTime() >= lastUpdate;
        }
        return false;
    }

    public void addScopeEventListener(ScopeEventListener listener) {
        this.listenerList.add(ScopeEventListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll(Date date) {
        Map map = this.flushTimes;
        synchronized (map) {
            this.setFlushTime(date, 4);
            this.setFlushTime(date, 3);
            this.setFlushTime(date, 2);
            this.setFlushTime(date, 1);
        }
        this.dispatchScopeEvent(ScopeEventType.ALL_SCOPES_FLUSHED, -1, date, null);
    }

    public void flushAll() {
        this.flushAll(new Date());
    }

    public String generateEntryKey(String key, HttpServletRequest request, int scope) {
        return this.generateEntryKey(key, request, scope, null, null);
    }

    public String generateEntryKey(String key, HttpServletRequest request, int scope, String language) {
        return this.generateEntryKey(key, request, scope, language, null);
    }

    public String generateEntryKey(String key, HttpServletRequest request, int scope, String language, String suffix) {
        StringBuffer cBuffer = new StringBuffer(30);
        if (language != null) {
            cBuffer.append(FILE_SEPARATOR).append(language);
        }
        if (this.useHostDomainInKey) {
            cBuffer.append(FILE_SEPARATOR).append(request.getServerName());
        }
        if (key != null) {
            cBuffer.append(FILE_SEPARATOR).append(key);
        } else {
            String generatedKey = request.getRequestURI();
            if (generatedKey.charAt(0) != FILE_SEPARATOR_CHAR) {
                cBuffer.append(FILE_SEPARATOR_CHAR);
            }
            cBuffer.append(generatedKey);
            cBuffer.append("_").append(request.getMethod()).append("_");
            generatedKey = this.getSortedQueryString(request);
            if (generatedKey != null) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    byte[] b = digest.digest(generatedKey.getBytes());
                    cBuffer.append("_");
                    cBuffer.append(ServletCacheAdministrator.toBase64(b).replace('/', '_'));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (suffix != null && suffix.length() > 0) {
            cBuffer.append(suffix);
        }
        return cBuffer.toString();
    }

    public String generateEntryName(PageContext pageContext, HttpServletRequest request, String suffix) throws JspException {
        return this.generateEntryName(pageContext, request, null, suffix);
    }

    public String generateEntryName(PageContext pageContext, HttpServletRequest request, String language, String suffix) throws JspException {
        String generatedKey;
        StringBuffer cBuffer = new StringBuffer(30);
        if (language != null) {
            cBuffer.append(FILE_SEPARATOR).append(language);
        }
        if (this.useHostDomainInKey) {
            cBuffer.append(FILE_SEPARATOR).append(request.getServerName());
        }
        if ((generatedKey = request.getRequestURI()).charAt(0) != FILE_SEPARATOR_CHAR) {
            cBuffer.append(FILE_SEPARATOR_CHAR);
        }
        cBuffer.append(generatedKey);
        cBuffer.append("_").append(request.getMethod()).append("_");
        generatedKey = this.getSortedQueryString(request);
        if (generatedKey != null) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] b = digest.digest(generatedKey.getBytes());
                cBuffer.append("_");
                cBuffer.append(ServletCacheAdministrator.toBase64(b).replace('/', '_'));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (suffix != null && suffix.length() > 0) {
            cBuffer.append(suffix);
        }
        return cBuffer.toString();
    }

    protected String getSortedQueryString(HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        if (paramMap.isEmpty()) {
            return null;
        }
        Set paramSet = new TreeMap(paramMap).entrySet();
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : paramSet) {
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                String key = (String)entry.getKey();
                if (key.length() == 10 && "jsessionid".equals(key)) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append('&');
                }
                buf.append(key).append('=').append(values[i]);
            }
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public void removeScopeEventListener(ScopeEventListener listener) {
        this.listenerList.remove(ScopeEventListener.class, listener);
    }

    protected void finalizeListeners(Cache cache) {
        super.finalizeListeners(cache);
    }

    private static String toBase64(byte[] aValue) {
        int iByteLen = aValue.length;
        StringBuffer tt = new StringBuffer();
        for (int i = 0; i < iByteLen; i += 3) {
            boolean bByte2 = i + 1 < iByteLen;
            boolean bByte3 = i + 2 < iByteLen;
            int byte1 = aValue[i] & 0xFF;
            int byte2 = bByte2 ? aValue[i + 1] & 0xFF : 0;
            int byte3 = bByte3 ? aValue[i + 2] & 0xFF : 0;
            tt.append(m_strBase64Chars.charAt(byte1 / 4));
            tt.append(m_strBase64Chars.charAt(byte2 / 16 + (byte1 & 3) * 16));
            tt.append(bByte2 ? m_strBase64Chars.charAt(byte3 / 64 + (byte2 & 0xF) * 4) : (char)'=');
            tt.append(bByte3 ? m_strBase64Chars.charAt(byte3 & 0x3F) : (char)'=');
        }
        return tt.toString();
    }

    private ServletCache createCache(int scope, String sessionId, WebCacheConfig cacheConfig) {
        cacheConfig.setScope(scope);
        cacheConfig.setSessionID(sessionId);
        ServletCache newCache = new ServletCache(this, cacheConfig);
        return newCache;
    }

    private void dispatchScopeEvent(ScopeEventType eventType, int scope, Date date, String origin) {
        ScopeEvent event = new ScopeEvent(eventType, scope, date, origin);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ScopeEventListener.class) continue;
            ((ScopeEventListener)listeners[i + 1]).scopeFlushed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletCache getNamedCache(String name) {
        HashMap hashMap = this.namedCacheMap;
        synchronized (hashMap) {
            return (ServletCache)this.namedCacheMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNamedCache(String name, ServletCache cache) {
        HashMap hashMap = this.namedCacheMap;
        synchronized (hashMap) {
            this.namedCacheMap.put(name, cache);
        }
    }
}

