/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.servlet.cache.base.Cache;
import jeus.servlet.cache.base.EntryRefreshPolicy;
import jeus.servlet.cache.base.NeedsRefreshException;
import jeus.servlet.cache.util.CacheUtil;
import jeus.servlet.cache.web.ServletCacheAdministrator;
import jeus.servlet.cache.web.filter.CacheHttpServletResponseWrapper;
import jeus.servlet.cache.web.filter.ExpiresRefreshPolicy;
import jeus.servlet.cache.web.filter.ICacheGroupsProvider;
import jeus.servlet.cache.web.filter.ICacheKeyProvider;
import jeus.servlet.cache.web.filter.ResponseContent;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer11;

public class CacheFilter
implements Filter,
ICacheKeyProvider,
ICacheGroupsProvider {
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_CACHE_CONTROL = "Cache-control";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final int FRAGMENT_AUTODETECT = -1;
    public static final int FRAGMENT_NO = 0;
    public static final int FRAGMENT_YES = 1;
    public static final int NOCACHE_OFF = 0;
    public static final int NOCACHE_SESSION_ID_IN_URL = 1;
    public static final long LAST_MODIFIED_OFF = 0L;
    public static final long LAST_MODIFIED_ON = 1L;
    public static final long LAST_MODIFIED_INITIAL = -1L;
    public static final long EXPIRES_OFF = 0L;
    public static final long EXPIRES_ON = 1L;
    public static final long EXPIRES_TIME = -1L;
    private static final String REQUEST_FILTERED = "__oscache_filtered";
    private EntryRefreshPolicy expiresRefreshPolicy;
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.cache");
    private FilterConfig config;
    private ServletCacheAdministrator admin = null;
    private int cacheScope = 4;
    private int fragment = -1;
    private int timeout = 3600;
    private String cron = null;
    private int nocache = 0;
    private long lastModified = -1L;
    private long expires = 1L;
    private ICacheKeyProvider cacheKeyProvider = this;
    private ICacheGroupsProvider cacheGroupsProvider = this;
    private int size = Integer.MAX_VALUE;
    private boolean async;
    private float df = 0.25f;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.isFilteredBefore(request) || !this.isCacheable(request)) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(REQUEST_FILTERED, (Object)Boolean.TRUE);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean fragmentRequest = this.isFragment(httpRequest);
        ServletContext context = this.config.getServletContext();
        Cache cache = this.cacheScope == 3 ? this.admin.getSessionScopeCache(context, httpRequest.getSession(true), this.size, this.async, this.df) : this.admin.getAppScopeCache(context, this.size, this.async, this.df);
        String key = this.cacheKeyProvider.createCacheKey(httpRequest, this.admin, cache);
        try {
            ResponseContent respContent = (ResponseContent)cache.getFromCache(key, this.timeout, this.cron);
            if (logger.isLoggable(JeusMessage_WebContainer11._11033_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11033_LEVEL, JeusMessage_WebContainer11._11033, (Object)key);
            }
            boolean acceptsGZip = false;
            if (!fragmentRequest && this.lastModified != 0L) {
                long clientLastModified = httpRequest.getDateHeader(HEADER_IF_MODIFIED_SINCE);
                if (clientLastModified != -1L && clientLastModified >= respContent.getLastModified()) {
                    ((HttpServletResponse)response).setStatus(304);
                    return;
                }
                acceptsGZip = respContent.isContentGZiped() && this.acceptsGZipEncoding(httpRequest);
            }
            respContent.writeTo(response, fragmentRequest, acceptsGZip);
        }
        catch (NeedsRefreshException nre) {
            boolean updateSucceeded = false;
            try {
                if (logger.isLoggable(JeusMessage_WebContainer11._11034_LEVEL)) {
                    logger.log(JeusMessage_WebContainer11._11034_LEVEL, JeusMessage_WebContainer11._11034, (Object)key);
                }
                CacheHttpServletResponseWrapper cacheResponse = new CacheHttpServletResponseWrapper((HttpServletResponse)response, fragmentRequest, (long)this.timeout * 1000L, this.lastModified, this.expires);
                chain.doFilter(request, (ServletResponse)cacheResponse);
                cacheResponse.flushBuffer();
                if (this.isCacheable(cacheResponse)) {
                    String[] groups = this.cacheGroupsProvider.createCacheGroups(httpRequest, this.admin, cache);
                    cache.putInCache(key, cacheResponse.getContent(), groups, this.expiresRefreshPolicy, null);
                    updateSucceeded = true;
                }
            }
            finally {
                if (!updateSucceeded) {
                    cache.cancelUpdate(key);
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        block36: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                this.config = filterConfig;
                                this.admin = ServletCacheAdministrator.getInstance(this.config.getServletContext());
                                try {
                                    this.timeout = CacheUtil.parseTimeout(this.config.getInitParameter("timeout"));
                                }
                                catch (Exception e) {
                                    if (!logger.isLoggable(JeusMessage_WebContainer11._11035_LEVEL)) break block31;
                                    logger.log(JeusMessage_WebContainer11._11035_LEVEL, JeusMessage_WebContainer11._11035);
                                }
                            }
                            this.expiresRefreshPolicy = new ExpiresRefreshPolicy(this.timeout);
                            try {
                                String scopeString = this.config.getInitParameter("scope");
                                if (scopeString.equals("session")) {
                                    this.cacheScope = 3;
                                } else if (scopeString.equals("application")) {
                                    this.cacheScope = 4;
                                } else if (scopeString.equals("request")) {
                                    this.cacheScope = 2;
                                } else if (scopeString.equals("page")) {
                                    this.cacheScope = 1;
                                }
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(JeusMessage_WebContainer11._11036_LEVEL)) break block32;
                                logger.log(JeusMessage_WebContainer11._11036_LEVEL, JeusMessage_WebContainer11._11036);
                            }
                        }
                        this.cron = this.config.getInitParameter("cron");
                        try {
                            String lastModifiedString = this.config.getInitParameter("lastModified");
                            if (lastModifiedString.equals("off")) {
                                this.lastModified = 0L;
                            } else if (lastModifiedString.equals("on")) {
                                this.lastModified = 1L;
                            } else if (lastModifiedString.equalsIgnoreCase("initial")) {
                                this.lastModified = -1L;
                            }
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(JeusMessage_WebContainer11._11038_LEVEL)) break block33;
                            logger.log(JeusMessage_WebContainer11._11038_LEVEL, JeusMessage_WebContainer11._11038);
                        }
                    }
                    try {
                        String expiresString = this.config.getInitParameter("expires");
                        if (expiresString.equals("off")) {
                            this.expires = 0L;
                        } else if (expiresString.equals("on")) {
                            this.expires = 1L;
                        } else if (expiresString.equalsIgnoreCase("timeout")) {
                            this.expires = -1L;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(JeusMessage_WebContainer11._11039_LEVEL)) break block34;
                        logger.log(JeusMessage_WebContainer11._11039_LEVEL, JeusMessage_WebContainer11._11039);
                    }
                }
                try {
                    int sizeParam = Integer.parseInt(this.config.getInitParameter("size"));
                    if (sizeParam > 0) {
                        this.size = sizeParam;
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer11._11052_LEVEL)) break block35;
                    logger.log(JeusMessage_WebContainer11._11052_LEVEL, JeusMessage_WebContainer11._11052);
                }
            }
            this.async = "true".equals(this.config.getInitParameter("async"));
            try {
                float dfParam = Float.parseFloat(this.config.getInitParameter("df"));
                if (dfParam > 0.0f) {
                    this.df = dfParam;
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_WebContainer11._11053_LEVEL)) break block36;
                logger.log(JeusMessage_WebContainer11._11053_LEVEL, JeusMessage_WebContainer11._11053);
            }
        }
    }

    public String createCacheKey(HttpServletRequest httpRequest, ServletCacheAdministrator scAdmin, Cache cache) {
        return scAdmin.generateEntryKey(null, httpRequest, this.cacheScope);
    }

    public String[] createCacheGroups(HttpServletRequest httpRequest, ServletCacheAdministrator scAdmin, Cache cache) {
        return null;
    }

    protected boolean isFragment(HttpServletRequest request) {
        if (this.fragment == -1) {
            return request.getAttribute("javax.servlet.include.request_uri") != null;
        }
        return this.fragment != 0;
    }

    protected boolean isFilteredBefore(ServletRequest request) {
        return request.getAttribute(REQUEST_FILTERED) != null;
    }

    protected boolean isCacheable(ServletRequest request) {
        boolean cachable = request instanceof HttpServletRequest;
        if (cachable) {
            HttpServletRequest requestHttp = (HttpServletRequest)request;
            if (this.nocache == 1) {
                boolean bl = cachable = !requestHttp.isRequestedSessionIdFromURL();
            }
        }
        if (cachable) {
            if (logger.isLoggable(JeusMessage_WebContainer11._11040_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11040_LEVEL, JeusMessage_WebContainer11._11040);
            }
        } else if (logger.isLoggable(JeusMessage_WebContainer11._11041_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11041_LEVEL, JeusMessage_WebContainer11._11041);
        }
        return cachable;
    }

    protected boolean isCacheable(CacheHttpServletResponseWrapper cacheResponse) {
        boolean cachable;
        boolean bl = cachable = cacheResponse.getStatus() == 200;
        if (cachable) {
            if (logger.isLoggable(JeusMessage_WebContainer11._11040_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11040_LEVEL, JeusMessage_WebContainer11._11040);
            }
        } else if (logger.isLoggable(JeusMessage_WebContainer11._11041_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11041_LEVEL, JeusMessage_WebContainer11._11041);
        }
        return cachable;
    }

    protected boolean acceptsGZipEncoding(HttpServletRequest request) {
        String acceptEncoding = request.getHeader(HEADER_ACCEPT_ENCODING);
        return acceptEncoding != null && acceptEncoding.indexOf("gzip") != -1;
    }
}

