/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.common;

import java.io.Serializable;
import jeus.servlet.common.ConnectorInfo;
import jeus.servlet.common.SessionInfo;

public class ContextGroupInfo
implements Serializable {
    protected String groupName;
    protected int currentCtx;
    protected String[] contexts;
    protected int[] currentRequestNums;
    protected long[] avgProcessingTimes;
    protected ConnectorInfo[] connInfo;
    protected SessionInfo sessionInfo;

    ContextGroupInfo(String name, int ctxNums) {
        this.groupName = name;
        this.currentCtx = 0;
        this.contexts = new String[ctxNums];
        this.currentRequestNums = new int[ctxNums];
        this.avgProcessingTimes = new long[ctxNums];
    }

    public void addContextInfo(String name, int num, long time) {
        this.contexts[this.currentCtx] = name;
        this.currentRequestNums[this.currentCtx] = num;
        this.avgProcessingTimes[this.currentCtx] = time;
        ++this.currentCtx;
    }

    public void addConnectorInfo(ConnectorInfo[] info) {
        this.connInfo = info;
    }

    public void setSessionInfo(SessionInfo info) {
        this.sessionInfo = info;
    }

    public String getContextGroupName() {
        return this.groupName;
    }

    public String[] getContextNames() {
        return this.contexts;
    }

    public int[] getCurrentRequestNums() {
        return this.currentRequestNums;
    }

    public long[] getAvgProcessingTimes() {
        return this.avgProcessingTimes;
    }

    public ConnectorInfo[] getConnectorInfo() {
        return this.connInfo;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }
}

