/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.common;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.security.base.Policy;
import jeus.server.EngineControllerImpl;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.common.WebContainerAdminConstants;
import jeus.servlet.common.WebContainerControl;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.common.WebStaticInfo;
import jeus.servlet.connection.Connector;
import jeus.servlet.connection.WebtobConnector;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ThreadStateNotifyDescriptor;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.WebtobThreadPoolManager;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRMIClientSocketFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer0;

public class WebContainerControlImpl
extends EngineControllerImpl
implements WebContainerAdminConstants,
WebContainerControl {
    private String containerName = null;
    private WebContainerManager manager;

    public WebContainerControlImpl(WebContainerManager manager) throws RemoteException {
        this.manager = manager;
        this.containerName = manager.ENGINE_NAME;
        try {
            int operationTO = 60000;
            String tmout = System.getProperty("jeus.servlet.webadmin.checktmout");
            if (tmout != null) {
                try {
                    operationTO = Integer.parseInt(tmout);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            UnicastRemoteObject.exportObject(this, 0, new JeusRMIClientSocketFactory(operationTO), RMISocketFactory.getDefaultSocketFactory());
        }
        catch (Throwable ex) {
            throw new RemoteException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1000), ex);
        }
    }

    public Hashtable getThreadState(int flags, Vector ports) throws RemoteException {
        int mode = 0;
        mode = (flags & 2) != 0 ? ThreadStateInfo.GET_PROCESSING_INFO : ((flags & 4) != 0 ? ThreadStateInfo.GET_ALL_INFO : ((flags & 8) != 0 ? ThreadStateInfo.GET_ALL2_INFO : ThreadStateInfo.GET_RUNNING_STATE));
        Hashtable<String, Vector> threadInfos = new Hashtable<String, Vector>();
        if (ports.isEmpty()) {
            Enumeration ctxGroups = this.manager.getContextGroups();
            while (ctxGroups.hasMoreElements()) {
                ContextGroup ctxGroup = (ContextGroup)ctxGroups.nextElement();
                HashMap poolManagers = ctxGroup.getThreadPoolManagers();
                for (ThreadPoolManager[] poolManager : poolManagers.values()) {
                    if (poolManager == null) continue;
                    for (int i = 0; i < poolManager.length; ++i) {
                        Vector infos = poolManager[i].getThreadState(mode);
                        threadInfos.put(poolManager[i].getThreadPoolId(), infos);
                    }
                }
            }
        } else {
            Enumeration ctxGroups = this.manager.getContextGroups();
            while (ctxGroups.hasMoreElements()) {
                ContextGroup ctxGroup = (ContextGroup)ctxGroups.nextElement();
                for (int i = ports.size() - 1; i >= 0; --i) {
                    String port = (String)ports.elementAt(i);
                    ThreadPoolManager[] poolManager = ctxGroup.getThreadPoolManager(port);
                    if (poolManager == null) continue;
                    for (int j = 0; j < poolManager.length; ++j) {
                        Vector infos = poolManager[j].getThreadState(mode);
                        threadInfos.put(poolManager[j].getThreadPoolId(), infos);
                    }
                    ports.removeElementAt(i);
                }
            }
        }
        return threadInfos;
    }

    public WebContainerDescriptor getConfigInfo(int flags, Hashtable params) throws RemoteException {
        return this.manager.getWebContainerDescriptor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContainerConfig(int flags, Hashtable params) throws RemoteException {
        ContextGroup ctxGroup;
        String servletReloadMonitoringIntval;
        String sessMonitoringIntval;
        String portNum = (String)params.remove("-cn");
        if (portNum != null) {
            Connector connector;
            String webtobFailback;
            Enumeration ctxGroups = this.manager.getContextGroups();
            while (ctxGroups.hasMoreElements()) {
                ContextGroup ctxGroup2 = (ContextGroup)ctxGroups.nextElement();
                ThreadPoolManager[] poolManager = ctxGroup2.getThreadPoolManager(portNum);
                if (poolManager == null) continue;
                for (int i = 0; i < poolManager.length; ++i) {
                    String maxQueue;
                    String maxWaitQueue;
                    String maxIdleTime;
                    String changeRate;
                    String maxThread;
                    String minThread = (String)params.remove("-tmin");
                    if (minThread != null) {
                        poolManager[i].getThreadPoolDescriptor().setMinThreadNum(minThread);
                    }
                    if ((maxThread = (String)params.remove("-tmax")) != null) {
                        poolManager[i].getThreadPoolDescriptor().setMaxThreadNum(maxThread);
                    }
                    if ((changeRate = (String)params.remove("-trate")) != null) {
                        poolManager[i].getThreadPoolDescriptor().setChangingRate(changeRate);
                    }
                    if ((maxIdleTime = (String)params.remove("-tidle")) != null) {
                        poolManager[i].getThreadPoolDescriptor().setMaxIdleTime(maxIdleTime);
                    }
                    if ((maxWaitQueue = (String)params.remove("-tmwq")) != null) {
                        poolManager[i].getThreadPoolDescriptor().setMaxWaitQueue(maxWaitQueue);
                    }
                    if ((maxQueue = (String)params.remove("-tmq")) != null) {
                        poolManager[i].getThreadPoolDescriptor().setMaxQueue(maxQueue);
                    }
                    if (params.isEmpty()) {
                        return;
                    }
                    ThreadStateNotifyDescriptor tsnDesc = poolManager[i].getThreadStateNotifyDescriptor();
                    String tsnMaxThreadActiveTime = (String)params.remove("-tmtat");
                    if (tsnDesc != null && tsnMaxThreadActiveTime != null) {
                        tsnDesc.setMaxThreadActiveTime(tsnMaxThreadActiveTime);
                    }
                    String notifyThreshold = (String)params.remove("-tnt");
                    if (tsnDesc != null && notifyThreshold != null) {
                        tsnDesc.setNotifyThreshold(notifyThreshold);
                    }
                    String restartThreshold = (String)params.remove("-trt");
                    if (tsnDesc == null || restartThreshold == null) continue;
                    tsnDesc.setRestartThreshold(restartThreshold);
                }
            }
            if ((webtobFailback = (String)params.remove("-to")) != null && (connector = this.manager.getConnector(portNum)) != null && connector instanceof WebtobConnector) {
                WebtobConnector wcon = (WebtobConnector)connector;
                int serverIndex = -1;
                try {
                    serverIndex = Integer.parseInt(webtobFailback);
                }
                catch (Exception e) {
                    serverIndex = -1;
                }
                if (serverIndex >= 0) {
                    wcon.failback(serverIndex);
                }
            }
        }
        if (params.isEmpty()) {
            return;
        }
        if (params.isEmpty()) {
            return;
        }
        String threadPoolMonitoringIntval = (String)params.remove("-tmi");
        if (threadPoolMonitoringIntval != null) {
            this.manager.setMonitoringPeriod(threadPoolMonitoringIntval, 0);
        }
        if ((sessMonitoringIntval = (String)params.remove("-smi")) != null) {
            this.manager.setMonitoringPeriod(sessMonitoringIntval, 2);
        }
        if ((servletReloadMonitoringIntval = (String)params.remove("-rmi")) != null) {
            this.manager.setMonitoringPeriod(servletReloadMonitoringIntval, 3);
        }
        if (params.isEmpty()) {
            return;
        }
        String ctxGroupName = (String)params.remove("-cg");
        if (ctxGroupName == null) {
            ctxGroupName = (String)this.manager.getContextGroupNames().elementAt(0);
        }
        if ((ctxGroup = this.manager.getContextGroup(ctxGroupName)) == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1002, (Object)ctxGroupName));
        }
        String sessionTimeoutMinute = (String)params.remove("-stm");
        if (sessionTimeoutMinute != null) {
            ctxGroup.setSessionTimeout(sessionTimeoutMinute);
        }
        String errorLogLevel = (String)params.remove("-ell");
        JeusLogger l = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet");
        if (errorLogLevel != null) {
            if ((errorLogLevel = errorLogLevel.toLowerCase()).startsWith("all")) {
                l.setLevel(Level.ALL);
            } else if (errorLogLevel.startsWith("severe")) {
                l.setLevel(Level.SEVERE);
            } else if (errorLogLevel.startsWith("warning")) {
                l.setLevel(Level.WARNING);
            } else if (errorLogLevel.startsWith("info")) {
                l.setLevel(Level.INFO);
            } else if (errorLogLevel.startsWith("config")) {
                l.setLevel(Level.CONFIG);
            } else if (errorLogLevel.equals("fine")) {
                l.setLevel(Level.FINE);
            } else if (errorLogLevel.equals("finer")) {
                l.setLevel(Level.FINER);
            } else if (errorLogLevel.equals("finest")) {
                l.setLevel(Level.FINEST);
            }
        }
        String ctxName = (String)params.remove("-c");
        String autoReload = (String)params.remove("-ar");
        if (autoReload == null) return;
        if (ctxName != null) {
            Context context = ctxGroup.getContextByName(ctxName);
            if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1003, (Object)ctxName));
            context.getContextDescriptor().setAutoReload(autoReload);
            return;
        } else {
            Enumeration ctxs = ctxGroup.getContexts();
            while (ctxs.hasMoreElements()) {
                Context context = (Context)ctxs.nextElement();
                context.getContextDescriptor().setAutoReload(autoReload);
            }
        }
    }

    public WebStaticInfo getStaticInfo() throws RemoteException {
        WebStaticInfo webInfo = new WebStaticInfo(this.containerName);
        Enumeration ctxGroups = this.manager.getContextGroups();
        while (ctxGroups.hasMoreElements()) {
            ContextGroup ctxGroup = (ContextGroup)ctxGroups.nextElement();
            String grpName = ctxGroup.getGroupName();
            Hashtable<String, ServletInfo[]> groupInfo = new Hashtable<String, ServletInfo[]>();
            Enumeration contexts = ctxGroup.getContexts();
            while (contexts.hasMoreElements()) {
                Context context = (Context)contexts.nextElement();
                String ctxName = context.getContextName();
                ServletInfo[] servInfo = context.getAllServletInfo();
                if (servInfo == null) continue;
                groupInfo.put(ctxName, servInfo);
            }
            webInfo.addContextGroupInfo(grpName, groupInfo);
        }
        return webInfo;
    }

    public Vector getContextGroupNames() throws RemoteException {
        return this.manager.getContextGroupNames();
    }

    public Vector getConnectorNames() throws RemoteException {
        return this.manager.getConnectorNames();
    }

    public boolean execCommand(int command, String[] args) throws RemoteException {
        boolean result = false;
        try {
            switch (command) {
                case 0: {
                    result = this.execSuspend(args);
                    break;
                }
                case 1: {
                    result = this.execResume(args);
                    break;
                }
                case 2: {
                    result = this.execReload(args);
                    break;
                }
                case 3: {
                    result = this.execTerminate(args);
                    break;
                }
                case 4: {
                    result = this.execRestart(args);
                    break;
                }
                case 5: {
                    result = this.execClearStat(args);
                    break;
                }
                case 10: {
                    result = this.updateThreadPool(args);
                    break;
                }
                case 6: {
                    result = this.execSuspendListener(args);
                    break;
                }
                case 7: {
                    result = this.execResumeListener(args);
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RemoteException(t.getMessage());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execSuspend(String[] args) throws ServerException {
        boolean result = false;
        if (args.length != 3) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1004));
        }
        String ctxGroupName = args[0];
        String ctxName = args[1];
        String servletName = args[2];
        if (ctxGroupName == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1005));
        }
        if (ctxName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            return ctxGroup.execSuspend();
        }
        if (servletName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            Context context = ctxGroup.getContextByName(ctxName);
            if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
            return context.execSuspend();
        }
        ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
        if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        Context context = ctxGroup.getContextByName(ctxName);
        if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
        ServletWrapper wrapper = context.getServletByName(servletName);
        if (wrapper == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1008, (Object)servletName));
        return wrapper.execSuspend();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execResume(String[] args) throws ServerException {
        boolean result = false;
        if (args.length != 3) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1004));
        }
        String ctxGroupName = args[0];
        String ctxName = args[1];
        String servletName = args[2];
        if (ctxGroupName == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1005));
        }
        if (ctxName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            return ctxGroup.execResume();
        }
        if (servletName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            Context context = ctxGroup.getContextByName(ctxName);
            if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
            return context.execResume();
        }
        ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
        if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        Context context = ctxGroup.getContextByName(ctxName);
        if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
        ServletWrapper wrapper = context.getServletByName(servletName);
        if (wrapper == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1008, (Object)servletName));
        return wrapper.execResume();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execReload(String[] args) throws ServerException {
        boolean result = false;
        if (args.length != 3) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1004));
        }
        String ctxGroupName = args[0];
        String ctxName = args[1];
        if (ctxGroupName == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1005));
        }
        if (ctxName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            try {
                return ctxGroup.execReload();
            }
            catch (Exception e) {
                throw new ServerException(e.getMessage(), e);
            }
        }
        ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
        if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        Context context = ctxGroup.getContextByName(ctxName);
        if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
        try {
            return context.execReload();
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage(), e);
        }
    }

    public boolean execTerminate(String[] args) throws ServerException {
        Context context;
        boolean result = false;
        if (args.length != 3) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1004));
        }
        String ctxGroupName = args[0];
        String ctxName = args[1];
        String servletName = args[2];
        if (ctxGroupName == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1005));
        }
        if (ctxName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) {
                throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            }
            result = this.manager.terminateCtxGroup(ctxGroupName);
            return result;
        }
        if (servletName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup != null) {
                Context context2 = ctxGroup.getContextByName(ctxName);
                if (context2 == null) {
                    throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
                }
            } else {
                throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            }
            result = ctxGroup.terminateContext(ctxName);
            return result;
        }
        ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
        if (ctxGroup != null) {
            context = ctxGroup.getContextByName(ctxName);
            if (context == null) {
                throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
            }
        } else {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        }
        result = context.terminateServlet(servletName);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execRestart(String[] args) throws ServerException {
        boolean result = false;
        if (args.length != 3) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1004));
        }
        String ctxGroupName = args[0];
        String ctxName = args[1];
        String servletName = args[2];
        if (ctxGroupName == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1005));
        }
        if (ctxName == null) {
            if (!this.manager.validContextGroupName(ctxGroupName)) {
                throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            }
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) return this.manager.restartCtxGroup(ctxGroupName);
            this.manager.terminateCtxGroup(ctxGroupName);
            return this.manager.restartCtxGroup(ctxGroupName);
        }
        if (servletName == null) {
            ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            Context ctx = ctxGroup.getContextByName(ctxName);
            if (ctx == null) return ctxGroup.restartContext(ctxName);
            ctxGroup.terminateContext(ctxName);
            return ctxGroup.restartContext(ctxName);
        }
        ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
        if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        Context context = ctxGroup.getContextByName(ctxName);
        if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
        ServletWrapper wrapper = context.getServletByName(servletName);
        if (wrapper == null) return context.restartServlet(servletName);
        context.terminateServlet(servletName);
        return context.restartServlet(servletName);
    }

    public boolean execClearStat(String[] args) throws ServerException {
        String ctxGroupName = null;
        String ctxName = null;
        String servletName = null;
        if (args.length > 0) {
            ctxGroupName = args[0];
        }
        if (args.length > 1) {
            ctxName = args[1];
        }
        if (args.length > 2) {
            servletName = args[2];
        }
        ContextGroup ctxGroup = null;
        Context context = null;
        ServletWrapper wrapper = null;
        if (ctxGroupName != null) {
            ctxGroup = this.manager.getContextGroup(ctxGroupName);
            if (ctxGroup == null) {
                throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
            }
            if (ctxName != null && (context = ctxGroup.getContextByName(ctxName)) == null) {
                throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
            }
            if (servletName != null && (wrapper = context.getServletByName(servletName)) == null) {
                throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1008, (Object)servletName));
            }
        }
        boolean result = true;
        if (wrapper != null) {
            result = wrapper.clearRequestCount();
            return result;
        }
        if (context != null) {
            Enumeration enum1 = context.getContextLoader().getServlets();
            while (enum1.hasMoreElements()) {
                wrapper = (ServletWrapper)enum1.nextElement();
                result &= wrapper.clearRequestCount();
            }
            context.clearStatistic();
            return result;
        }
        if (ctxGroup != null) {
            Enumeration enum2 = ctxGroup.getContexts();
            while (enum2.hasMoreElements()) {
                context = (Context)enum2.nextElement();
                Enumeration enum1 = context.getContextLoader().getServlets();
                while (enum1.hasMoreElements()) {
                    wrapper = (ServletWrapper)enum1.nextElement();
                    result &= wrapper.clearRequestCount();
                }
            }
            return result;
        }
        Enumeration enum3 = this.manager.getContextGroups();
        while (enum3.hasMoreElements()) {
            ctxGroup = (ContextGroup)enum3.nextElement();
            Enumeration enum2 = ctxGroup.getContexts();
            while (enum2.hasMoreElements()) {
                context = (Context)enum2.nextElement();
                Enumeration enum1 = context.getContextLoader().getServlets();
                while (enum1.hasMoreElements()) {
                    wrapper = (ServletWrapper)enum1.nextElement();
                    result &= wrapper.clearRequestCount();
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execStart(String[] args) throws ServerException {
        boolean result = false;
        if (args.length != 2) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1004));
        }
        String ctxGroupName = args[0];
        String ctxName = args[1];
        if (ctxGroupName == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1005));
        if (ctxName == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1005));
        }
        ContextGroup ctxGroup = this.manager.getContextGroup(ctxGroupName);
        if (ctxGroup == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        Context context = ctxGroup.getContextByName(ctxName);
        if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1007, (Object)ctxName));
        try {
            return context.execStart();
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage(), e);
        }
    }

    public boolean execSuspendListener(String[] args) throws ServerException {
        String listenerId = args[0].substring(4);
        if (listenerId == null) {
            return false;
        }
        Connector connector = this.manager.getConnector(listenerId = listenerId.trim());
        if (connector == null) {
            return false;
        }
        if (!connector.getListenerType().equals("WebtobListener")) {
            return false;
        }
        ThreadPoolManager[] tpools = connector.getThreadPoolManager();
        if (tpools == null) {
            return false;
        }
        Throwable e = null;
        for (int i = 0; i < tpools.length; ++i) {
            WebtobThreadPoolManager tpool = (WebtobThreadPoolManager)tpools[i];
            try {
                tpool.suspend();
                continue;
            }
            catch (IOException ioe) {
                e = ioe;
            }
        }
        if (e != null) {
            throw new ServerException(e.getMessage());
        }
        return true;
    }

    public boolean execResumeListener(String[] args) throws ServerException {
        String listenerId = args[0].substring(4);
        if (listenerId == null) {
            return false;
        }
        Connector connector = this.manager.getConnector(listenerId = listenerId.trim());
        if (connector == null) {
            return false;
        }
        if (!connector.getListenerType().equals("WebtobListener")) {
            return false;
        }
        ThreadPoolManager[] tpools = connector.getThreadPoolManager();
        if (tpools == null) {
            return false;
        }
        Throwable e = null;
        for (int i = 0; i < tpools.length; ++i) {
            WebtobThreadPoolManager tpool = (WebtobThreadPoolManager)tpools[i];
            try {
                tpool.resume();
                continue;
            }
            catch (IOException ioe) {
                e = ioe;
            }
        }
        if (e != null) {
            throw new ServerException(e.getMessage());
        }
        return true;
    }

    public TargetModuleID deployContext(String ctxGroupName, List virtualHostName, ContextDescriptor ctxDesc, Policy appPolicy, ClassLoader classloader, WebModule webModule) throws RemoteException {
        return this.manager.deployContext(ctxGroupName, virtualHostName, ctxDesc, appPolicy, classloader, webModule);
    }

    public ObjectName undeployContext(String ctxGroupName, String contextName) throws RemoteException {
        ContextGroup contextGroup = this.manager.getContextGroup(ctxGroupName);
        if (contextGroup == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1006, (Object)ctxGroupName));
        }
        return contextGroup.undeployContext(contextName);
    }

    public void down() throws RemoteException {
        this.manager.shutdown();
    }

    public boolean updateThreadPool(String[] args) {
        if (args.length != 3 || args[0] == null || args[1] == null) {
            return false;
        }
        String port = args[0];
        int pos = args[1].indexOf("=");
        if (pos <= 0) {
            return false;
        }
        String param = args[1].substring(0, pos);
        String valueStr = args[1].substring(pos + 1);
        int value = 0;
        if (valueStr == null) {
            return false;
        }
        try {
            value = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (value < 0) {
            return false;
        }
        int minThread = -1;
        int maxThread = -1;
        int changeRate = -1;
        int idleTime = -1;
        int maxWaitQueue = -1;
        int currThread = -1;
        if (param.equals("min")) {
            minThread = value;
        } else if (param.equals("max")) {
            maxThread = value;
        } else if (param.equals("rate")) {
            changeRate = value;
        } else if (param.equals("idle")) {
            idleTime = value;
        } else if (param.equals("queue")) {
            maxWaitQueue = value;
        } else if (param.equals("cur")) {
            currThread = value;
        } else {
            return false;
        }
        Enumeration ctxGroups = this.manager.getContextGroups();
        while (ctxGroups.hasMoreElements()) {
            ContextGroup ctxGroup = (ContextGroup)ctxGroups.nextElement();
            ThreadPoolManager[] poolManager = ctxGroup.getThreadPoolManager(port);
            if (poolManager == null) continue;
            for (int i = 0; i < poolManager.length; ++i) {
                try {
                    if (minThread > 0) {
                        poolManager[i].getThreadPoolDescriptor().setMinThreadNum("" + minThread);
                        continue;
                    }
                    if (maxThread > 0) {
                        poolManager[i].getThreadPoolDescriptor().setMaxThreadNum("" + maxThread);
                        continue;
                    }
                    if (changeRate > 0) {
                        poolManager[i].getThreadPoolDescriptor().setChangingRate("" + changeRate);
                        continue;
                    }
                    if (idleTime > 0) {
                        poolManager[i].getThreadPoolDescriptor().setMaxIdleTime("" + idleTime);
                        continue;
                    }
                    if (maxWaitQueue > 0) {
                        poolManager[i].getThreadPoolDescriptor().setMaxWaitQueue("" + maxWaitQueue);
                        continue;
                    }
                    if (currThread < 0) continue;
                    poolManager[i].deleteAllThreads();
                    continue;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String getEngineName() {
        return this.containerName;
    }
}

