/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import jeus.servlet.connection.Connector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpThreadPoolManager;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.util.SimpleTimer;
import jeus.servlet.util.StandardQueue;
import jeus.util.message.JeusMessage_WebContainer1;

public class HttpConnector
extends Connector {
    private boolean running = true;
    private ServerSocket serverSocket;
    private StandardQueue connQueue;
    private int retryInterval = 1;
    private ThreadPoolManager poolManager;

    public HttpConnector(ContextGroup ctxGroup, ConnectionDescriptor desc) {
        super(ctxGroup, desc);
        this.poolManager = new HttpThreadPoolManager(ctxGroup, desc);
    }

    public void init() throws StartingException {
        try {
            this.connQueue = this.poolManager.getQueue();
            this.poolManager.createPool();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer1._2050_LEVEL)) {
                logger.log(JeusMessage_WebContainer1._2050_LEVEL, JeusMessage_WebContainer1._2050, (Object)this.listenerId, (Throwable)e);
            }
            throw new StartingException(JeusMessage_WebContainer1._2050, this.listenerId, (Throwable)e);
        }
    }

    public void startConnector() throws StartingException {
        try {
            this.serverSocket = this.connDesc.isEnableSecure() ? this.sslSocketFactory.createSocket(this.port, this.backlog) : new ServerSocket(this.port, this.backlog);
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer1._2051_LEVEL)) {
                logger.log(JeusMessage_WebContainer1._2051_LEVEL, JeusMessage_WebContainer1._2051, (Object[])new String[]{this.listenerId, String.valueOf(this.port)}, (Throwable)e);
            }
            throw new StartingException(JeusMessage_WebContainer1._2051, new String[]{this.listenerId, String.valueOf(this.port)}, (Throwable)e);
        }
        Thread listener = new Thread(this);
        listener.setName(this.listenerId + "-acceptor");
        listener.start();
        if (logger.isLoggable(JeusMessage_WebContainer1._2052_LEVEL)) {
            logger.log(JeusMessage_WebContainer1._2052_LEVEL, JeusMessage_WebContainer1._2052, (Object[])new String[]{this.listenerId, String.valueOf(this.port)});
        }
    }

    public void run() {
        while (this.running) {
            try {
                Socket socket = null;
                socket = this.sslSocketFactory != null ? this.sslSocketFactory.acceptSocket(this.serverSocket) : this.serverSocket.accept();
                if (!this.running) break;
                this.retryInterval = 1;
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (socket instanceof SSLSocket) {
                    try {
                        this.sslSocketFactory.handshake((SSLSocket)socket);
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "failed to handshake a client", t);
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        socket = null;
                    }
                }
                if (socket == null) continue;
                this.connQueue.put(socket);
            }
            catch (InterruptedIOException iioe) {
            }
            catch (Exception e) {
                if (!this.running) continue;
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (logger.isLoggable(JeusMessage_WebContainer1._2057_LEVEL)) {
                    logger.log(JeusMessage_WebContainer1._2057_LEVEL, JeusMessage_WebContainer1._2057, (Object)this.listenerId, (Throwable)e);
                }
                try {
                    Thread.sleep(this.retryInterval * 1000);
                }
                catch (Exception e3) {
                    // empty catch block
                }
                this.retryInterval *= 2;
                try {
                    if (this.connDesc.isEnableSecure()) {
                        this.serverSocket = this.sslSocketFactory.createSocket(this.port, this.backlog);
                        continue;
                    }
                    this.serverSocket = new ServerSocket(this.port, this.backlog);
                }
                catch (Exception e3) {
                    if (logger.isLoggable(JeusMessage_WebContainer1._2051_LEVEL)) {
                        logger.log(JeusMessage_WebContainer1._2051_LEVEL, JeusMessage_WebContainer1._2051, (Object[])new String[]{this.listenerId, String.valueOf(this.port)}, (Throwable)e3);
                    }
                    this.running = false;
                }
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer1._2056_LEVEL)) {
            logger.log(JeusMessage_WebContainer1._2056_LEVEL, JeusMessage_WebContainer1._2056, (Object[])new String[]{this.listenerId, String.valueOf(this.port)});
        }
    }

    public void destroy(SimpleTimer timer) {
        this.running = false;
        try {
            Socket dummy = new Socket("127.0.0.1", this.port);
            dummy.close();
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.poolManager.destroy();
            this.poolManager.waitWorkerDestroy(timer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int[] getThreadInfo() {
        int[] info = new int[]{this.poolManager.getCurrentThreadNum(), this.poolManager.getWaitQueueCount(), this.poolManager.getMaxThreadNum()};
        return info;
    }

    public ThreadPoolManager[] getThreadPoolManager() {
        return new ThreadPoolManager[]{this.poolManager};
    }
}

