/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import jeus.servlet.connection.Connector;
import jeus.servlet.connector.WebThreadPoolManager;
import jeus.servlet.connector.protocol.tmax.TMAXWebConnectorManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.util.SimpleTimer;

public class NIOTmaxConnector
extends Connector {
    TMAXWebConnectorManager webConnector;

    public NIOTmaxConnector(ContextGroup ctxGroup, ConnectionDescriptor desc) {
        super(ctxGroup, desc);
        this.webConnector = new TMAXWebConnectorManager(ctxGroup, desc);
    }

    public void init() throws StartingException {
    }

    public void startConnector() throws StartingException {
        if (this.webConnector == null) {
            throw new StartingException("WebConnector must be initialized");
        }
        this.webConnector.init();
    }

    public void run() {
    }

    public void destroy(SimpleTimer timer) {
        if (this.webConnector != null) {
            this.webConnector.finish();
            this.webConnector = null;
        }
    }

    public ThreadPoolManager[] getThreadPoolManager() {
        return this.webConnector.getThreadPoolManagers();
    }

    protected int[] getThreadInfo() {
        int[] info = new int[3];
        if (this.webConnector == null) {
            return info;
        }
        WebThreadPoolManager poolManager = this.webConnector.getThreadPoolManager();
        if (poolManager == null) {
            return info;
        }
        info[0] = poolManager.getCurrentThreadNum();
        info[1] = poolManager.getWaitQueueCount();
        info[2] = poolManager.getMaxThreadNum();
        return info;
    }
}

