/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;

public abstract class SSLSocketFactory {
    protected SSLServerSocketFactory sslProxy = null;
    protected ConnectionDescriptor connDesc;
    private boolean initialized;
    private String[] enabledCiphers;
    protected static final String DEFAULT_PROTOCOL = "TLS";

    public SSLSocketFactory(ConnectionDescriptor connDesc) {
        this.connDesc = connDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (!this.initialized) {
            SSLSocketFactory sSLSocketFactory = this;
            synchronized (sSLSocketFactory) {
                if (!this.initialized) {
                    this.init();
                    this.enabledCiphers = this.getEnabledCiphers(this.connDesc.getCipherSuites(), this.sslProxy.getSupportedCipherSuites());
                    this.initialized = true;
                }
            }
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    private void initServerSocket(ServerSocket socket) {
        if (!(socket instanceof SSLServerSocket)) {
            return;
        }
        SSLServerSocket sslSocket = (SSLServerSocket)socket;
        if (this.enabledCiphers != null) {
            sslSocket.setEnabledCipherSuites(this.enabledCiphers);
        }
        this.configureClientAuth(sslSocket);
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)socket.accept();
            this.configureClientAuth(asock);
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    public void handshake(SSLSocket sslSocket) throws IOException {
        sslSocket.startHandshake();
    }

    private String[] getEnabledCiphers(List requestedCiphers, String[] supportedCiphers) {
        if (requestedCiphers == null) {
            return supportedCiphers;
        }
        Object[] enabledCiphers = null;
        Vector<String> vec = null;
        block0: for (String cipher : requestedCiphers) {
            if ((cipher = cipher.trim()).length() <= 0) continue;
            for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                if (!supportedCiphers[i].equals(cipher)) continue;
                if (vec == null) {
                    vec = new Vector<String>();
                }
                vec.addElement(cipher);
                continue block0;
            }
        }
        if (vec != null) {
            enabledCiphers = new String[vec.size()];
            vec.copyInto(enabledCiphers);
        } else {
            enabledCiphers = supportedCiphers;
        }
        return enabledCiphers;
    }

    protected KeyStore getStore(String type, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = KeyStore.getInstance(type);
            if (!"PKCS11".equalsIgnoreCase(type)) {
                istream = new FileInputStream(path);
            }
            ks.load(istream, pass.toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException("Exception trying to load keystore " + path + ": " + ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    protected abstract void init() throws IOException;

    protected abstract void configureClientAuth(SSLServerSocket var1);

    protected abstract void configureClientAuth(SSLSocket var1);
}

