/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import jeus.servlet.connection.SSLSocketFactory;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;

public class SSLSocketFactory13
extends SSLSocketFactory {
    private boolean clientAuth = false;

    public SSLSocketFactory13(ConnectionDescriptor connDesc) {
        super(connDesc);
    }

    protected void init() throws IOException {
        try {
            String protocol;
            try {
                Class<?> ssps = Class.forName("sun.security.provider.Sun");
                Security.addProvider((java.security.Provider)ssps.newInstance());
            }
            catch (Exception cnfe) {
                // empty catch block
            }
            Security.addProvider((java.security.Provider)new Provider());
            String clientAuthStr = this.connDesc.getClientAuth();
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr) || "want".equalsIgnoreCase(clientAuthStr)) {
                this.clientAuth = true;
            }
            if ((protocol = this.connDesc.getSslProtocol()) == null) {
                protocol = "TLS";
            }
            SSLContext context = SSLContext.getInstance((String)protocol);
            context.init(this.getKeyManagers(this.connDesc.getKeyStoreType(), this.connDesc.getKeyManagementAlgorithm(), this.connDesc.getKeyStoreFile(), this.connDesc.getKeyStorePass(), this.connDesc.getKeypassword()), this.getTrustManagers(this.connDesc.getTrustStoreType(), this.connDesc.getTrustManagementAlgorithm(), this.connDesc.getTrustStoreFile(), this.connDesc.getTrustStorePass()), new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    private KeyManager[] getKeyManagers(String keystoreType, String algorithm, String path, String pass, String keypass) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)algorithm);
        kmf.init(this.getStore(keystoreType, path, pass), keypass.toCharArray());
        return kmf.getKeyManagers();
    }

    private TrustManager[] getTrustManagers(String truststoreType, String algorithm, String path, String pass) throws Exception {
        TrustManager[] tms = null;
        KeyStore trustStore = this.getStore(truststoreType, path, pass);
        if (trustStore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)algorithm);
            tmf.init(trustStore);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        socket.setNeedClientAuth(this.clientAuth);
    }

    protected void configureClientAuth(SSLSocket socket) {
        socket.setNeedClientAuth(this.clientAuth);
    }
}

