/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import jeus.servlet.connection.JSSEKeyManager;
import jeus.servlet.connection.SSLSocketFactory;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;

public class SSLSocketFactory14
extends SSLSocketFactory {
    private boolean requireClientAuth = false;
    private boolean wantClientAuth = false;
    private static String defaultKeystoreType = "JKS";

    public SSLSocketFactory14(ConnectionDescriptor connDesc) {
        super(connDesc);
    }

    protected void init() throws IOException {
        try {
            String clientAuthStr = this.connDesc.getClientAuth();
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            String protocol = this.connDesc.getSslProtocol();
            if (protocol == null) {
                protocol = "TLS";
            }
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(this.getKeyManagers(this.connDesc.getKeyStoreType(), this.connDesc.getKeyManagementAlgorithm(), this.connDesc.getKeyStoreFile(), this.connDesc.getKeyStorePass(), this.connDesc.getKeyAlias(), this.connDesc.getKeypassword()), this.getTrustManagers(this.connDesc.getTrustStoreType(), this.connDesc.getTrustManagementAlgorithm(), this.connDesc.getTrustStoreFile(), this.connDesc.getTrustStorePass()), new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    private KeyManager[] getKeyManagers(String keystoreType, String algorithm, String path, String pass, String keyAlias, String keypass) throws Exception {
        KeyManager[] kms = null;
        KeyStore ks = this.getStore(keystoreType, path, pass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException("key alias is no entry. alias=" + keyAlias);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keypass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if (defaultKeystoreType.equals(keystoreType)) {
                keyAlias = keyAlias.toLowerCase();
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String truststoreType, String algorithm, String path, String pass) throws Exception {
        TrustManager[] tms = null;
        KeyStore trustStore = this.getStore(truststoreType, path, pass);
        if (trustStore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(trustStore);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        if (this.wantClientAuth) {
            socket.setWantClientAuth(this.wantClientAuth);
        } else {
            socket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    protected void configureClientAuth(SSLSocket socket) {
    }
}

