/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import jeus.servlet.connection.SSLSupport;

public class SSLSupport14
extends SSLSupport {
    Listener listener = new Listener();

    public SSLSupport14(SSLSocket sslSocket) {
        super(sslSocket);
        sslSocket.addHandshakeCompletedListener(this.listener);
    }

    protected void handShake() throws IOException {
        if (!this.sslSocket.getWantClientAuth()) {
            this.sslSocket.setNeedClientAuth(true);
        }
        this.synchronousHandshake(this.sslSocket);
    }

    private void synchronousHandshake(SSLSocket socket) throws IOException {
        InputStream in = socket.getInputStream();
        int oldTimeout = socket.getSoTimeout();
        socket.setSoTimeout(1000);
        byte[] b = new byte[]{};
        this.listener.reset();
        socket.startHandshake();
        int maxTries = 60;
        for (int i = 0; i < maxTries; ++i) {
            try {
                int x = in.read(b);
            }
            catch (SSLException sslex) {
                sslex.printStackTrace();
                throw sslex;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.listener.completed) break;
        }
        socket.setSoTimeout(oldTimeout);
        if (!this.listener.completed) {
            throw new SocketException("SSL Cert handshake timeout");
        }
    }

    protected X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        Certificate[] certs = null;
        try {
            certs = session.getPeerCertificates();
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "error getting client certs", t);
            }
            return null;
        }
        if (certs == null) {
            return null;
        }
        X509Certificate[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
                continue;
            }
            try {
                byte[] buffer = certs[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    private static class Listener
    implements HandshakeCompletedListener {
        volatile boolean completed = false;

        private Listener() {
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.completed = true;
        }

        void reset() {
            this.completed = false;
        }
    }
}

