/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.servlet.connection.Connector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.WebtobThreadPoolManager;
import jeus.servlet.util.SimpleTimer;
import jeus.util.message.JeusMessage_WebContainer1;

public class WebtobConnector
extends Connector {
    private ThreadPoolManager[] poolManager;
    private Vector webServerDescs;
    private int serverIndex;
    private boolean[] connectionUnavailable;
    private Object failoverLock = new Object();
    private AtomicBoolean destroyed = new AtomicBoolean(false);

    public WebtobConnector(ContextGroup ctxGroup, ConnectionDescriptor desc) {
        super(ctxGroup, desc);
        this.initWebServerDescriptors(desc);
        this.createPoolManager();
    }

    private void initWebServerDescriptors(ConnectionDescriptor main) {
        this.webServerDescs = new Vector();
        this.serverIndex = 0;
        this.webServerDescs.add(main);
        Vector backups = main.getBackupServerDescriptor();
        if (backups != null && backups.size() > 0) {
            Enumeration enum1 = backups.elements();
            while (enum1.hasMoreElements()) {
                ConnectionDescriptor backup = (ConnectionDescriptor)enum1.nextElement();
                try {
                    backup.setListenerId(main.getListenerId());
                }
                catch (DescriptorException de) {
                    // empty catch block
                }
                if (backup.getThreadPoolDescriptor() == null) {
                    backup.setThreadPoolDescriptor(main.getThreadPoolDescriptor());
                }
                this.webServerDescs.add(backup);
            }
        }
    }

    private void createPoolManager() {
        int hthNum = this.connDesc.getConnectionPortNum();
        this.poolManager = new ThreadPoolManager[hthNum];
        this.connectionUnavailable = new boolean[hthNum];
        for (int i = 0; i < hthNum; ++i) {
            this.poolManager[i] = new WebtobThreadPoolManager(this.contextGroup, this, this.connDesc, i);
            this.connectionUnavailable[i] = false;
        }
        this.registerPoolManagerMBean();
    }

    public void init() throws StartingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnector() throws StartingException {
        if (this.destroyed.get()) {
            return;
        }
        Object object = this.failoverLock;
        synchronized (object) {
            try {
                for (int i = 0; i < this.poolManager.length; ++i) {
                    this.poolManager[i].createPool();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer1._2052_LEVEL)) {
            logger.log(JeusMessage_WebContainer1._2052_LEVEL, JeusMessage_WebContainer1._2052, (Object[])new String[]{this.listenerId, String.valueOf(this.port)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failback(int index) {
        if (index < 0 || index >= this.webServerDescs.size()) {
            return;
        }
        if (this.destroyed.get()) {
            return;
        }
        Object object = this.failoverLock;
        synchronized (object) {
            block8: {
                ConnectionDescriptor newDesc = (ConnectionDescriptor)this.webServerDescs.get(index);
                this.serverIndex = index;
                this.contextGroup.removeThreadPoolManager(this.listenerId);
                for (int j = 0; j < this.poolManager.length; ++j) {
                    this.poolManager[j].destroy();
                    this.poolManager[j].waitWorkerDestroy(new SimpleTimer(120000L));
                }
                this.initParameters(newDesc);
                this.createPoolManager();
                this.contextGroup.addThreadPoolManager(this.listenerId, this.poolManager);
                try {
                    this.startConnector();
                }
                catch (StartingException se) {
                    if (!logger.isLoggable(JeusMessage_WebContainer1._2065_LEVEL)) break block8;
                    logger.log(JeusMessage_WebContainer1._2065_LEVEL, JeusMessage_WebContainer1._2065, (Object[])new String[]{this.listenerId, this.webServerAddress, String.valueOf(this.port)}, (Throwable)((Object)se));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarmConnectionUnavailable(int hthId) {
        if (this.destroyed.get()) {
            return;
        }
        Object object = this.failoverLock;
        synchronized (object) {
            block13: {
                int i;
                this.connectionUnavailable[hthId] = true;
                boolean doFailover = true;
                for (i = 0; i < this.connectionUnavailable.length; ++i) {
                    if (this.connectionUnavailable[i]) continue;
                    doFailover = false;
                    break;
                }
                if (doFailover) {
                    if (this.webServerDescs.size() > 1) {
                        i = this.serverIndex;
                        if (++i == this.webServerDescs.size()) {
                            i = 0;
                        }
                        this.contextGroup.removeThreadPoolManager(this.listenerId);
                        for (int j = 0; j < this.poolManager.length; ++j) {
                            this.poolManager[j].destroy();
                            this.poolManager[j].waitWorkerDestroy(null);
                        }
                        this.serverIndex = i;
                        ConnectionDescriptor currentDesc = (ConnectionDescriptor)this.webServerDescs.get(this.serverIndex);
                        this.initParameters(currentDesc);
                        this.createPoolManager();
                        this.contextGroup.addThreadPoolManager(this.listenerId, this.poolManager);
                        try {
                            this.startConnector();
                        }
                        catch (StartingException se) {
                            if (!logger.isLoggable(JeusMessage_WebContainer1._2065_LEVEL)) break block13;
                            logger.log(JeusMessage_WebContainer1._2065_LEVEL, JeusMessage_WebContainer1._2065, (Object[])new String[]{this.listenerId, this.webServerAddress, String.valueOf(this.port)}, (Throwable)((Object)se));
                        }
                    } else {
                        this.contextGroup.removeThreadPoolManager(this.listenerId);
                        for (int j = 0; j < this.poolManager.length; ++j) {
                            this.poolManager[j].destroy();
                            this.poolManager[j].waitWorkerDestroy(null);
                        }
                    }
                }
            }
        }
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(SimpleTimer timer) {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        Object object = this.failoverLock;
        synchronized (object) {
            for (int i = 0; i < this.poolManager.length; ++i) {
                this.poolManager[i].destroy();
                this.poolManager[i].waitWorkerDestroy(timer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getThreadInfo() {
        ThreadPoolManager[] pm = null;
        int[] info = new int[3];
        if (this.destroyed.get()) {
            return info;
        }
        Object object = this.failoverLock;
        synchronized (object) {
            pm = this.poolManager;
        }
        info[0] = 0;
        for (int i = 0; i < pm.length; ++i) {
            info[0] = info[0] + pm[i].getCurrentThreadNum();
            info[1] = info[1] + pm[i].getWaitQueueCount();
            info[2] = info[2] + pm[i].getMaxThreadNum();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionInfo() {
        ThreadPoolManager[] pm = null;
        if (this.destroyed.get()) {
            return new String[0];
        }
        Object object = this.failoverLock;
        synchronized (object) {
            pm = this.poolManager;
        }
        String[] result = new String[pm.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((WebtobThreadPoolManager)pm[i]).getConnectionInfo();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolManager[] getThreadPoolManager() {
        if (this.destroyed.get()) {
            return new ThreadPoolManager[0];
        }
        Object object = this.failoverLock;
        synchronized (object) {
            return this.poolManager;
        }
    }
}

