/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import jeus.io.Selector;
import jeus.io.SocketListener;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.handler.StreamHandler;
import jeus.io.helper.IOComponentCreator;
import jeus.io.impl.nio.ChannelAcceptor;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.servlet.connector.WebConnectionListener;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.WebContentHandlerCreator;
import jeus.servlet.connector.WebStreamContentReceiver;
import jeus.servlet.connector.protocol.http.HTTPWebContentHandlerCreator;
import jeus.servlet.connector.protocol.tcp.TCPWebContentHandlerCreator;
import jeus.servlet.tcp.ConnectionHandshaker;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;
import jeus.util.properties.JeusNetProperties;

public class Acceptor
implements SocketListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    private WebContentHandlerCreator webContentHandlerCreator = null;
    private Selector jeusSelector;
    private boolean destroyed;
    private jeus.io.Acceptor jeusAcceptor = null;
    private Thread acceptorThread = null;
    private static final int INVALID_PORT = -1;
    protected WebConnector connector;
    private SSLContext sslContext = null;
    private static final Map sslProperty = new HashMap();

    public Acceptor(WebConnector connector, Selector jeusSelector, boolean useSSL) {
        if (logger.isLoggable(JeusMessage_WebContainer10._10217_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10217_LEVEL, JeusMessage_WebContainer10._10217, new Object[]{connector, jeusSelector, String.valueOf(useSSL)});
        }
        this.destroyed = false;
        this.connector = connector;
        this.jeusSelector = jeusSelector;
        if (connector.getConnectionDescriptor().isEnableSecure()) {
            this.sslContext = connector.getSSLContext();
        }
    }

    public void init(String name, int port, WebContentHandlerCreator webContentHandlerCreator, int backlog) throws IOException {
        if (port <= 0 || port > 65535) {
            IOException ie = new IOException("accept port is not valid");
            if (logger.isLoggable(JeusMessage_WebContainer10._10207_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10207_LEVEL, JeusMessage_WebContainer10._10207, new Object[]{name, String.valueOf(port)});
            }
            throw ie;
        }
        if (webContentHandlerCreator == null) {
            IOException ie = new IOException("WebContentHandlerCreator must be initialized");
            if (logger.isLoggable(JeusMessage_WebContainer10._10207_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10207_LEVEL, JeusMessage_WebContainer10._10207, new Object[]{name, String.valueOf(port)});
            }
            throw ie;
        }
        this.webContentHandlerCreator = webContentHandlerCreator;
        if (logger.isLoggable(JeusMessage_WebContainer10._10208_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10208_LEVEL, JeusMessage_WebContainer10._10208, new Object[]{name, String.valueOf(port)});
        }
        if (this.jeusAcceptor == null) {
            this.jeusAcceptor = new ChannelAcceptor(port, (SocketListener)this, backlog, null, JeusNetProperties.REUSE_ADDRESS);
        }
        if (this.acceptorThread == null) {
            this.acceptorThread = new Thread((Runnable)this.jeusAcceptor, name);
        }
        this.acceptorThread.setDaemon(true);
        this.acceptorThread.start();
    }

    protected boolean onSocketHook(Socket socket) {
        return true;
    }

    public synchronized void onSocket(Socket socket) {
        block29: {
            if (this.destroyed) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10209_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10209_LEVEL, JeusMessage_WebContainer10._10209, (Object)socket);
                }
                return;
            }
            try {
                socket.setTcpNoDelay(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.onSocketHook(socket)) {
                return;
            }
            String remoteAddr = socket.getInetAddress().getHostAddress();
            if (!this.connector.contextGroup.getContainerManager().updateClientStats(remoteAddr)) {
                block27: {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(JeusMessage_WebContainer10._10232_LEVEL)) break block27;
                        logger.log(JeusMessage_WebContainer10._10232_LEVEL, JeusMessage_WebContainer10._10232, (Object)socket, (Throwable)e);
                    }
                }
                return;
            }
            ConnectionHandshaker handshaker = this.connector.getHandshaker();
            if (handshaker != null && !handshaker.doHandshake(socket)) {
                block28: {
                    if (logger.isLoggable(JeusMessage_WebContainer10._10231_LEVEL)) {
                        logger.log(JeusMessage_WebContainer10._10231_LEVEL, JeusMessage_WebContainer10._10231, (Object)socket);
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {
                        if (!logger.isLoggable(JeusMessage_WebContainer10._10232_LEVEL)) break block28;
                        logger.log(JeusMessage_WebContainer10._10232_LEVEL, JeusMessage_WebContainer10._10232, (Object)socket, (Throwable)ioe);
                    }
                }
                return;
            }
            try {
                if (logger.isLoggable(JeusMessage_WebContainer10._10210_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10210_LEVEL, JeusMessage_WebContainer10._10210, (Object)socket);
                }
                socket.setSoLinger(false, 0);
                if (logger.isLoggable(JeusMessage_WebContainer10._10211_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10211_LEVEL, JeusMessage_WebContainer10._10211, (Object)socket);
                }
                WebStreamContentReceiver contentReceiver = new WebStreamContentReceiver(this.connector);
                if (this.sslContext != null) {
                    if (this.connector.getClientAuth()) {
                        sslProperty.put("needClientAuth", Boolean.TRUE);
                    } else {
                        sslProperty.put("needClientAuth", Boolean.FALSE);
                    }
                    if (this.webContentHandlerCreator instanceof TCPWebContentHandlerCreator) {
                        IOComponentCreator.setSSLInfo((SSLContext)this.sslContext, (Map)sslProperty, (StreamContentHandlerCreator)this.webContentHandlerCreator);
                    }
                    if (this.webContentHandlerCreator instanceof HTTPWebContentHandlerCreator) {
                        SSLEngine sslEngine = IOComponentCreator.setSSLInfoToWriter((SSLContext)this.sslContext, (Map)sslProperty, (StreamContentHandlerCreator)this.webContentHandlerCreator);
                        this.webContentHandlerCreator.setSSLEngine(sslEngine);
                    }
                }
                if (logger.isLoggable(JeusMessage_WebContainer10._10212_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10212_LEVEL, JeusMessage_WebContainer10._10212, (Object)socket);
                }
                if (this.webContentHandlerCreator == null) {
                    IOException ie = new IOException("content handler creator must be initialized.");
                    if (logger.isLoggable(JeusMessage_WebContainer10._10213_LEVEL)) {
                        logger.log(JeusMessage_WebContainer10._10213_LEVEL, JeusMessage_WebContainer10._10213, (Object)socket, (Throwable)ie);
                    }
                    throw ie;
                }
                NIOStreamHandlerImpl handler = new NIOStreamHandlerImpl((StreamContentReceiver)contentReceiver, (StreamContentHandlerCreator)this.webContentHandlerCreator, JeusNetProperties.WRITE_LIMIT, JeusNetProperties.WRITE_RESTART, JeusNetProperties.WRITE_REPEAT_COUNT);
                handler.setSocket(socket);
                if (logger.isLoggable(JeusMessage_WebContainer10._10214_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10214_LEVEL, JeusMessage_WebContainer10._10214, new Object[]{handler, this.jeusSelector});
                }
                this.jeusSelector.addSelectItem((StreamHandler)handler);
                WebConnectionListener connListener = this.connector.getConnectionListener();
                Object connectionContext = null;
                if (connListener != null) {
                    logger.log(JeusMessage_WebContainer10._10234_LEVEL, JeusMessage_WebContainer10._10234, (Object)connListener);
                    connectionContext = connListener.connectionEstablished((StreamHandler)handler);
                    if (connectionContext != null) {
                        logger.log(JeusMessage_WebContainer10._10235_LEVEL, JeusMessage_WebContainer10._10235, new Object[]{connectionContext, connListener});
                        this.connector.connectionContextMap.put(handler, connectionContext);
                    }
                }
                this.connector.incrementTotalAcceptCount();
            }
            catch (IOException e) {
                if (!logger.isLoggable(JeusMessage_WebContainer10._10215_LEVEL)) break block29;
                logger.log(JeusMessage_WebContainer10._10215_LEVEL, JeusMessage_WebContainer10._10215, (Object)socket, (Throwable)e);
            }
        }
    }

    public synchronized void destroy() {
        if (logger.isLoggable(JeusMessage_WebContainer10._10216_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10216_LEVEL, JeusMessage_WebContainer10._10216, (Object)String.valueOf(this.getServerSocketPort()));
        }
        this.destroyed = true;
        this.connector = null;
        this.sslContext = null;
        this.jeusSelector = null;
        this.webContentHandlerCreator = null;
        if (this.jeusAcceptor != null) {
            this.jeusAcceptor.stop();
            this.jeusAcceptor = null;
        }
        if (this.acceptorThread != null) {
            this.acceptorThread.interrupt();
            this.acceptorThread = null;
        }
    }

    public int getServerSocketPort() {
        if (this.jeusAcceptor != null) {
            return this.jeusAcceptor.getRealListenPort();
        }
        return -1;
    }

    static {
        sslProperty.put("useClientMode", Boolean.FALSE);
        sslProperty.put("needClientAuth", Boolean.FALSE);
    }
}

