/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.protocol.http.HTTPWebStreamContentReader;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.io.ChunkedOutputAdaptor;
import jeus.util.message.JeusMessage_WebContainer2;

public class NIOChunkedOutputAdaptor
extends ChunkedOutputAdaptor {
    public NIOChunkedOutputAdaptor(NIOWebServerOutputStream nioWebServerOutputStream, byte[] httpHeader, byte[] httpBody) {
        super(null, nioWebServerOutputStream, httpHeader, httpBody);
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        boolean flushed = false;
        HttpServletRequestImpl request = this.webServer.getRequest();
        if (request.isBlockingMode()) {
            while (!((HTTPWebStreamContentReader)this.streamHandler.getContentReader()).isBlockingEnabled()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                int contLen = this.bufferCount - this.webServerHeaderSize - this.chunkSizeField.length;
                if (!forced && !last && contLen <= 0) {
                    return false;
                }
                int webServerContLen = 0;
                if (!this.committed) {
                    this.writeHeader();
                    webServerContLen = this.headerCount + this.setChunkField(last, contLen);
                    this.webServer.setWebServerHeader(last, webServerContLen, 0, this.httpHeader);
                    this.out.write(this.httpHeader, 0, this.headerCount);
                    if (contLen > 0 || last) {
                        this.out.write(this.httpBody, this.webServerHeaderSize + this.chunksizeStartOffset, this.bufferCount - (this.webServerHeaderSize + this.chunksizeStartOffset));
                    }
                    this.out.flush();
                    flushed = true;
                    this.committed = true;
                    if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                        logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                    }
                } else {
                    webServerContLen = this.setChunkField(last, contLen);
                    this.webServer.setWebServerHeader(last, webServerContLen + this.webServerHeaderSize, 0, this.httpBody);
                    if (webServerContLen > 0) {
                        if (this.chunksizeStartOffset > 0) {
                            this.out.write(this.httpBody, 0, this.webServerHeaderSize);
                            int off = this.webServerHeaderSize + this.chunksizeStartOffset;
                            this.out.write(this.httpBody, off, this.bufferCount - off);
                        } else {
                            this.out.write(this.httpBody, 0, this.bufferCount);
                        }
                        this.out.flush();
                        flushed = true;
                    }
                }
                if (flushed) {
                    this.bufferCount = this.webServerHeaderSize + this.chunkSizeField.length;
                }
            }
            catch (IOException ioe) {
                this.committed = false;
                this.reset();
                throw ioe;
            }
            if (last) {
                try {
                    this.streamHandler.register();
                    HTTPWebStreamContentReader contentReader = (HTTPWebStreamContentReader)this.streamHandler.getContentReader();
                    contentReader.setBlockingEnabled(false);
                    contentReader.setProcessing(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return flushed;
        }
        try {
            int contLen = this.bufferCount - this.webServerHeaderSize - this.chunkSizeField.length;
            if (!forced && !last && contLen <= 0) {
                return false;
            }
            int webServerContLen = 0;
            int writeTotalSize = 0;
            ByteBuffer buffer = null;
            if (!this.committed) {
                this.writeHeader();
                webServerContLen = this.headerCount + this.setChunkField(last, contLen);
                this.webServer.setWebServerHeader(last, webServerContLen, 0, this.httpHeader);
                writeTotalSize = this.headerCount;
                if (contLen > 0 || last) {
                    int bodyLen = this.bufferCount - (this.webServerHeaderSize + this.chunksizeStartOffset);
                    buffer = this.streamHandler.createByteBuffer(writeTotalSize += bodyLen);
                    buffer.put(this.httpHeader, 0, this.headerCount);
                    buffer.put(this.httpBody, this.webServerHeaderSize + this.chunksizeStartOffset, bodyLen);
                } else {
                    buffer = this.streamHandler.createByteBuffer(writeTotalSize);
                    buffer.put(this.httpHeader, 0, this.headerCount);
                }
                this.streamHandler.write(buffer);
                flushed = true;
                this.committed = true;
            } else {
                webServerContLen = this.setChunkField(last, contLen);
                this.webServer.setWebServerHeader(last, webServerContLen + this.webServerHeaderSize, 0, this.httpBody);
                if (webServerContLen > 0) {
                    if (this.chunksizeStartOffset > 0) {
                        int off = this.webServerHeaderSize + this.chunksizeStartOffset;
                        writeTotalSize = this.webServerHeaderSize;
                        int bodyLen = this.bufferCount - off;
                        buffer = this.streamHandler.createByteBuffer(writeTotalSize += bodyLen);
                        buffer.put(this.httpBody, 0, this.webServerHeaderSize);
                        buffer.put(this.httpBody, off, bodyLen);
                    } else {
                        writeTotalSize = this.bufferCount;
                        buffer = this.streamHandler.createByteBuffer(writeTotalSize);
                        buffer.put(this.httpBody, 0, this.bufferCount);
                    }
                    this.streamHandler.write(buffer);
                    flushed = true;
                }
            }
            if (flushed) {
                this.bufferCount = this.webServerHeaderSize + this.chunkSizeField.length;
            }
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        if (last) {
            HTTPWebStreamContentReader contentReader = (HTTPWebStreamContentReader)this.streamHandler.getContentReader();
            contentReader.setProcessing(false);
            ((NIOStreamHandlerImpl)this.streamHandler).addEventOp(1);
        }
        return flushed;
    }
}

