/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.engine.io.Http09OutputAdaptor;
import jeus.util.message.JeusMessage_WebContainer2;

public class NIOHttp09OutputAdaptor
extends Http09OutputAdaptor {
    public NIOHttp09OutputAdaptor(NIOWebServerOutputStream nioWebServerOutputStream, byte[] httpHeader, byte[] httpBody) {
        super(null, nioWebServerOutputStream, httpHeader, httpBody);
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        boolean flushed = false;
        try {
            logger.log(Level.FINE, "[NIOHttp09OutputAdaptor#internalFlush()] bufferCount = " + this.bufferCount);
            if (this.bufferCount > this.webServerHeaderSize || last) {
                this.webServer.setWebServerHeader(last, this.bufferCount, 0, this.httpBody);
                int writeTotalSize = 0;
                ByteBuffer buffer = null;
                if (this.bufferCount > 0) {
                    writeTotalSize = this.bufferCount;
                    buffer = this.streamHandler.createByteBuffer(writeTotalSize);
                    buffer.put(this.httpBody, 0, this.bufferCount);
                    this.streamHandler.write(buffer);
                }
                this.committed = true;
                flushed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
            }
            if (flushed) {
                this.bufferCount = this.webServerHeaderSize;
            }
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        return flushed;
    }
}

