/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import jeus.io.impl.StreamHandlerImpl;
import jeus.server.enginecontainer.InvocationManager;
import jeus.servlet.async.AbstractAsyncServlet;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.connection.SSLSupport;
import jeus.servlet.connector.AbstractTask;
import jeus.servlet.connector.ActiveConnectionClosedException;
import jeus.servlet.connector.MaxConnectionReachedException;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.RequestStatistic;
import jeus.servlet.connector.TaskContext;
import jeus.servlet.connector.WebThreadPoolManager;
import jeus.servlet.connector.protocol.tmax.TMAXServletRequestImpl;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.util.HttpVersionNotSupportedException;
import jeus.servlet.util.NotAllowedAddressException;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.AccessLogger;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;
import jeus.util.message.JeusMessage_WebContainer4;
import jeus.webservices.spi.EWSProvider;
import jeus.workarea.WorkAreaServiceHelper;

public abstract class ProcessorTask
extends AbstractTask {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    protected RequestStatistic requestStatistic;
    protected boolean async = false;
    protected ExecutionWrapper wrapper = null;
    protected HttpServletRequestImpl request;
    protected HttpServletResponseImpl response;
    private NIOWebServerOutputStream outputStream;
    private ContextGroup contextGroup;
    private AccessLogger accessLogger;
    private TaskContext taskContext;
    private boolean inKeepAliveProcess = false;
    private boolean datasourcePrepared = false;
    private boolean executionCompleted = false;
    private boolean requestPrepared = false;
    private Context ctx = null;
    private boolean isExecution = false;
    private boolean enableAccessControl;
    private Vector allowedServer;
    private boolean UsingUnavailMapping503 = false;
    private int outputBufferSize;

    public ProcessorTask() {
        this.setType(1);
    }

    public void init(ContextGroup contextGroup, WebThreadPoolManager poolManager) {
        if (contextGroup == null || poolManager == null) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10103_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10103_LEVEL, JeusMessage_WebContainer10._10103, new Object[]{contextGroup, poolManager});
            }
            return;
        }
        this.contextGroup = contextGroup;
        this.accessLogger = contextGroup.getAccessLogger();
        this.allowedServer = poolManager.getAllowedServer();
        this.enableAccessControl = poolManager.isEnableAccessControl();
        this.outputBufferSize = poolManager.getOutputBufferSize();
    }

    public void finish() {
        this.destroy();
        if (this.requestStatistic != null) {
            this.requestStatistic.reset();
            this.requestStatistic = null;
        }
        this.accessLogger = null;
        this.clearReqRes();
        if (this.outputStream != null) {
            this.outputStream.setStreamHandler(null);
            this.outputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doTask() throws IOException {
        block25: {
            block23: {
                this.initialize();
                if (this.connector != null && !this.connector.isPersistentConnection()) {
                    this.unsetKeepAlive();
                } else {
                    this.setKeepAlive();
                }
                if (this.startProcess()) break block23;
                this.unsetKeepAlive();
            }
            Object var3_1 = null;
            try {
                if (!this.async) {
                    if (!this.stopProcess()) {
                        this.unsetKeepAlive();
                    }
                    if (!this.isKeepAlive()) {
                        this.finishConnection();
                    }
                } else {
                    this.requestStatistic.setStep(8);
                    this.requestStatistic.updateCountersPerRequest();
                    long processingTime = this.requestStatistic.getProcessingTime();
                    this.incrementProcessingTime(processingTime);
                }
            }
            catch (Throwable tt) {
                tt.printStackTrace();
                this.finishConnection();
            }
            this.request = null;
            this.response = null;
            this.setTaskContext(null);
            this.connector.returnTask(this);
            {
                break block25;
                catch (Throwable t) {
                    this.unsetKeepAlive();
                    if (logger.isLoggable(JeusMessage_WebContainer10._10118_LEVEL)) {
                        logger.log(JeusMessage_WebContainer10._10118_LEVEL, JeusMessage_WebContainer10._10118, new Object[]{this.requestStatistic.getStringWorkerThreadID(), String.valueOf(this.requestStatistic.getStep())}, t);
                    }
                    Object var3_2 = null;
                    try {
                        if (!this.async) {
                            if (!this.stopProcess()) {
                                this.unsetKeepAlive();
                            }
                            if (!this.isKeepAlive()) {
                                this.finishConnection();
                            }
                        } else {
                            this.requestStatistic.setStep(8);
                            this.requestStatistic.updateCountersPerRequest();
                            long processingTime = this.requestStatistic.getProcessingTime();
                            this.incrementProcessingTime(processingTime);
                        }
                    }
                    catch (Throwable tt) {
                        tt.printStackTrace();
                        this.finishConnection();
                    }
                    this.request = null;
                    this.response = null;
                    this.setTaskContext(null);
                    this.connector.returnTask(this);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (!this.async) {
                        if (!this.stopProcess()) {
                            this.unsetKeepAlive();
                        }
                        if (!this.isKeepAlive()) {
                            this.finishConnection();
                        }
                    } else {
                        this.requestStatistic.setStep(8);
                        this.requestStatistic.updateCountersPerRequest();
                        long processingTime = this.requestStatistic.getProcessingTime();
                        this.incrementProcessingTime(processingTime);
                    }
                }
                catch (Throwable tt) {
                    tt.printStackTrace();
                    this.finishConnection();
                }
                this.request = null;
                this.response = null;
                this.setTaskContext(null);
                this.connector.returnTask(this);
                throw throwable;
            }
        }
    }

    private boolean startProcess() {
        this.requestStatistic.setStep(0);
        this.requestStatistic.setStringWorkerThreadID(Thread.currentThread().getName());
        this.executionCompleted = false;
        this.requestPrepared = false;
        this.ctx = null;
        this.isExecution = false;
        this.wrapper = null;
        StreamHandlerImpl streamHandler = this.getStreamHandlerImpl();
        if (streamHandler == null || this.outputStream == null) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10105_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10105_LEVEL, JeusMessage_WebContainer10._10105, new Object[]{this.requestStatistic.getStringWorkerThreadID(), streamHandler, this.outputStream});
            }
            return false;
        }
        this.outputStream.setStreamHandler(streamHandler);
        Socket socket = streamHandler.getSocket();
        if (socket == null) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10403_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10403_LEVEL, JeusMessage_WebContainer10._10403);
            }
            return false;
        }
        try {
            this.request.setSocketInfo(streamHandler.getSocket());
            this.request.setSocket(streamHandler.getSocket());
            this.response.setSocket(streamHandler.getSocket());
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10404_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10404_LEVEL, JeusMessage_WebContainer10._10404, (Throwable)e);
            }
            return false;
        }
        this.setSSLAttribute();
        this.requestStatistic.setProcessingTime(0L);
        this.requestStatistic.setStartTime(System.currentTimeMillis());
        this.request.setStartTime(this.requestStatistic.getStartTime());
        try {
            this.requestStatistic.setStep(1);
            this.readRequest(this.getTaskMessage());
        }
        catch (FileNotFoundException fne) {
            this.sendError(fne, null);
            return true;
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10404_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10404_LEVEL, JeusMessage_WebContainer10._10404, (Throwable)e);
            }
            return false;
        }
        catch (InterruptedException e) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10405_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10405_LEVEL, JeusMessage_WebContainer10._10405, (Throwable)e);
            }
            return false;
        }
        try {
            if (!this.contextGroup.getContainerManager().updateClientStats(this.request)) {
                this.response.sendError(403, "Licensed number of clients exceeds");
                return false;
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10404_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10404_LEVEL, JeusMessage_WebContainer10._10404, (Throwable)e);
            }
            return false;
        }
        this.requestStatistic.setStep(2);
        try {
            try {
                this.prepareRequest();
            }
            catch (HttpVersionNotSupportedException hvnse) {
                if (logger.isLoggable(JeusMessage_WebContainer4._4005_LEVEL)) {
                    logger.log(JeusMessage_WebContainer4._4005_LEVEL, JeusMessage_WebContainer4._4005, (Object)this.requestStatistic.getStringWorkerThreadID(), (Throwable)hvnse);
                }
                this.response.sendError(505);
                this.unsetKeepAlive();
                return false;
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_WebContainer4._4005_LEVEL)) {
                    logger.log(JeusMessage_WebContainer4._4005_LEVEL, JeusMessage_WebContainer4._4005, (Object)this.requestStatistic.getStringWorkerThreadID(), t);
                }
                this.response.sendError(400);
                this.unsetKeepAlive();
                return false;
            }
        }
        catch (Exception e) {
            this.unsetKeepAlive();
            return false;
        }
        this.requestPrepared = true;
        if (this.enableAccessControl) {
            try {
                this.requestStatistic.setStep(3);
                this.doSocketFilter(socket);
            }
            catch (NotAllowedAddressException naae) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10106_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10106_LEVEL, JeusMessage_WebContainer10._10106, (Object[])new String[]{this.requestStatistic.getStringWorkerThreadID(), socket.getInetAddress().getHostAddress()});
                }
                this.sendError(naae, null);
                return false;
            }
        }
        try {
            this.requestStatistic.setStep(4);
            this.doWorkRelatedReload();
        }
        catch (Throwable t) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10116, (Object)this.requestStatistic.getStringWorkerThreadID());
            if (logger.isLoggable(JeusMessage_WebContainer10._10400_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10400_LEVEL, msg, t);
            }
            this.sendError(t, msg);
            return true;
        }
        ExecutionWrapper wrapper = null;
        try {
            this.requestStatistic.setStep(5);
            wrapper = this.getExecutionWrapper();
        }
        catch (FileNotFoundException fne) {
            this.sendError(fne, null);
            return true;
        }
        catch (ServletException se) {
            this.sendError(se, null);
            return true;
        }
        try {
            if (!this.postRequest(wrapper)) {
                return true;
            }
        }
        catch (IOException e) {
            this.sendError(e, "IOException occurred");
            return false;
        }
        if (!(wrapper instanceof ServletWrapper) || wrapper instanceof JspServletWrapper) {
            this.async = false;
        } else {
            Servlet servlet = null;
            try {
                servlet = ((ServletWrapper)wrapper).getReloader().getServlet();
            }
            catch (ServletException se) {
                se.printStackTrace();
            }
            if (!(servlet instanceof AbstractAsyncServlet)) {
                this.async = false;
            } else {
                this.async = true;
                try {
                    if (this.request instanceof TMAXServletRequestImpl) {
                        ((TMAXServletRequestImpl)this.request).processAsyncRequest(streamHandler);
                    }
                }
                catch (Throwable t) {
                    logger.log(JeusMessage_WebContainer10._10417_LEVEL, JeusMessage_WebContainer10._10417, t);
                    return true;
                }
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer10._10401_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10401_LEVEL, JeusMessage_WebContainer10._10401, (Object)this.request.getRequestInfo());
        }
        try {
            this.requestStatistic.setStep(6);
            this.prepareDataSourceConnections();
            this.request.setDatasourcePrepared(true);
        }
        catch (Throwable t) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10117, (Object)this.requestStatistic.getStringWorkerThreadID());
            if (logger.isLoggable(JeusMessage_WebContainer10._10400_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10400_LEVEL, msg, t);
            }
            this.sendError(t, msg);
            return true;
        }
        try {
            this.requestStatistic.setStep(7);
            wrapper.execute(this.request, this.response);
        }
        catch (ServletException se) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10107, (Object)this.requestStatistic.getStringWorkerThreadID());
            if (logger.isLoggable(JeusMessage_WebContainer10._10400_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10400_LEVEL, msg, (Throwable)se);
            }
            this.sendError(se, msg);
            return true;
        }
        catch (IOException ie) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10107, (Object)this.requestStatistic.getStringWorkerThreadID());
            if (logger.isLoggable(JeusMessage_WebContainer10._10400_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10400_LEVEL, msg, (Throwable)ie);
            }
            this.sendError(ie, msg);
            return true;
        }
        this.executionCompleted = true;
        return true;
    }

    private boolean stopProcess() {
        boolean keepAlive;
        block29: {
            block28: {
                block27: {
                    long processingTime;
                    block26: {
                        this.requestStatistic.setStep(8);
                        this.requestStatistic.updateCountersPerRequest();
                        processingTime = this.requestStatistic.getProcessingTime();
                        keepAlive = this.isKeepAlive();
                        if (this.response.errorSent()) {
                            keepAlive = false;
                        }
                        if (this.executionCompleted) {
                            this.incrementProcessingTime(processingTime);
                        }
                        try {
                            this.requestStatistic.setStep(9);
                            this.request.postProcessSession();
                        }
                        catch (Throwable t) {
                            if (!logger.isLoggable(JeusMessage_WebContainer10._10108_LEVEL)) break block26;
                            logger.log(JeusMessage_WebContainer10._10108_LEVEL, JeusMessage_WebContainer10._10108, new Object[]{this.requestStatistic.getStringWorkerThreadID(), this.getStreamHandlerImpl()}, t);
                        }
                    }
                    try {
                        this.requestStatistic.setStep(10);
                        this.request.finish();
                        this.requestStatistic.setStep(11);
                        this.response.finish();
                        if (logger.isLoggable(JeusMessage_WebContainer10._10402_LEVEL)) {
                            logger.log(JeusMessage_WebContainer10._10402_LEVEL, JeusMessage_WebContainer10._10402, (Object)this.response.getResponseInfo());
                        }
                    }
                    catch (IOException ie) {
                        if (logger.isLoggable(JeusMessage_WebContainer10._10109_LEVEL)) {
                            logger.log(JeusMessage_WebContainer10._10109_LEVEL, JeusMessage_WebContainer10._10109, new Object[]{this.requestStatistic.getStringWorkerThreadID(), this.getStreamHandlerImpl()}, (Throwable)ie);
                        }
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(JeusMessage_WebContainer10._10110_LEVEL)) {
                            logger.log(JeusMessage_WebContainer10._10110_LEVEL, JeusMessage_WebContainer10._10110, new Object[]{this.requestStatistic.getStringWorkerThreadID(), this.getStreamHandlerImpl()}, t);
                        }
                        keepAlive = false;
                    }
                    if (this.requestPrepared && this.accessLogger != null && this.accessLogger.isLoggable(Level.INFO)) {
                        try {
                            this.requestStatistic.setStep(12);
                            this.accessLogger.log(this.request, this.response, processingTime);
                        }
                        catch (Throwable t) {
                            if (logger.isLoggable(JeusMessage_WebContainer10._10111_LEVEL)) {
                                logger.log(JeusMessage_WebContainer10._10111_LEVEL, JeusMessage_WebContainer10._10111, new Object[]{this.requestStatistic.getStringWorkerThreadID(), this.getStreamHandlerImpl()}, t);
                            }
                            keepAlive = false;
                        }
                    }
                    try {
                        this.requestStatistic.setStep(13);
                        this.finishWorkRelatedReload();
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(JeusMessage_WebContainer10._10119_LEVEL)) break block27;
                        logger.log(JeusMessage_WebContainer10._10119_LEVEL, JeusMessage_WebContainer10._10119, (Object)this.requestStatistic.getStringWorkerThreadID(), t);
                    }
                }
                try {
                    this.requestStatistic.setStep(14);
                    this.request.clearing();
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_WebContainer10._10112_LEVEL)) {
                        logger.log(JeusMessage_WebContainer10._10112_LEVEL, JeusMessage_WebContainer10._10112, (Object)this.requestStatistic.getStringWorkerThreadID(), t);
                    }
                    keepAlive = false;
                }
                try {
                    this.requestStatistic.setStep(15);
                    this.response.clearing();
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_WebContainer10._10113_LEVEL)) {
                        logger.log(JeusMessage_WebContainer10._10113_LEVEL, JeusMessage_WebContainer10._10113, (Object)this.requestStatistic.getStringWorkerThreadID(), t);
                    }
                    keepAlive = false;
                }
                this.requestPrepared = false;
                try {
                    this.requestStatistic.setStep(16);
                    this.doTransactionRollback();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_WebContainer10._10122_LEVEL)) break block28;
                    logger.log(JeusMessage_WebContainer10._10122_LEVEL, JeusMessage_WebContainer10._10122, (Object)this.requestStatistic.getStringWorkerThreadID(), t);
                }
            }
            try {
                this.requestStatistic.setStep(17);
                this.cleanupDataSourceConnections();
            }
            catch (Throwable t) {
                keepAlive = false;
                if (!logger.isLoggable(JeusMessage_WebContainer10._10114_LEVEL)) break block29;
                logger.log(JeusMessage_WebContainer10._10114_LEVEL, JeusMessage_WebContainer10._10114, (Object)this.requestStatistic.getStringWorkerThreadID(), t);
            }
        }
        this.requestStatistic.setStep(18);
        WorkAreaServiceHelper.clearUserWorkArea();
        this.requestStatistic.setStringWorkerThreadID(null);
        this.requestStatistic.setStep(19);
        return keepAlive;
    }

    public void finishConnection() {
        StreamHandlerImpl streamHandler = this.getStreamHandlerImpl();
        if (streamHandler != null) {
            streamHandler.close((Exception)new ActiveConnectionClosedException("connection closed by ProcessorTask"));
        }
        if (logger.isLoggable(JeusMessage_WebContainer10._10102_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10102_LEVEL, JeusMessage_WebContainer10._10102, (Object)(streamHandler != null ? streamHandler.toString() : "null"));
        }
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    protected StreamHandlerImpl getStreamHandlerImpl() {
        if (this.taskContext != null) {
            return this.taskContext.getStreamHandlerImpl();
        }
        return null;
    }

    public Object getTaskMessage() {
        if (this.taskContext != null) {
            return this.taskContext.getMessage();
        }
        return null;
    }

    public HttpServletRequestImpl getRequest() {
        return this.request;
    }

    public HttpServletResponseImpl getResponse() {
        return this.response;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    protected void prepareRequest() throws Exception {
        String protocol = this.request.getProtocol();
        if (protocol == null) {
            this.request.setProtocolInt(9);
        } else if (protocol.equals("HTTP/1.1")) {
            this.request.setProtocolInt(11);
        } else if (protocol.equals("HTTP/1.0")) {
            this.request.setProtocolInt(10);
        } else if (protocol.equals("HTTP/0.9")) {
            this.request.setProtocolInt(9);
        } else if (protocol.equals("")) {
            this.request.setProtocolInt(33);
        } else {
            this.request.setProtocolInt(0);
        }
        switch (this.request.getProtocolInt()) {
            case 11: {
                if (this.request.getHeader("host") == null) {
                    throw new Exception(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer4._4012, (Object)this.requestStatistic.getStringWorkerThreadID()));
                }
                this.setKeepAlive();
                break;
            }
            case 9: 
            case 10: 
            case 33: {
                this.unsetKeepAlive();
                break;
            }
            default: {
                throw new HttpVersionNotSupportedException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer4._4013, (Object)this.requestStatistic.getStringWorkerThreadID()));
            }
        }
        String connection = this.request.getHeader("Connection");
        if (connection != null) {
            if (connection.equals("close")) {
                this.request.setConnectionHeader(2);
            } else {
                this.request.setConnectionHeader(1);
            }
        } else {
            this.request.setConnectionHeader(0);
        }
    }

    private boolean postRequest(ExecutionWrapper wapper) throws IOException {
        String contextPath = this.request.getContextPath();
        if (contextPath != null && contextPath.equals(this.request.getRequestURI())) {
            this.sendRedirectWithSlash();
            return false;
        }
        if (wapper != null && wapper.isResourceServlet()) {
            File file;
            String path = this.request.getServletPath();
            Context context = this.request.getContext();
            if (context != null && path != null && !path.endsWith("/") && (file = new File(context.getCtxDocBase().getFile() + Context.normPath(path))).exists() && file.isDirectory()) {
                this.sendRedirectWithSlash();
                return false;
            }
        }
        return true;
    }

    private void sendRedirectWithSlash() throws IOException {
        StringBuffer redirectPath = this.request.getRequestURL();
        redirectPath.append('/');
        String query = this.request.getQueryString();
        if (query != null) {
            redirectPath.append('?').append(query);
        }
        this.response.sendRedirect(redirectPath.toString());
    }

    private ExecutionWrapper getExecutionWrapper() throws FileNotFoundException, ServletException {
        ExecutionWrapper wrapper = null;
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null && (wrapper = provider.getRegisteredEndpointWrapper(this.request)) != null) {
            return wrapper;
        }
        Context ctx = this.request.getContext();
        if (ctx == null) {
            throw new FileNotFoundException(this.request.getRequestURI());
        }
        wrapper = ctx.getServletByPath(this.request);
        return wrapper;
    }

    private final void prepareDataSourceConnections() {
        InvocationManager.preInvoke(true);
        this.datasourcePrepared = true;
    }

    private final void cleanupDataSourceConnections() {
        if (this.datasourcePrepared) {
            InvocationManager.postInvoke();
            this.datasourcePrepared = false;
        }
    }

    protected void unsetKeepAlive() {
        this.inKeepAliveProcess = false;
        this.response.unsetKeepAlive();
    }

    private void setKeepAlive() {
        this.inKeepAliveProcess = true;
        this.response.setKeepAlive();
    }

    private boolean isKeepAlive() {
        return this.inKeepAliveProcess;
    }

    private void doSocketFilter(Socket soc) throws NotAllowedAddressException {
        InetAddress inetAddr = soc.getInetAddress();
        String addr = inetAddr.getHostAddress();
        if (this.allowedServer.contains(addr)) {
            return;
        }
        byte[] elements = inetAddr.getAddress();
        int el1 = elements[0] < 0 ? 256 + elements[0] : elements[0];
        int el2 = elements[1] < 0 ? 256 + elements[1] : elements[1];
        int el3 = elements[2] < 0 ? 256 + elements[2] : elements[2];
        String part1 = String.valueOf(el1);
        String part2 = String.valueOf(el2);
        String part3 = String.valueOf(el3);
        StringBuffer netAddr = new StringBuffer(part1);
        netAddr.append(".").append(part2).append(".").append(part3).append(".*");
        addr = netAddr.toString();
        if (this.allowedServer.contains(addr)) {
            return;
        }
        netAddr.setLength(0);
        netAddr.append(part1).append(".").append(part2).append(".*.*");
        addr = netAddr.toString();
        if (this.allowedServer.contains(addr)) {
            return;
        }
        netAddr.setLength(0);
        netAddr.append(part1).append(".*.*.*");
        addr = netAddr.toString();
        if (this.allowedServer.contains(addr)) {
            return;
        }
        addr = inetAddr.getHostAddress();
        throw new NotAllowedAddressException(addr + ":Not allowed");
    }

    public void sendError(Throwable t, String msg) {
        block21: {
            if (logger.isLoggable(JeusMessage_WebContainer10._10101_LEVEL)) {
                if (t != null) {
                    logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg, t);
                } else {
                    logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg);
                }
            }
            if (t instanceof MaxConnectionReachedException) {
                return;
            }
            try {
                if (msg == null) {
                    msg = t.getMessage();
                }
                if (t instanceof FileNotFoundException) {
                    this.response.sendError(404, msg, t);
                } else if (t instanceof UnavailableException) {
                    if (this.UsingUnavailMapping503) {
                        this.response.sendError(503, msg, t);
                    } else {
                        this.response.sendError(404, msg, t);
                    }
                } else if (t instanceof ServletException) {
                    ServletException e = (ServletException)t;
                    Throwable rc = e.getRootCause();
                    if (rc != null && rc instanceof FileNotFoundException) {
                        this.response.sendError(404, msg, e);
                    } else {
                        this.response.sendError(500, msg, e);
                    }
                } else if (t instanceof NotAllowedAddressException) {
                    this.response.sendError(403, msg);
                } else if (t instanceof MaxConnectionReachedException) {
                    this.response.sendError(200, msg);
                } else {
                    this.response.sendError(500, msg, t);
                }
            }
            catch (Throwable tt) {
                if (!logger.isLoggable(JeusMessage_WebContainer10._10115_LEVEL)) break block21;
                logger.log(JeusMessage_WebContainer10._10115_LEVEL, JeusMessage_WebContainer10._10115, tt);
            }
        }
    }

    private void incrementProcessingTime(long processingTime) {
        Context ctx = this.request.getContext();
        if (ctx != null) {
            ctx.processingTime += processingTime;
        }
    }

    public RequestStatistic getRequestStatistic() {
        return this.requestStatistic;
    }

    public ThreadStateInfo getThreadState(int mode) {
        if (this.requestStatistic == null) {
            return new ThreadStateInfo("already destroyed thread", mode);
        }
        ThreadStateInfo threadInfo = new ThreadStateInfo(this.requestStatistic.getStringWorkerThreadID(), mode);
        threadInfo.alive = Thread.currentThread().isAlive();
        if (mode == ThreadStateInfo.GET_RUNNING_STATE) {
            threadInfo.active = this.requestPrepared;
            if (this.requestPrepared) {
                threadInfo.elapsedTime = this.requestStatistic.getProcessingTimeNow();
                threadInfo.runningApp = this.requestStatistic.getCurrentUri();
                threadInfo.qString = this.requestStatistic.getCurrentQueryString();
            } else {
                threadInfo.elapsedTime = this.requestStatistic.getProcessingTimeNow();
            }
        } else if (mode == ThreadStateInfo.GET_PROCESSING_INFO) {
            long avgProcTime = 0L;
            int requestCount = this.requestStatistic.getRequestCount();
            if (requestCount > 0) {
                avgProcTime = this.requestStatistic.getProcessingTime() / (long)requestCount;
            }
            long totalAvgProcTime = 0L;
            int totalRequestCount = this.requestStatistic.getTotalRequestCount();
            if (totalRequestCount > 0) {
                totalAvgProcTime = this.requestStatistic.getTotalProcessingTime() / (long)totalRequestCount;
            }
            threadInfo.requestCount = requestCount;
            threadInfo.avgProcTime = avgProcTime;
            threadInfo.totalRequestCount = totalRequestCount;
            threadInfo.totalAvgProcTime = totalAvgProcTime;
        } else if (mode == ThreadStateInfo.GET_ALL_INFO || mode == ThreadStateInfo.GET_ALL2_INFO) {
            threadInfo.active = this.requestPrepared;
            threadInfo.step = this.requestStatistic.getStep();
            if (this.requestPrepared) {
                threadInfo.elapsedTime = this.requestStatistic.getProcessingTimeNow();
                threadInfo.checkTime = this.requestStatistic.getStartTime();
                if (this.request != null) {
                    threadInfo.runningApp = this.request.getRequestURI();
                    threadInfo.qString = this.request.getQueryString();
                } else {
                    threadInfo.runningApp = "";
                    threadInfo.qString = "";
                }
            } else {
                threadInfo.elapsedTime = this.requestStatistic.getProcessingTimeNow();
                threadInfo.checkTime = this.requestStatistic.getStartTime();
            }
            long avgProcTime = 0L;
            int requestCount = this.requestStatistic.getRequestCount();
            if (requestCount > 0) {
                avgProcTime = this.requestStatistic.getMornitoringProcessingTime() / (long)requestCount;
            }
            long totalAvgProcTime = 0L;
            int totalRequestCount = this.requestStatistic.getTotalRequestCount();
            if (totalRequestCount > 0) {
                totalAvgProcTime = this.requestStatistic.getTotalProcessingTime() / (long)totalRequestCount;
            }
            threadInfo.requestCount = requestCount;
            threadInfo.avgProcTime = avgProcTime;
            threadInfo.totalRequestCount = totalRequestCount;
            threadInfo.totalAvgProcTime = totalAvgProcTime;
        }
        this.requestStatistic.updateCountersPerMornitoring();
        return threadInfo;
    }

    public boolean isRequestPrepared() {
        return this.requestPrepared;
    }

    protected void setSSLAttribute() {
        SSLSupport sslSupport = null;
        if (sslSupport == null) {
            return;
        }
        try {
            Object sslO = sslSupport.getCipherSuite();
            if (sslO != null) {
                this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
            }
            if ((sslO = sslSupport.getPeerCertificateChain(false)) != null) {
                this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
            }
            if ((sslO = sslSupport.getKeySize()) != null) {
                this.request.setAttribute("javax.servlet.request.key_size", sslO);
            }
            if ((sslO = sslSupport.getSessionId()) != null) {
                this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void doWorkRelatedReload() {
        this.ctx = this.request.getContext();
        if (this.ctx == null) {
            return;
        }
        ContextLoader contextLoader = this.ctx.getContextLoader();
        if (contextLoader != null && contextLoader.isReloadable() && contextLoader.isCheckOnDemand() && contextLoader.modified()) {
            this.ctx.execReload();
        }
        this.ctx.increaseExecutionThread();
        this.isExecution = true;
    }

    private void finishWorkRelatedReload() {
        if (this.ctx == null || !this.isExecution) {
            return;
        }
        this.ctx.decreaseExecutionThread();
        this.isExecution = false;
        this.ctx = null;
    }

    private void doTransactionRollback() throws SystemException {
        Transaction tx = null;
        try {
            tx = TxHelper.getTransactionManager().getTransaction();
            if (tx != null) {
                if (logger.isLoggable(JeusMessage_WebContainer10._10123_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10123_LEVEL, JeusMessage_WebContainer10._10123, (Object)this.requestStatistic.getStringWorkerThreadID());
                }
                tx.rollback();
            }
        }
        catch (SystemException e) {
            throw e;
        }
        finally {
            ThreadContexts.initNextTimeout();
        }
    }

    protected void initialize() {
        this.request = this.createRequest(this.contextGroup);
        this.requestStatistic = new RequestStatistic(this.request);
        this.outputStream = this.createOutputStream(this.outputBufferSize);
        this.response = this.createResponse(this.contextGroup, this.outputStream);
        this.request.setResponse(this.response);
        this.response.setRequest(this.request);
        this.outputStream.setRequestAndResponse(this.request, this.response);
        this.outputStream.setStreamHandler(null);
    }

    private void clearReqRes() {
        if (this.response != null) {
            this.response.setRequest(null);
            this.response = null;
        }
        if (this.request != null) {
            this.request.setResponse(null);
            this.request = null;
        }
    }

    protected abstract void readRequest(Object var1) throws IOException, InterruptedException;

    protected abstract HttpServletRequestImpl createRequest(ContextGroup var1);

    protected abstract HttpServletResponseImpl createResponse(ContextGroup var1, NIOWebServerOutputStream var2);

    protected abstract NIOWebServerOutputStream createOutputStream(int var1);

    protected abstract void destroy();
}

