/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import jeus.servlet.engine.HttpServletRequestImpl;

public class RequestStatistic {
    private HttpServletRequestImpl request;
    private int step = 0;
    private long startTime;
    private long totalProcessingTime;
    private long maxTime;
    private String maxRequestUri;
    private int requestCount;
    private int totalRequestCount;
    private int errorCount;
    private long count2xx;
    private long count3xx;
    private long count4xx;
    private long count5xx;
    private long countOther;
    private long count200;
    private long count302;
    private long count304;
    private long count400;
    private long count401;
    private long count403;
    private long count404;
    private long count503;
    private long workerThreadID = 0L;
    private String stringWorkerThreadID;
    private long processingTime;
    private long mornitoringProcessingTime;
    private String lastURI;
    private String lastMethod;
    private long lastCompletionTime;

    public RequestStatistic(HttpServletRequestImpl request) {
        this.request = request;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getCurrentUri() {
        return this.request.getRequestURI();
    }

    public String getCurrentQueryString() {
        return this.request.getQueryString();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long getProcessingTimeNow() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void updateCountersPerRequest() {
        ++this.requestCount;
        ++this.totalRequestCount;
        int responseStatus = this.request.getResponse().getStatus();
        if (responseStatus >= 200 && responseStatus < 299) {
            ++this.count2xx;
            if (responseStatus == 200) {
                ++this.count200;
            }
        } else if (responseStatus >= 300 && responseStatus < 399) {
            ++this.count3xx;
            if (responseStatus == 302) {
                ++this.count302;
            } else if (responseStatus == 304) {
                ++this.count304;
            }
        } else if (responseStatus >= 400 && responseStatus < 499) {
            ++this.count4xx;
            if (responseStatus == 400) {
                ++this.count400;
            } else if (responseStatus == 401) {
                ++this.count401;
            } else if (responseStatus == 403) {
                ++this.count403;
            } else if (responseStatus == 404) {
                ++this.count404;
            }
        } else if (responseStatus >= 500 && responseStatus < 599) {
            ++this.count5xx;
            if (responseStatus == 503) {
                ++this.count503;
            }
        } else {
            ++this.countOther;
        }
        if (responseStatus >= 400) {
            ++this.errorCount;
        }
        long t1 = System.currentTimeMillis();
        this.processingTime = t1 - this.startTime;
        this.mornitoringProcessingTime += this.processingTime;
        this.totalProcessingTime += this.processingTime;
        if (this.maxTime < this.processingTime) {
            this.maxTime = this.processingTime;
            this.maxRequestUri = this.request.getRequestURI();
        }
        this.lastURI = this.request.getRequestURI();
        this.lastMethod = this.request.getMethod();
        this.lastCompletionTime = t1;
    }

    public void updateCountersPerMornitoring() {
        this.setRequestCount(0);
        this.setMornitoringProcessingTime(0L);
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    public void setTotalProcessingTime(long totalProcessingTime) {
        this.totalProcessingTime = totalProcessingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public String getMaxRequestUri() {
        return this.maxRequestUri;
    }

    public void setMaxRequestUri(String maxRequestUri) {
        this.maxRequestUri = maxRequestUri;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public long getCount2xx() {
        return this.count2xx;
    }

    public void setCount2xx(long count2xx) {
        this.count2xx = count2xx;
    }

    public long getCount3xx() {
        return this.count3xx;
    }

    public void setCount3xx(long count3xx) {
        this.count3xx = count3xx;
    }

    public long getCount4xx() {
        return this.count4xx;
    }

    public void setCount4xx(long count4xx) {
        this.count4xx = count4xx;
    }

    public long getCount5xx() {
        return this.count5xx;
    }

    public void setCount5xx(long count5xx) {
        this.count5xx = count5xx;
    }

    public long getCountOther() {
        return this.countOther;
    }

    public void setCountOther(long countOther) {
        this.countOther = countOther;
    }

    public long getCount200() {
        return this.count200;
    }

    public void setCount200(long count200) {
        this.count200 = count200;
    }

    public long getCount302() {
        return this.count302;
    }

    public void setCount302(long count302) {
        this.count302 = count302;
    }

    public long getCount304() {
        return this.count304;
    }

    public void setCount304(long count304) {
        this.count304 = count304;
    }

    public long getCount400() {
        return this.count400;
    }

    public void setCount400(long count400) {
        this.count400 = count400;
    }

    public long getCount401() {
        return this.count401;
    }

    public void setCount401(long count401) {
        this.count401 = count401;
    }

    public long getCount403() {
        return this.count403;
    }

    public void setCount403(long count403) {
        this.count403 = count403;
    }

    public long getCount404() {
        return this.count404;
    }

    public void setCount404(long count404) {
        this.count404 = count404;
    }

    public long getCount503() {
        return this.count503;
    }

    public void setCount503(long count503) {
        this.count503 = count503;
    }

    public long getWorkerThreadID() {
        return this.workerThreadID;
    }

    public String getStringWorkerThreadID() {
        return this.stringWorkerThreadID;
    }

    public void setWorkerThreadID(long workerThreadID) {
        this.workerThreadID = workerThreadID;
    }

    public void setStringWorkerThreadID(String stringWorkerThreadID) {
        this.stringWorkerThreadID = stringWorkerThreadID;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public String getLastRequestURI() {
        return this.lastURI;
    }

    public String getLastRequestMethod() {
        return this.lastMethod;
    }

    public long getLastRequestCompletionTime() {
        return this.lastCompletionTime;
    }

    public void reset() {
        this.setTotalProcessingTime(0L);
        this.setMaxTime(0L);
        this.setMaxRequestUri(null);
        this.setRequestCount(0);
        this.setMornitoringProcessingTime(0L);
        this.setErrorCount(0);
        this.setCount2xx(0L);
        this.setCount3xx(0L);
        this.setCount4xx(0L);
        this.setCount5xx(0L);
        this.setCountOther(0L);
        this.setCount200(0L);
        this.setCount302(0L);
        this.setCount304(0L);
        this.setCount400(0L);
        this.setCount401(0L);
        this.setCount403(0L);
        this.setCount404(0L);
        this.setCount503(0L);
        this.setWorkerThreadID(0L);
        this.setStringWorkerThreadID(null);
        this.setProcessingTime(0L);
        this.setStartTime(0L);
        this.lastMethod = null;
        this.lastURI = null;
        this.lastCompletionTime = 0L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public long getMornitoringProcessingTime() {
        return this.mornitoringProcessingTime;
    }

    public void setMornitoringProcessingTime(long mornitoringProcessingTime) {
        this.mornitoringProcessingTime = mornitoringProcessingTime;
    }
}

