/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.net.Socket;
import jeus.io.Selector;
import jeus.servlet.connector.Acceptor;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.tcp.ConnectionHandshaker;
import jeus.util.message.JeusMessage_WebContainer10;
import jeus.util.message.JeusMessage_WebContainer2;

public class TcpAcceptor
extends Acceptor {
    boolean isLicensedClientCheckNeeded = false;

    public TcpAcceptor(WebConnector connector, Selector jeusSelector, boolean useSSL) {
        super(connector, jeusSelector, useSSL);
        if (connector.contextGroup.getContainerManager().getLicensedClientNum() > 0) {
            this.isLicensedClientCheckNeeded = true;
        }
    }

    protected boolean onSocketHook(Socket socket) {
        ConnectionHandshaker handshaker;
        if (this.isLicensedClientCheckNeeded) {
            String remoteAddr = socket.getInetAddress().getHostAddress();
            if (!this.connector.contextGroup.getContainerManager().updateClientStats(remoteAddr)) {
                block8: {
                    try {
                        logger.log(JeusMessage_WebContainer2._3487_LEVEL, JeusMessage_WebContainer2._3487, (Object)remoteAddr);
                        socket.close();
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(JeusMessage_WebContainer10._10232_LEVEL)) break block8;
                        logger.log(JeusMessage_WebContainer10._10232_LEVEL, JeusMessage_WebContainer10._10232, (Object)socket, (Throwable)e);
                    }
                }
                return false;
            }
        }
        if ((handshaker = this.connector.getHandshaker()) != null && !handshaker.doHandshake(socket)) {
            block9: {
                if (logger.isLoggable(JeusMessage_WebContainer10._10231_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10231_LEVEL, JeusMessage_WebContainer10._10231, (Object)socket);
                }
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(JeusMessage_WebContainer10._10232_LEVEL)) break block9;
                    logger.log(JeusMessage_WebContainer10._10232_LEVEL, JeusMessage_WebContainer10._10232, (Object)socket, (Throwable)ioe);
                }
            }
            return false;
        }
        return true;
    }
}

