/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import jeus.servlet.async.AbstractTcpAsyncServlet;
import jeus.servlet.async.FutureServletResponse;
import jeus.servlet.connector.MaxConnectionReachedException;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.protocol.http.HTTPMessage;
import jeus.servlet.connector.protocol.http.HTTPOutputStream;
import jeus.servlet.connector.protocol.http.HTTPServletRequestImpl;
import jeus.servlet.connector.protocol.http.HTTPServletResponseImpl;
import jeus.servlet.connector.protocol.tcp.TCPProcessorTask;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.util.NotAllowedAddressException;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer10;

public class HTTPProcessorTask
extends TCPProcessorTask {
    ContextGroup contextGroup;

    protected HttpServletRequestImpl createRequest(ContextGroup contextGroup) {
        return new HTTPServletRequestImpl(contextGroup, null);
    }

    protected HttpServletResponseImpl createResponse(ContextGroup contextGroup, NIOWebServerOutputStream outputStream) {
        return new HTTPServletResponseImpl(contextGroup, outputStream);
    }

    protected NIOWebServerOutputStream createOutputStream(int bufferSize) {
        return new HTTPOutputStream(bufferSize);
    }

    protected void destroy() {
    }

    public void readRequest(Object message) throws IOException, InterruptedException {
        if (message == null || !(message instanceof HTTPMessage)) {
            IOException ie = new IOException("message type is not instance of HTTPMessage");
            if (logger.isLoggable(JeusMessage_WebContainer10._10122_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10122_LEVEL, JeusMessage_WebContainer10._10122, (Object)this.requestStatistic.getStringWorkerThreadID(), (Throwable)ie);
            }
            throw ie;
        }
        if (!(this.request instanceof HTTPServletRequestImpl)) {
            IOException ie = new IOException("request type is not instance of HTTPServletRequestImpl");
            if (logger.isLoggable(JeusMessage_WebContainer10._10122_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10122_LEVEL, JeusMessage_WebContainer10._10122, (Object)this.requestStatistic.getStringWorkerThreadID(), (Throwable)ie);
            }
            throw ie;
        }
        HTTPServletRequestImpl httpRequest = (HTTPServletRequestImpl)this.request;
        HTTPServletResponseImpl httpResponse = (HTTPServletResponseImpl)this.response;
        HTTPMessage httpMsg = (HTTPMessage)message;
        httpRequest.setHeaderLength(httpMsg.getHeaderLength());
        httpRequest.setHeader(httpMsg.getHeader());
        httpRequest.setBody(httpMsg.getBody());
        httpRequest.setContentLength(httpMsg.getContentLength());
        String requestURI = httpMsg.getContextPath();
        httpRequest.setRequestURI(requestURI);
        httpRequest.setQueryString(httpMsg.getQueryString());
        httpRequest.setSSL(httpMsg.isSSL());
        httpRequest.setMethod(httpMsg.getMethod());
        httpRequest.setProtocol(httpMsg.getProtocol());
        httpRequest.setHeaders(httpMsg.getHeaders());
        httpRequest.setBlockingMode(httpMsg.getBlockingMode());
        httpRequest.setChunkedMode(httpMsg.getChunkedMode());
        httpRequest.setSelector(httpMsg.getSelector());
        httpRequest.setStreamHandler(httpMsg.getStreamHandler());
        httpRequest.processCommonRequest(requestURI, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(Throwable t, String msg) {
        block31: {
            if (logger.isLoggable(JeusMessage_WebContainer10._10101_LEVEL)) {
                if (t != null) {
                    logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg, t);
                } else {
                    logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg);
                }
            }
            if (!this.async) {
                try {
                    if (msg == null) {
                        msg = t.getMessage();
                    }
                    if (t instanceof FileNotFoundException) {
                        this.response.sendError(404, msg, t);
                        break block31;
                    }
                    if (t instanceof UnavailableException) {
                        boolean UsingUnavailMapping503 = false;
                        if (UsingUnavailMapping503) {
                            this.response.sendError(503, msg, t);
                        } else {
                            this.response.sendError(404, msg, t);
                        }
                        break block31;
                    }
                    if (t instanceof ServletException) {
                        ServletException e = (ServletException)t;
                        Throwable rc = e.getRootCause();
                        if (rc != null && rc instanceof FileNotFoundException) {
                            this.response.sendError(404, msg, e);
                        } else {
                            this.response.sendError(500, msg, e);
                        }
                        break block31;
                    }
                    if (t instanceof NotAllowedAddressException) {
                        this.response.sendError(403, msg);
                        break block31;
                    }
                    if (t instanceof MaxConnectionReachedException) {
                        this.response.sendError(200, msg);
                        break block31;
                    }
                    this.response.sendError(500, msg, t);
                }
                catch (Throwable tt) {
                    if (logger.isLoggable(JeusMessage_WebContainer10._10115_LEVEL)) {
                        logger.log(JeusMessage_WebContainer10._10115_LEVEL, JeusMessage_WebContainer10._10115, tt);
                    }
                    break block31;
                }
            }
            if (this.wrapper == null) {
                this.finishConnection();
            } else {
                ServletWrapper executionWrapper = (ServletWrapper)this.wrapper;
                String servletName = executionWrapper.getServletName();
                WebAppContextSwitch.preContextSwitch(executionWrapper.getReloader());
                try {
                    Servlet copy = null;
                    try {
                        this.requestStatistic.setStep(7);
                        copy = executionWrapper.getReloader().getServlet();
                        if (copy instanceof AbstractTcpAsyncServlet) {
                            ((AbstractTcpAsyncServlet)copy).sendError(t, msg, (ServletRequest)this.request, (ServletResponse)this.response);
                            ((FutureServletResponse)((Object)this.response)).send();
                        } else {
                            this.finishConnection();
                        }
                        if (copy != null) {
                            executionWrapper.getReloader().putServlet(copy);
                        }
                    }
                    catch (Throwable t2) {
                        try {
                            String msg2 = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10115, (Object)servletName);
                            logger.log(JeusMessage_WebContainer10._10115_LEVEL, msg2, t2);
                            this.finishConnection();
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (copy != null) {
                                executionWrapper.getReloader().putServlet(copy);
                            }
                        }
                    }
                }
                finally {
                    WebAppContextSwitch.postContextSwitch();
                }
            }
        }
    }

    public void prepareRequest() throws Exception {
        super.prepareRequest();
    }
}

