/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import jeus.io.Selector;
import jeus.io.impl.StreamHandlerImpl;
import jeus.servlet.connector.protocol.http.CombinedInputStream;
import jeus.servlet.connector.protocol.http.HTTPWebStreamContentReader;
import jeus.servlet.connector.protocol.tcp.TCPServletRequestImpl;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.engine.ServletInputStreamImpl;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.io.ChunkedInputStream;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class HTTPServletRequestImpl
extends TCPServletRequestImpl {
    private boolean SSL = false;
    private static final int MAX_REQUEST_LINES = 64;
    private Selector selector;
    private StreamHandlerImpl streamHandler;
    private boolean inputStreamSet;
    protected boolean chunkedMode;

    public HTTPServletRequestImpl(ContextGroup ctxGroup, ThreadPoolManager manager) {
        super(ctxGroup, manager);
    }

    final void setSSL(boolean flag) {
        this.SSL = flag;
    }

    public int readRequest(int readTimeout, int postdataReadTimeout) throws IOException {
        return 0;
    }

    public void setHeaderLength(int headerLength) {
        this.headerLength = headerLength;
    }

    public void finish() {
        this.putInputStream();
    }

    public String getRequestInfo() {
        String servletName = "unknown";
        if (this.wrapper != null) {
            servletName = this.wrapper.getClassName();
        }
        return "request from " + this.getRemoteAddr() + ":" + this.getRemotePort() + ". servlet = " + servletName + ", hdrlen = " + this.headerLength + ", bodylen = " + this.contentLength;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3422);
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        if (this.inputStreamSet) {
            return this.in;
        }
        if (this.blockingMode) {
            while (!((HTTPWebStreamContentReader)this.streamHandler.getContentReader()).isBlockingEnabled()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.inputStreamSet = true;
        if (this.bodyMessage != null) {
            InputStream frontInputStream = this.bodyMessage.getInputStream();
            CombinedInputStream combinedInputStream = new CombinedInputStream();
            combinedInputStream.setInputStream(frontInputStream, this.in.getInputStream());
            combinedInputStream.setBlockingMode(this.blockingMode);
            combinedInputStream.setContentLength(this.contentLength);
            combinedInputStream.setFrontInputStreamSize(this.bodyMessage.getMessage().length);
            if (this.chunkedMode) {
                this.in = new ServletInputStreamImpl(combinedInputStream);
                this.in = new ChunkedInputStream(this.in.getInputStream());
                return this.in;
            }
            this.in = new ServletInputStreamImpl(combinedInputStream);
            return this.in;
        }
        if (this.chunkedMode) {
            this.in = new ChunkedInputStream(this.in.getInputStream());
        }
        return this.in;
    }

    public ServletInputStream getInputStreamInternal() throws IOException {
        if (this.inputStreamSet) {
            return this.in;
        }
        if (this.blockingMode) {
            while (!((HTTPWebStreamContentReader)this.streamHandler.getContentReader()).isBlockingEnabled()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.inputStreamSet = true;
        if (this.bodyMessage != null) {
            InputStream frontInputStream = this.bodyMessage.getInputStream();
            CombinedInputStream combinedInputStream = new CombinedInputStream();
            combinedInputStream.setInputStream(frontInputStream, this.in.getInputStream());
            combinedInputStream.setBlockingMode(this.blockingMode);
            combinedInputStream.setContentLength(this.contentLength);
            combinedInputStream.setFrontInputStreamSize(this.bodyMessage.getMessage().length);
            this.in = new ServletInputStreamImpl(combinedInputStream);
            return this.in;
        }
        return this.in;
    }

    public String getCharacterEncoding() {
        boolean useContextEncoding = false;
        String tempForcedRequestEncoding = null;
        String tempDefaultRequestEncoding = null;
        if (this.context.getForcedRequestEncoding() != null) {
            tempForcedRequestEncoding = this.context.getForcedRequestEncoding();
        } else if (this.context.getDefaultRequestEncoding() != null) {
            tempDefaultRequestEncoding = this.context.getDefaultRequestEncoding();
        } else if (this.forcedRequestEncoding != null) {
            tempForcedRequestEncoding = this.forcedRequestEncoding;
        } else if (this.defaultRequestEncoding != null) {
            tempDefaultRequestEncoding = this.defaultRequestEncoding;
        }
        if (this.userPostdataEncoding != null) {
            return this.userPostdataEncoding;
        }
        if (tempForcedRequestEncoding != null) {
            return tempForcedRequestEncoding;
        }
        if (this.charsetResolvedFromContentType != null) {
            return this.charsetResolvedFromContentType;
        }
        if (this.charsetResolvedFromAcceptLanguage != null) {
            return this.charsetResolvedFromAcceptLanguage;
        }
        if (tempDefaultRequestEncoding != null) {
            return tempDefaultRequestEncoding;
        }
        return null;
    }

    public void readRequest0(StreamHandlerImpl streamHandlerImpl) {
    }

    public void setHeaders(Hashtable[] headers) {
        this.headers = headers[0];
        this.headers2 = headers[1];
        this.headers3 = headers[2];
    }

    public String getParameter(String name) {
        this.handleQueryString();
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        this.handlePostData();
        values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        this.handleParameters();
        return (String[])this.parameters.get(name);
    }

    public Enumeration getParameterNames() {
        this.handleParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map getParameterMap() {
        this.handleParameters();
        return (Map)this.parameters.clone();
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        WebProperties props = PropertyUtil.getContextProperties();
        if (!this.didCookies) {
            this.didCookies = true;
            String encoding = props.REQUEST_COOKIE_ENCODING.value;
            if (encoding == null) {
                encoding = this.getRequestEncoding();
            }
            RequestUtil.processCookies(this, this.cookies, encoding);
        }
        if (this.cookies.size() <= 0 && WebProperties.J2EE_COMPATIBLE.value) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[this.cookies.size()];
        for (int i = 0; i < this.cookies.size(); ++i) {
            cookieArray[i] = (Cookie)this.cookies.elementAt(i);
        }
        return cookieArray;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = (String)this.headers2.get("content-type");
        return this.contentType;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setStreamHandler(StreamHandlerImpl streamHandler) {
        this.streamHandler = streamHandler;
    }

    public StreamHandlerImpl getStreamHandler() {
        return this.streamHandler;
    }

    public void setChunkedMode(boolean chunkedMode) {
        this.chunkedMode = chunkedMode;
    }
}

