/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.http;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jeus.servlet.async.FutureServletResponse;
import jeus.servlet.connector.protocol.tcp.TCPServletResponseImpl;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.RequestDispatcherImpl;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.filter.FilterFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class HTTPServletResponseImpl
extends TCPServletResponseImpl
implements FutureServletResponse {
    public HTTPServletResponseImpl(ContextGroup ctxGroup, WebServerOutputStream out) {
        super(ctxGroup, out);
    }

    public void clearing(boolean socketReused) {
        super.clearing();
    }

    public void send() throws IOException {
        ProtocolOutputAdaptor adaptor = this.out.getAdaptor();
        logger.log(Level.FINE, "[connector.protocol.http.HTTPServletResponseImpl] adaptor = " + adaptor);
        if (adaptor == null) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3612_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3612_LEVEL, JeusMessage_WebContainer2._3612);
            }
            this.out.selectOutputAdaptor();
            adaptor = this.out.getAdaptor();
        }
        adaptor.internalFlush(true, true);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.sendRedirected || this.included != null) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3469));
        }
        this.out.reset();
        this.swriter.clear();
        this.setStatus(302);
        this.setContentType("text/html");
        location = this.makeAbsolute(location);
        this.setHeader("Location", location);
        StringBuffer buf = new StringBuffer();
        buf.append("<head><title>Document moved</title>");
        buf.append("<!--style> <H1 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Courier,Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Courier,Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Courier,Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}></style-->\r\n");
        buf.append("</head>\r\n");
        buf.append("<body><h1>Document moved</h1>\r\n");
        buf.append("This document has moved <a href=\"");
        buf.append(location);
        buf.append("\">here</a>.<p>\r\n");
        buf.append("</body>\r\n");
        this.sendBodyText(buf.toString());
        this.sendRedirected = true;
        this.flushBuffer();
        this.close();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.included != null) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3470));
        }
        this.accessLogStatus = sc;
        this.errorSent = true;
        this.status = sc;
        Context context = this.request.getContext();
        if (context == null) {
            this.printErrorToBrowser(sc, msg, true);
            this.flushBuffer();
            this.close();
            return;
        }
        String path = null;
        if (!this.isErrorPage) {
            path = context.getErrorPage(String.valueOf(sc), null);
        }
        if (path != null) {
            this.isErrorPage = true;
            RequestDispatcher rd = context.getRequestDispatcher(path);
            this.request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.ERROR_INTEGER);
            this.request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", ((RequestDispatcherImpl)rd).getPath());
            this.request.setAttribute("javax.servlet.error.status_code", new Integer(sc));
            this.request.setAttribute("javax.servlet.error.message", msg);
            this.request.setAttribute("javax.servlet.error.request_uri", this.request.getRequestURI());
            String servletName = null;
            ExecutionWrapper wrapper = this.request.getExecutionWrapper();
            if (wrapper != null) {
                servletName = wrapper.getName();
            }
            if (servletName != null) {
                this.request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            try {
                this.reset();
                this.status = sc;
                rd.forward((ServletRequest)this.request, (ServletResponse)this);
            }
            catch (IllegalStateException ise) {
                try {
                    rd.include((ServletRequest)this.request, (ServletResponse)this);
                }
                catch (ServletException se) {
                    this.printErrorToBrowser(sc, msg, true);
                }
            }
            catch (ServletException se) {
                this.printErrorToBrowser(sc, msg, true);
            }
        } else {
            this.printErrorToBrowser(sc, msg, true);
        }
        this.flushBuffer();
        this.close();
    }

    public void sendError(int sc, String msg, Throwable t) throws IOException {
        if (this.included != null) {
            return;
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3470));
        }
        this.accessLogStatus = sc;
        this.errorSent = true;
        this.status = sc;
        Context context = this.request.getContext();
        if (context == null) {
            this.printErrorToBrowser(sc, msg, t);
            this.flushBuffer();
            this.close();
            return;
        }
        String path = null;
        if (!this.isErrorPage) {
            path = context.getErrorPage(String.valueOf(sc), t);
        }
        if (path != null) {
            this.isErrorPage = true;
            RequestDispatcher rd = context.getRequestDispatcher(path);
            this.request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.ERROR_INTEGER);
            this.request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", ((RequestDispatcherImpl)rd).getPath());
            this.request.setAttribute("javax.servlet.error.status_code", new Integer(sc));
            if (t != null) {
                if (t instanceof ServletException) {
                    Throwable t2 = ((ServletException)t).getRootCause();
                    if (t2 != null) {
                        this.request.setAttribute("javax.servlet.error.exception_type", t2.getClass());
                        this.request.setAttribute("javax.servlet.error.exception", t2);
                        this.request.setAttribute("javax.servlet.error.message", t2.getMessage());
                    } else {
                        this.request.setAttribute("javax.servlet.error.exception_type", t.getClass());
                        this.request.setAttribute("javax.servlet.error.exception", t);
                        this.request.setAttribute("javax.servlet.error.message", msg);
                    }
                } else {
                    this.request.setAttribute("javax.servlet.error.exception_type", t.getClass());
                    this.request.setAttribute("javax.servlet.error.exception", t);
                    this.request.setAttribute("javax.servlet.error.message", msg);
                }
            }
            this.request.setAttribute("javax.servlet.error.request_uri", this.request.getRequestURI());
            String servletName = null;
            ExecutionWrapper wrapper = this.request.getExecutionWrapper();
            if (wrapper != null) {
                servletName = wrapper.getName();
            }
            if (servletName != null) {
                this.request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            try {
                this.reset();
                this.status = sc;
                rd.forward((ServletRequest)this.request, (ServletResponse)this);
            }
            catch (IllegalStateException ise) {
                try {
                    rd.include((ServletRequest)this.request, (ServletResponse)this);
                }
                catch (ServletException se) {
                    this.printErrorToBrowser(sc, msg, t);
                }
            }
            catch (ServletException se) {
                this.printErrorToBrowser(sc, msg, t);
            }
        } else {
            this.printErrorToBrowser(sc, msg, t);
        }
        this.flushBuffer();
        this.close();
    }
}

