/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.tmax;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.WebThreadPoolManager;
import jeus.servlet.connector.protocol.tmax.TMAXProcessorTask;
import jeus.servlet.connector.protocol.tmax.TMAXWebConnector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.io.TmaxHeader;
import jeus.servlet.engine.io.TmaxUtil;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;
import jeus.util.message.JeusMessage_WebContainer4;

public class TMAXWebConnectorManager
extends WebConnector
implements Runnable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    private TCPDispatcherConfig dispatcherConfig;
    private ClassLoader classLoader = JeusRootClassLoader.loader;
    protected static int RECONNECT_INTERVAL = 5000;
    private static String DEFAULT_RECONNECT_TIMEOUT = "120000";
    private int spri;
    private int clhCount;
    private int cpcCount;
    private int[] clhPort;
    private int procType;
    private int clid;
    private int domainid;
    private XAResource xar;
    private TMMHandlerNio tmmHandler;
    private TMAXWebConnector[] poolManager;
    private Vector addedPools = new Vector();
    private Object lock = new Object();
    private boolean running = false;
    private boolean reconnecting = false;
    private Thread thread = null;
    private ConnectionDescriptor backupDesc;
    private ConnectionDescriptor connDesc;
    private boolean isBackup = false;
    private boolean httpGW = false;
    private String recoverConnector = null;
    protected String name;
    protected int port = -1;

    public TMAXWebConnectorManager(ContextGroup contextGroup, ConnectionDescriptor connDesc) {
        this.port = connDesc.getPort();
        this.name = connDesc.getListenerId() + "(" + this.port + ")";
        this.contextGroup = contextGroup;
        this.connDesc = connDesc;
        String dispatcherConfigClass = connDesc.getDispatcherConfigClass();
        if (dispatcherConfigClass == null) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10200_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10200_LEVEL, JeusMessage_WebContainer10._10200, (Object)this.name);
            }
            return;
        }
        try {
            Class<?> klass = this.classLoader.loadClass(dispatcherConfigClass);
            this.dispatcherConfig = (TCPDispatcherConfig)klass.newInstance();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10201_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10201_LEVEL, JeusMessage_WebContainer10._10201, new Object[]{this.name, dispatcherConfigClass}, t);
            }
            return;
        }
    }

    public void init() throws StartingException {
        this.initialize();
    }

    public WebThreadPoolManager[] getThreadPoolManagers() {
        WebThreadPoolManager[] threadPoolManager = null;
        return threadPoolManager;
    }

    public void finish() {
        this.destroy();
        if (this.pipelineStat != null) {
            this.pipelineStat.finish();
            this.pipelineStat = null;
        }
        for (int i = 0; i < this.poolManager.length; ++i) {
            if (this.poolManager[i] == null) continue;
            this.poolManager[i].destroy();
            this.poolManager[i] = null;
        }
        this.contextGroup = null;
        this.port = -1;
        this.name = "";
    }

    public void initialize() throws StartingException {
        if (this.dispatcherConfig == null) {
            StartingException se = new StartingException("tmax dispatcher config class must be initialized");
            if (logger.isLoggable(JeusMessage_WebContainer10._10202_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10202_LEVEL, JeusMessage_WebContainer10._10202, (Object)this.name, (Throwable)((Object)se));
            }
            throw se;
        }
        try {
            block8: {
                this.dispatcherConfig.init();
                this.tmmHandler = new TMMHandlerNio();
                try {
                    this.tmmHandler.connect(this.connDesc);
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(JeusMessage_WebContainer4._4050_LEVEL)) break block8;
                    logger.log(JeusMessage_WebContainer4._4050_LEVEL, JeusMessage_WebContainer4._4050);
                }
            }
            this.running = true;
            this.thread = new Thread(this);
            this.thread.setName(this.getCurrentConnectionDescriptor().getListenerId() + "-tmm-connector");
            this.thread.start();
            this.poolManager = new TMAXWebConnector[this.clhCount * 2];
            for (int i = 0; i < this.clhCount; ++i) {
                ConnectionDescriptor tmaxConnDesc = this.getCurrentConnectionDescriptor();
                this.poolManager[i * 2] = new TMAXWebConnector(this.contextGroup, this, tmaxConnDesc, i, "-read");
                this.poolManager[i * 2].init();
                this.poolManager[i * 2 + 1] = new TMAXWebConnector(this.contextGroup, this, tmaxConnDesc, i, "-write");
                this.poolManager[i * 2 + 1].setOutChannel(true);
                this.poolManager[i * 2 + 1].init();
                this.poolManager[i * 2].setPairConnector(this.poolManager[i * 2 + 1]);
                this.poolManager[i * 2 + 1].setPairConnector(this.poolManager[i * 2]);
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10202_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10202_LEVEL, JeusMessage_WebContainer10._10202, (Object)this.name, t);
            }
            throw new StartingException(t);
        }
    }

    public void destroy() {
        this.dispatcherConfig = null;
        this.running = false;
    }

    public ProcessorTask newProcessorTask() {
        return new TMAXProcessorTask();
    }

    private void reconnectTMM() {
    }

    public void run() {
        if (!this.tmmHandler.isConnected()) {
            this.reconnectTMM();
        }
        while (this.running) {
            try {
                int msgtype = this.tmmHandler.handleRequest();
                if (msgtype != 108 || !this.running) continue;
                this.reconnectTMM();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(JeusMessage_WebContainer4._4051_LEVEL)) {
                    logger.log(JeusMessage_WebContainer4._4051_LEVEL, JeusMessage_WebContainer4._4051, (Object)Thread.currentThread().getName(), (Throwable)ioe);
                }
                if (!this.running) continue;
                this.reconnectTMM();
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_WebContainer4._4052_LEVEL)) {
                    logger.log(JeusMessage_WebContainer4._4052_LEVEL, JeusMessage_WebContainer4._4052, (Object)Thread.currentThread().getName(), t);
                }
                if (!this.running) continue;
                this.reconnectTMM();
            }
        }
    }

    public ConnectionDescriptor getCurrentConnectionDescriptor() {
        if (this.isBackup) {
            return this.backupDesc;
        }
        return this.connDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClhCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.clhCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClhPort(int clhId) {
        Object object = this.lock;
        synchronized (object) {
            return this.clhPort[clhId];
        }
    }

    public TCPDispatcherConfig getDispatcherConfig() {
        return this.dispatcherConfig;
    }

    public int getSpri() {
        return this.spri;
    }

    public int getClid() {
        return this.clid;
    }

    public boolean isHttpGW() {
        return this.httpGW;
    }

    static /* synthetic */ int[] access$902(TMAXWebConnectorManager x0, int[] x1) {
        x0.clhPort = x1;
        return x1;
    }

    private class TMMHandlerNio {
        private boolean connected = false;
        private Socket socket;
        private InputStream in;
        private OutputStream out;
        private TmaxHeader tmaxHeader = null;
        private boolean recover;
        private boolean recovered;
        private Vector xidVector = new Vector();

        boolean isConnected() {
            return this.connected;
        }

        boolean reconnect(ConnectionDescriptor tmaxConnDesc) {
            long timeout = tmaxConnDesc.getReconnectTimeout();
            if (timeout == 0L) {
                return false;
            }
            boolean infinite = false;
            if (timeout < 0L) {
                infinite = true;
            }
            while (true) {
                try {
                    this.connect(tmaxConnDesc);
                    return true;
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_WebContainer4._4058_LEVEL)) {
                        logger.log(JeusMessage_WebContainer4._4058_LEVEL, JeusMessage_WebContainer4._4058);
                    }
                    if (!infinite && timeout <= 0L) {
                        return false;
                    }
                    try {
                        Thread.sleep(TMAXWebConnector.RECONNECT_INTERVAL);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (infinite) continue;
                    timeout -= (long)TMAXWebConnector.RECONNECT_INTERVAL;
                    continue;
                }
                break;
            }
        }

        void connect(ConnectionDescriptor tmaxConnDesc) throws IOException {
            byte[] data;
            byte[] reply;
            String tmaxVer;
            String s1;
            if (tmaxConnDesc.getServerType() != null && tmaxConnDesc.getServerType().equalsIgnoreCase("httpGW")) {
                TMAXWebConnectorManager.this.httpGW = true;
            }
            if ((s1 = tmaxConnDesc.getXAResourceClass()) != null && !s1.equals("")) {
                this.recover = true;
                try {
                    Class[] aclass = new Class[]{TMAXWebConnectorManager.this.connDesc.getClass()};
                    Object[] aobj = new Object[]{TMAXWebConnectorManager.this.connDesc};
                    Class<?> class1 = Thread.currentThread().getContextClassLoader().loadClass(s1);
                    Constructor<?> constructor = class1.getDeclaredConstructor(aclass);
                    TMAXWebConnectorManager.this.xar = (XAResource)constructor.newInstance(aobj);
                }
                catch (Exception e) {
                    throw new StartingException("fail to instantiate XAResource class : " + s1, (Throwable)e);
                }
            }
            if ("40".equals(tmaxVer = tmaxConnDesc.getTmaxVersion())) {
                this.tmaxHeader = TmaxUtil.VER4_HEADER;
            } else if ("3X".equalsIgnoreCase(tmaxVer)) {
                this.tmaxHeader = TmaxUtil.VER3_HEADER;
            } else {
                throw new IOException("TMMHandler : Unrecognized value - tmax version : " + tmaxVer);
            }
            this.socket = new Socket(tmaxConnDesc.getWebServerAddress(), tmaxConnDesc.getPort());
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            byte[] header = TmaxUtil.makeHeader(this.tmaxHeader, 101);
            if (tmaxConnDesc.getServerType() != null && tmaxConnDesc.getServerType().equalsIgnoreCase("tms")) {
                TmaxUtil.writeInt(header, 26, this.tmaxHeader.TYPE_OFFSET());
            } else {
                TmaxUtil.writeInt(header, 25, this.tmaxHeader.TYPE_OFFSET());
            }
            TmaxUtil.writeString(this.tmaxHeader, header, tmaxConnDesc.getServerName(), this.tmaxHeader.SVCINAME_OFFSET());
            String svgname = tmaxConnDesc.getServerGroupName();
            if (svgname != null) {
                TmaxUtil.writeString(this.tmaxHeader, header, svgname, this.tmaxHeader.SUBTYPE_OFFSET());
                TmaxUtil.writeInt(header, 0, this.tmaxHeader.RCODE_OFFSET());
            } else {
                TmaxUtil.writeInt(header, -1, this.tmaxHeader.RCODE_OFFSET());
            }
            try {
                this.out.write(header);
                this.out.flush();
            }
            catch (IOException ioe) {
                this.closeSocket();
                throw ioe;
            }
            try {
                reply = TmaxUtil.recvHeader(this.tmaxHeader, this.in);
            }
            catch (IOException ioe) {
                this.closeSocket();
                throw ioe;
            }
            int msgtype = TmaxUtil.readInt(reply, this.tmaxHeader.MSGTYPE_OFFSET());
            if (msgtype != 1101) {
                this.closeSocket();
                throw new IOException("tmm_register : error replied : " + msgtype);
            }
            TMAXWebConnectorManager.this.spri = TmaxUtil.readInt(reply, this.tmaxHeader.SVCICD_OFFSET());
            TMAXWebConnectorManager.this.clhCount = TmaxUtil.readInt(reply, this.tmaxHeader.RCODE_OFFSET());
            TMAXWebConnectorManager.this.cpcCount = TmaxUtil.readInt(reply, this.tmaxHeader.ETC_OFFSET());
            TMAXWebConnectorManager.this.procType = TmaxUtil.readInt(reply, this.tmaxHeader.TYPE_OFFSET());
            TMAXWebConnectorManager.this.clid = TmaxUtil.readInt(reply, this.tmaxHeader.CLID_OFFSET());
            TMAXWebConnectorManager.this.domainid = TmaxUtil.readInt(reply, this.tmaxHeader.ETC2_OFFSET());
            int datalen = TmaxUtil.readInt(reply, this.tmaxHeader.SVCILEN_OFFSET());
            if (datalen < TMAXWebConnectorManager.this.clhCount * 4) {
                this.closeSocket();
                throw new IOException("not enough data received. expected = " + TMAXWebConnectorManager.this.clhCount * 4 + ", received = " + datalen);
            }
            try {
                data = TmaxUtil.recvData(this.in, datalen);
            }
            catch (IOException ioe) {
                this.closeSocket();
                throw ioe;
            }
            TMAXWebConnectorManager.access$902(TMAXWebConnectorManager.this, new int[TMAXWebConnectorManager.this.clhCount]);
            for (int i = 0; i < TMAXWebConnectorManager.this.clhCount; ++i) {
                ((TMAXWebConnectorManager)TMAXWebConnectorManager.this).clhPort[i] = TmaxUtil.readInt(data, i * 4);
            }
            this.connected = true;
            if (logger.isLoggable(JeusMessage_WebContainer4._4061_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4061_LEVEL, JeusMessage_WebContainer4._4061, new Object[]{new Integer(TMAXWebConnectorManager.this.spri), new Integer(TMAXWebConnectorManager.this.clhCount), new Integer(TMAXWebConnectorManager.this.cpcCount), new Integer(TMAXWebConnectorManager.this.procType)});
            }
            if (this.recover && TMAXWebConnectorManager.this.xar != null) {
                Xid[] axid;
                block33: {
                    for (int l = 0; l < TMAXWebConnectorManager.this.clhCount; ++l) {
                        this.xidVector.add(l, new Vector());
                    }
                    axid = null;
                    try {
                        axid = TMAXWebConnectorManager.this.xar.recover(0x1800000);
                    }
                    catch (XAException xae) {
                        xae.printStackTrace();
                        if (!logger.isLoggable(JeusMessage_WebContainer4._4063_LEVEL)) break block33;
                        logger.log(JeusMessage_WebContainer4._4063_LEVEL, JeusMessage_WebContainer4._4063, (Object)TMAXWebConnectorManager.this.xar, (Throwable)xae);
                    }
                }
                if (axid == null || axid.length == 0) {
                    this.recover = false;
                    if (logger.isLoggable(JeusMessage_WebContainer4._4064_LEVEL)) {
                        logger.log(JeusMessage_WebContainer4._4064_LEVEL, JeusMessage_WebContainer4._4064);
                    }
                } else {
                    if (logger.isLoggable(JeusMessage_WebContainer4._4065_LEVEL)) {
                        logger.log(JeusMessage_WebContainer4._4065_LEVEL, JeusMessage_WebContainer4._4065, (Object)new Integer(axid.length));
                    }
                    for (int i1 = 0; i1 < axid.length; ++i1) {
                        Xid xid = axid[i1];
                        byte[] gtxId = xid.getGlobalTransactionId();
                        int j1 = TmaxUtil.readInt(gtxId, 0);
                        if (TMAXWebConnectorManager.this.domainid != j1 >> 22) continue;
                        int clhId = j1 << 24;
                        if (clhId < 0 || clhId >= TMAXWebConnectorManager.this.clhCount) {
                            clhId = 0;
                        }
                        if (this.xidVector.elementAt(clhId) == null) {
                            Vector<Xid> vector = new Vector<Xid>();
                            vector.add(xid);
                            this.xidVector.add(clhId, vector);
                            continue;
                        }
                        Vector vector1 = (Vector)this.xidVector.get(clhId);
                        vector1.add(xid);
                    }
                }
            }
            this.recovered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestShutdown() throws IOException {
            byte[] header = TmaxUtil.makeHeader(this.tmaxHeader, 48);
            TmaxUtil.writeString(this.tmaxHeader, header, TMAXWebConnectorManager.this.connDesc.getServerName(), this.tmaxHeader.SVCINAME_OFFSET());
            Object object = TMAXWebConnectorManager.this.lock;
            synchronized (object) {
                this.out.write(header);
                this.out.flush();
            }
            if (logger.isLoggable(JeusMessage_WebContainer4._4062_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4062_LEVEL, JeusMessage_WebContainer4._4062);
            }
        }

        void closeSocket() {
            this.connected = false;
            this.recovered = false;
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.in = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.out = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
        }

        public int handleRequest() throws IOException {
            byte[] header = TmaxUtil.recvHeader(this.tmaxHeader, this.in);
            int msgtype = TmaxUtil.readInt(header, this.tmaxHeader.MSGTYPE_OFFSET());
            switch (msgtype) {
                case 203: {
                    this.processPingRequest(header);
                    break;
                }
                case 109: {
                    break;
                }
                default: {
                    this.processUnknownRequest(header, msgtype);
                }
            }
            return msgtype;
        }

        private void unregisterTMM() {
            try {
                TmaxUtil.unregisterConnection(this.tmaxHeader, this.out, this.in, true, TMAXWebConnectorManager.this.procType);
                logger.log(JeusMessage_WebContainer4._4066_LEVEL, JeusMessage_WebContainer4._4066);
            }
            catch (IOException ioe) {
                logger.log(JeusMessage_WebContainer4._4067_LEVEL, JeusMessage_WebContainer4._4067, (Throwable)ioe);
            }
            this.closeSocket();
        }

        private void processPingRequest(byte[] header) throws IOException {
            logger.log(JeusMessage_WebContainer4._4069_LEVEL, JeusMessage_WebContainer4._4069);
            TmaxUtil.writeInt(header, 1203, this.tmaxHeader.MSGTYPE_OFFSET());
            this.out.write(header);
            this.out.flush();
        }

        private void processCLHAddedRequest(byte[] header) throws IOException {
        }

        private void processUnknownRequest(byte[] header, int msgtype) throws IOException {
            if (logger.isLoggable(JeusMessage_WebContainer4._4071_LEVEL)) {
                logger.log(JeusMessage_WebContainer4._4071_LEVEL, JeusMessage_WebContainer4._4071, new Object[]{new Integer(msgtype), new Integer(TmaxUtil.readInt(header, this.tmaxHeader.RCODE_OFFSET()))});
            }
            TmaxUtil.writeInt(header, msgtype + 2000, this.tmaxHeader.MSGTYPE_OFFSET());
            this.out.write(header);
            this.out.flush();
        }
    }
}

