/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.testcase;

import java.io.IOException;
import jeus.servlet.connector.AbstractTask;
import jeus.servlet.connector.pipeline.ArrayThreadPoolExecutorPipeline;
import jeus.servlet.connector.pipeline.LinkedListPipeline;
import jeus.servlet.connector.pipeline.LinkedThreadPoolExecutorPipeline;
import jeus.servlet.connector.pipeline.Pipeline;
import jeus.servlet.connector.pipeline.PipelineStatistic;
import jeus.servlet.connector.pipeline.PriorityThreadPoolExecutorPipeline;
import jeus.servlet.connector.testcase.SimplePriorityTask;
import jeus.servlet.connector.testcase.SimpleTask;

public class PipelineTest {
    public static void main(String[] args) {
        PipelineStatistic pipelineStat = new PipelineStatistic(80, "test");
        Pipeline linkedList = PipelineTest.newPipeline(LinkedListPipeline.class.getName(), "LinkedList", pipelineStat);
        PipelineTest.testPipeline(linkedList, pipelineStat);
        Pipeline linkedListExecutor = PipelineTest.newPipeline(LinkedThreadPoolExecutorPipeline.class.getName(), "LinkedBlockingQueue", pipelineStat);
        PipelineTest.testPipeline(linkedListExecutor, pipelineStat);
        Pipeline arrayBlockingExecutor = PipelineTest.newPipeline(ArrayThreadPoolExecutorPipeline.class.getName(), "ArrayBlockingQueue", pipelineStat);
        PipelineTest.testPipeline(arrayBlockingExecutor, pipelineStat);
        Pipeline priorityBlockingExecutor = PipelineTest.newPipeline(PriorityThreadPoolExecutorPipeline.class.getName(), "PriorityBlockingQueue", pipelineStat);
        PipelineTest.testPipeline(priorityBlockingExecutor, pipelineStat);
        if (pipelineStat != null) {
            pipelineStat.finish();
            pipelineStat = null;
        }
    }

    public static Pipeline newPipeline(String pipelineClassName, String name, PipelineStatistic pipelineStat) {
        Class<?> className = null;
        Pipeline pipeline = null;
        try {
            className = Class.forName(pipelineClassName);
            pipeline = (Pipeline)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            System.out.println("Unable to load Pipeline: " + pipelineClassName);
        }
        catch (InstantiationException ex) {
            System.out.println("Unable to load Pipeline: " + pipelineClassName);
        }
        catch (IllegalAccessException ex) {
            System.out.println("Unable to load Pipeline: " + pipelineClassName);
        }
        if (pipelineStat != null) {
            pipeline.setPipelineStatistic(pipelineStat);
            pipelineStat.setProcessorPipeline(pipeline);
        }
        pipeline.setMaxThreads(20);
        pipeline.setMinThreads(5);
        pipeline.setName(name);
        pipeline.setPort(80);
        pipeline.setPriority(10);
        pipeline.setMaxQueueSize(4096);
        pipeline.setThreadsIncrement(1);
        pipeline.setThreadsTimeout(5000L);
        pipeline.setThreadPrefix("test");
        return pipeline;
    }

    public static void testPipeline(Pipeline pipeline, PipelineStatistic pipelineStat) {
        if (pipeline == null) {
            return;
        }
        try {
            pipeline.initPipeline();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (pipelineStat != null) {
            pipelineStat.start();
        }
        pipeline.startPipeline();
        for (int i = 0; i < 500; ++i) {
            TaskThread thread = new TaskThread(pipeline);
            thread.start();
        }
        PipelineTest.printPipelineStatistic(pipeline);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pipeline.stopPipeline();
        if (pipelineStat != null) {
            pipelineStat.stop();
        }
        pipeline.finishPipeline();
    }

    private static void printPipelineStatistic(Pipeline pipeline) {
        if (pipeline == null) {
            return;
        }
        PipelineStatistic stat = pipeline.getPipelineStatistic();
        if (stat == null) {
            return;
        }
        while (true) {
            System.out.println("###########################################");
            System.out.println(stat);
            System.out.println("###########################################");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static class TaskThread
    extends Thread {
        private Pipeline pipeline;
        private boolean priority;

        public TaskThread(Pipeline pipeline) {
            this.pipeline = pipeline;
            this.priority = pipeline instanceof PriorityThreadPoolExecutorPipeline;
        }

        public void run() {
            for (int i = 0; i < 100; ++i) {
                AbstractTask task = null;
                task = this.priority ? new SimplePriorityTask() : new SimpleTask();
                task.setPipeline(this.pipeline);
                task.execute();
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

