/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.testcase.tcp.client;

public class TestPacket {
    int totalLen;
    byte[] header;
    byte[] body;
    byte[] byteMessage;
    String stringMessage;

    public TestPacket(String message) {
        this.initMessage(message);
    }

    public TestPacket(byte[] message) {
        this.initMessage(message);
    }

    public void initMessage(String message) {
        this.stringMessage = message;
        this.initMessage(this.stringMessage.getBytes());
    }

    public void initMessage(byte[] message) {
        if (message == null) {
            return;
        }
        int bodyLen = 0;
        this.byteMessage = message;
        this.totalLen = this.byteMessage.length;
        if (this.totalLen < 130) {
            return;
        }
        this.header = new byte[130];
        System.arraycopy(this.byteMessage, 0, this.header, 0, 130);
        bodyLen = this.totalLen - 130;
        if (bodyLen > 0) {
            this.body = new byte[bodyLen];
            System.arraycopy(this.byteMessage, 130, this.body, 0, bodyLen);
        }
    }

    public int getTotalLen() {
        return this.totalLen;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setTotalLen(int totalLen) {
        this.totalLen = totalLen;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void reset() {
        this.totalLen = 0;
        this.header = null;
        this.body = null;
        this.stringMessage = null;
        this.byteMessage = null;
    }

    public String toString() {
        String ret = "total len = " + this.totalLen + ",";
        if (this.header != null) {
            ret = ret + "header = \"" + new String(this.header) + "\"" + ",";
        }
        if (this.body != null) {
            ret = ret + "body = \"" + new String(this.body) + "\"";
        }
        return ret;
    }
}

