/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.bind.ContextDescriptorJB;
import jeus.tool.ddinit.WEBDDInit;
import jeus.tool.util.JarManager;
import jeus.util.JeusException;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.webservices.spi.EWSProvider;
import jeus.xml.binding.jeusDD.WebComponentType;

public class WarFile {
    public static final String WEB_INF = "WEB-INF";
    public static final String DESCRIPTOR = "web.xml";
    public static final String DD_DESCRIPTOR = "jeus-web-dd.xml";
    public static final String JEUS_DESCRIPTOR_PREFIX = "jeus-web-dd";
    private String source;
    private String alternativeDD;
    private String root;
    private ContextDescriptor ctxDesc;
    private WebComponentType type;
    private JeusLogger logger;
    private boolean webddCreated = false;

    public WarFile(String sourcePath, String alternativeDD, WebComponentType type, JeusLogger logger) {
        this.source = sourcePath;
        this.alternativeDD = alternativeDD;
        this.ctxDesc = null;
        this.type = type;
        this.logger = logger;
    }

    public String getDescriptorPath() {
        return this.root + File.separator + WEB_INF + File.separator + DESCRIPTOR;
    }

    public String getJeusDescriptorPath() {
        if (this.alternativeDD != null) {
            return this.alternativeDD;
        }
        String absPath = this.root + File.separator + WEB_INF;
        String jeusDDName = null;
        File absFile = new File(absPath);
        File[] listFiles = absFile.listFiles();
        if (listFiles == null) {
            return null;
        }
        if (listFiles.length == 0) {
            return null;
        }
        for (int i = 0; i < listFiles.length; ++i) {
            File oneFile = listFiles[i];
            String fileName = oneFile.getName();
            if (!oneFile.isFile() || fileName == null || !fileName.equals(DD_DESCRIPTOR)) continue;
            jeusDDName = fileName;
            break;
        }
        if (jeusDDName == null) {
            return null;
        }
        return this.root + File.separator + WEB_INF + File.separator + jeusDDName;
    }

    public void setUnjarPath(String path) {
        this.root = path;
    }

    public void openPackage(String warContextDocBaseFullPath, String contextRoot, boolean extract) throws Exception {
        if (extract) {
            File _rootDir = new File(warContextDocBaseFullPath);
            if (_rootDir.exists()) {
                FileArchive fileArchive = new FileArchive(warContextDocBaseFullPath);
                fileArchive.delete();
            }
            JarManager.unJar(this.source, warContextDocBaseFullPath);
        }
        this.root = warContextDocBaseFullPath;
        this.ddinit(extract, warContextDocBaseFullPath, contextRoot);
    }

    private void ddinit(boolean extract, String warContextDocBaseFullPath, String contextRoot) throws Exception {
        EWSProvider provider;
        AbstractArchive webArchive = FileArchiveFactory.openArchiveStatic((String)warContextDocBaseFullPath);
        WEBDDInit webdd = new WEBDDInit();
        String contextName = FileUtils.getFileNameWithoutExtension((String)this.type.getUri());
        webdd.setModuleName(contextName);
        webdd.setContextPath(contextRoot);
        webdd.setSourceArchive(webArchive);
        boolean dirty = false;
        if (!webArchive.contains("WEB-INF/jeus-web-dd.xml")) {
            dirty = true;
            webdd.writeDescriptor(null, webdd.initJeusDescriptor());
        }
        if ((provider = EWSProvider.getProvider()) != null && provider.writeJeusWebservicesDD(webArchive)) {
            dirty = true;
        }
        if (extract && dirty) {
            this.remakeWar();
        }
    }

    private void remakeWar() {
        block2: {
            try {
                JarManager.jar(this.source, this.root);
            }
            catch (IOException ioe) {
                if (!this.logger.isLoggable(JeusMessage_WebContainer0._1511_LEVEL)) break block2;
                this.logger.log(JeusMessage_WebContainer0._1511_LEVEL, JeusMessage_WebContainer0._1511, (Object)this.source, (Throwable)ioe);
            }
        }
    }

    public ContextDescriptor loadContextDescriptor(String contextRoot) throws JeusException, FileNotFoundException {
        if (this.ctxDesc != null) {
            return this.ctxDesc;
        }
        String jeusDDPath = this.getJeusDescriptorPath();
        if (jeusDDPath == null) {
            this.ctxDesc = new ContextDescriptor();
            String name = FileUtils.getFileNameWithoutExtension((String)this.source);
            this.ctxDesc.setContextName(name);
            this.ctxDesc.setDocBase(name);
            this.ctxDesc.setContextPathByContextRoot(contextRoot, name);
            return this.ctxDesc;
        }
        File jeusDDFile = new File(jeusDDPath);
        this.ctxDesc = ContextDescriptorJB.getContextDescriptor(null, new FileInputStream(jeusDDFile));
        return this.ctxDesc;
    }

    public boolean isWebddCreated() {
        return this.webddCreated;
    }
}

