/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment;

import java.io.File;
import jeus.security.util.LoginUtil;
import jeus.server.manager.JeusVersion;
import jeus.servlet.common.WebContainerControl;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.deployment.descriptor.bind.WebMainDescriptorJB;
import jeus.servlet.property.ContainerProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.message.JeusMessage_WebContainer0;

public class WebContainer {
    public static final String CONTAINER_CONF_FILE_NAME = "WEBMain.conf";
    public static final String CONTAINER_XML_FILE_NAME = "WEBMain.xml";
    private int adminPort;
    private boolean standaloneMode = false;
    private boolean configByXML = true;
    private String engineName = null;
    private WebContainerManager containerManager = null;

    public WebContainer(String engineName) throws StartingException {
        this.engineName = engineName;
        this.init();
    }

    private void init() throws StartingException {
        if (JeusBootstrapProperties.JEUS_HOME == null) {
            throw new StartingException(JeusMessage_WebContainer0._1210);
        }
        String mode = System.getProperty("jeus.standalone");
        this.setContainerMode(mode);
    }

    public WebContainerControl getController() {
        return this.containerManager.getController();
    }

    public void configure() throws StartingException {
        try {
            this.containerManager = new WebContainerManager();
            this.containerManager.initConstants(this.engineName, this.standaloneMode, false);
            this.containerManager.setConfigByXML(this.configByXML);
            String configPath = null;
            String _fs = System.getProperty("file.separator");
            configPath = this.configByXML ? this.containerManager.CONFIG_DIR + _fs + CONTAINER_XML_FILE_NAME : this.containerManager.CONFIG_DIR + _fs + CONTAINER_CONF_FILE_NAME;
            File tmpConfigPath = new File(configPath);
            if (!tmpConfigPath.exists()) {
                throw new StartingException(JeusMessage_WebContainer0._1215, configPath);
            }
            if (tmpConfigPath.isDirectory()) {
                throw new StartingException(JeusMessage_WebContainer0._1216, configPath);
            }
            this.containerManager.setConfigFile(tmpConfigPath);
            WebContainerDescriptor desc = WebMainDescriptorJB.getWebMainDescriptor(this.engineName);
            this.containerManager.setWebContainerDescriptor(desc);
            ContainerProperties containerProperties = new ContainerProperties();
            containerProperties.init(((WebMainDescriptorJB)desc).getWebMainConfiguration().getProperties());
            this.containerManager.setContainerProperties(containerProperties);
            this.containerManager.validateConfiguration();
            this.containerManager.startContainer();
        }
        catch (Exception e) {
            if (this.containerManager != null) {
                this.containerManager.shutdown();
                this.containerManager = null;
            }
            throw new StartingException(e);
        }
    }

    public void parseArgs(String[] args) throws StartingException {
        Object arg = null;
        Object argName = null;
        Object argValue = null;
        if (args.length <= 1) {
            return;
        }
        this.configByXML = true;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                if (++i == args.length) {
                    throw new StartingException(JeusMessage_WebContainer0._1217);
                }
                this.setAdminPort(args[i]);
                continue;
            }
            if (args[i].startsWith("-port=")) {
                int pos = args[i].indexOf("=");
                this.setAdminPort(args[i].substring(pos + 1));
                continue;
            }
            if (args[i].equals("-m")) {
                if (++i == args.length) {
                    throw new StartingException(JeusMessage_WebContainer0._1219);
                }
                this.setContainerMode(args[i]);
                continue;
            }
            if (args[i].equals("-d")) {
                if (++i >= args.length) continue;
                this.setDebugType(args[i]);
                continue;
            }
            if (args[i].equals("-h") || args[i].equals("-?") || args[i].equals("-help")) {
                this.printUsage();
                continue;
            }
            if (!args[i].equals("-v") && !args[i].equals("-ver") && !args[i].equals("-version")) continue;
            this.printVersion();
        }
    }

    private void setContainerMode(String mode) throws StartingException {
        if (mode != null && mode.equals("true")) {
            this.standaloneMode = true;
        }
    }

    private void setDebugType(String type) {
    }

    private void setAdminPort(String port) throws StartingException {
        try {
            this.adminPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new StartingException(JeusMessage_WebContainer0._1221, String.valueOf(port));
        }
        if (this.adminPort <= 0) {
            throw new StartingException(JeusMessage_WebContainer0._1221, String.valueOf(port));
        }
    }

    private void printUsage() {
        System.out.println("Startup flags");
        System.out.println();
        System.out.println("\t-h                    this message");
        System.out.println("\t-xml                  configuration by xml");
        System.out.println("\t-f config_file        configuration file name");
        System.out.println("\t-p admin_port         admin port");
        System.out.println("\t-m [true|false]       standalone mode");
        System.out.println("\t-v                    version information");
        System.exit(1);
    }

    private void printVersion() {
        System.out.println("JEUS Web Container version: " + JeusVersion.getVersion());
        System.exit(1);
    }

    public static void main(String[] args) throws StartingException {
        WebContainer webContainer = null;
        if (args.length == 0 || args[0] == null) {
            throw new StartingException(JeusMessage_WebContainer0._1212);
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            webContainer = new WebContainer(args[0]);
        }
        catch (StartingException se) {
            se.printStackTrace(System.out);
            Throwable rootCause = se.getCause();
            if (rootCause != null) {
                rootCause.printStackTrace(System.out);
            }
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            throw se;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            webContainer.parseArgs(args);
        }
        catch (StartingException se) {
            webContainer.printUsage();
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            throw se;
        }
        catch (Throwable t) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            t.printStackTrace(System.out);
            throw new StartingException(JeusMessage_WebContainer0._1222, t);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            webContainer.configure();
        }
        catch (StartingException se) {
            se.printStackTrace(System.out);
            Throwable rootCause = se.getCause();
            if (rootCause != null) {
                rootCause.printStackTrace(System.out);
            }
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            throw se;
        }
        catch (Throwable t) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1222));
            t.printStackTrace(System.out);
            throw new StartingException(JeusMessage_WebContainer0._1222, t);
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }
}

