/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import jeus.xml.binding.jeusDD.MonitoringType;

public class ContainerMonitorDescriptor
implements Serializable {
    public static final long DEFAULT_PERIOD = 300000L;
    private long threadPoolCheckPeriod = 300000L;
    private long sessionCheckPeriod = 300000L;
    private long servletReloadCheckPeriod = 300000L;
    private long webtPoolCheckPeriod = 0L;
    private MonitoringType monType;

    public MonitoringType getMonType() {
        return this.monType;
    }

    public void setMonType(MonitoringType monType) {
        this.monType = monType;
    }

    public boolean isEnable() {
        return this.threadPoolCheckPeriod > 0L || this.sessionCheckPeriod > 0L || this.servletReloadCheckPeriod > 0L || this.webtPoolCheckPeriod > 0L;
    }

    public void setThreadPoolCheckPeriod(String value) {
        if (value != null) {
            try {
                this.threadPoolCheckPeriod = Long.parseLong(value);
                if (this.threadPoolCheckPeriod > 0L && this.threadPoolCheckPeriod < 1000L) {
                    this.threadPoolCheckPeriod = 1000L;
                }
            }
            catch (Exception e) {
                this.threadPoolCheckPeriod = 300000L;
            }
            if (this.monType != null) {
                this.monType.setCheckThreadPool(Long.valueOf(this.threadPoolCheckPeriod));
            }
        }
    }

    public void setSessionCheckPeriod(String value) {
        if (value != null) {
            try {
                this.sessionCheckPeriod = Long.parseLong(value);
                if (this.sessionCheckPeriod > 0L && this.sessionCheckPeriod < 1000L) {
                    this.sessionCheckPeriod = 1000L;
                }
            }
            catch (Exception e) {
                this.sessionCheckPeriod = 300000L;
            }
            if (this.monType != null) {
                this.monType.setCheckSession(Long.valueOf(this.sessionCheckPeriod));
            }
        }
    }

    public void setServletReloadCheckPeriod(String value) {
        if (value != null) {
            try {
                this.servletReloadCheckPeriod = Long.parseLong(value);
                if (this.servletReloadCheckPeriod > 0L && this.servletReloadCheckPeriod < 1000L) {
                    this.servletReloadCheckPeriod = 1000L;
                }
            }
            catch (Exception e) {
                this.servletReloadCheckPeriod = -1L;
            }
            if (this.monType != null) {
                this.monType.setCheckClassReload(Long.valueOf(this.servletReloadCheckPeriod));
            }
        }
    }

    public void setWebtPoolCheckPeriod(String value) {
        if (value != null) {
            try {
                this.webtPoolCheckPeriod = Long.parseLong(value);
                if (this.webtPoolCheckPeriod > 0L && this.webtPoolCheckPeriod < 1000L) {
                    this.webtPoolCheckPeriod = 1000L;
                }
            }
            catch (Exception e) {
                this.webtPoolCheckPeriod = 0L;
            }
        }
    }

    public long getThreadPoolCheckPeriod() {
        return this.threadPoolCheckPeriod;
    }

    public long getSessionCheckPeriod() {
        return this.sessionCheckPeriod;
    }

    public long getServletReloadCheckPeriod() {
        return this.servletReloadCheckPeriod;
    }

    public long getWebtPoolCheckPeriod() {
        return this.webtPoolCheckPeriod;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("<<< ContainerMonitor Information >>>");
        out.println("    - thread pool check period (tmi)         : " + this.threadPoolCheckPeriod);
        out.println("    - session check period (smi)             : " + this.sessionCheckPeriod);
        out.println("    - servlet reload check period (rmi)      : " + this.servletReloadCheckPeriod);
    }
}

