/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;

public class FileCachingDescriptor
implements Serializable {
    private int maxCacheMemory = -1;
    private long maxIdleTime = -1L;
    private Vector cachingDirs = null;

    public void setMaxCacheMemory(String mem) {
        if (mem != null) {
            try {
                this.maxCacheMemory = Integer.parseInt(mem);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setMaxIdleTime(String time) {
        if (time != null) {
            try {
                this.maxIdleTime = Long.parseLong(time);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void addCachingDirectory(String dir) {
        if (dir != null) {
            if (this.cachingDirs == null) {
                this.cachingDirs = new Vector();
            }
            dir = this.correctDirFormat(dir);
            this.cachingDirs.addElement(dir);
        }
    }

    public int getMaxCacheMemory() {
        return this.maxCacheMemory;
    }

    public long getMaxIdleTime() {
        if (this.maxIdleTime < 0L) {
            return -1L;
        }
        return this.maxIdleTime;
    }

    public Vector getCachingDirectory() {
        return this.cachingDirs;
    }

    private String correctDirFormat(String dir) {
        String fs = "/";
        if (!dir.startsWith(fs)) {
            dir = fs + dir;
        }
        if (!dir.endsWith(fs)) {
            dir = dir + fs;
        }
        return dir;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("  ++ file caching ++");
        if (this.maxCacheMemory > 0) {
            out.println("  - maximum cache memory : " + this.maxCacheMemory + " MB");
        } else {
            out.println("  - maximum cache memory : no limit");
        }
        if (this.maxIdleTime > 0L) {
            out.println("  - maximum idle time : " + this.maxIdleTime + " ms");
        } else {
            out.println("  - maximum idle time : no limit");
        }
        out.println("  - cached directories");
        if (this.cachingDirs != null && this.cachingDirs.size() > 0) {
            for (int i = 0; i < this.cachingDirs.size(); ++i) {
                out.println("    [" + i + "] " + this.cachingDirs.elementAt(i));
            }
        }
    }
}

