/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jeus.descriptor.tool.Descriptor;

public class FilterDescriptor
extends Descriptor
implements Serializable {
    private String filterName = null;
    private String filterClass = null;
    private Hashtable initParamValues = null;
    private Hashtable initParamDescs = null;

    public FilterDescriptor() {
    }

    public FilterDescriptor(String paramFilterName) {
        this.setFilterName(paramFilterName);
    }

    public void setFilterName(String paramFilterName) {
        this.filterName = paramFilterName;
    }

    public void setFilterClass(String paramFilterClass) {
        this.filterClass = paramFilterClass;
    }

    public void addInitParam(String name, String value, String desc) {
        if (name != null && value != null) {
            if (this.initParamValues == null) {
                this.initParamValues = new Hashtable();
                this.initParamDescs = new Hashtable();
            }
            this.initParamValues.put(name, value);
            if (desc != null) {
                this.initParamDescs.put(name, desc);
            }
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public Hashtable getInitParamValues() {
        return this.initParamValues;
    }

    public String getInitParamValue(String key) {
        if (this.initParamValues != null) {
            return (String)this.initParamValues.get(key);
        }
        return null;
    }

    public Hashtable getInitParamDescs() {
        return this.initParamDescs;
    }

    public String getInitParamDesc(String key) {
        if (this.initParamDescs != null) {
            return (String)this.initParamDescs.get(key);
        }
        return null;
    }

    public String toString() {
        return this.getFilterName();
    }

    public void printDescriptor(PrintWriter out) {
        if (this.filterClass != null) {
            out.println("  - filter-name=" + this.filterName + ", filter-class=" + this.filterClass);
        }
        if (this.initParamValues != null) {
            Enumeration enum1 = this.initParamValues.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                String value = (String)this.initParamValues.get(name);
                out.println("    - init-param : name = " + name + ", value = " + value);
            }
        }
    }

    public void print() {
        System.out.println("  filterName = " + this.filterName);
        System.out.println("  filterClass = " + this.filterClass);
        if (this.initParamValues != null) {
            int i = 0;
            Enumeration enum1 = this.initParamValues.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                String value = (String)this.initParamValues.get(name);
                String desc = (String)this.initParamDescs.get(name);
                System.out.println("InitParam[" + i++ + "]");
                System.out.println("  paramName = " + name);
                System.out.println("  paramValue = " + value);
                System.out.println("  description = " + desc);
            }
        }
    }
}

