/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;

abstract class DispatchedRequest {
    protected HttpServletRequestImpl orgreq;
    protected HttpServletRequest req;
    protected String savedQueryString;
    protected Hashtable savedParameters;
    protected boolean isGetNamedDispatcher = false;
    protected boolean requestReplaced = false;

    DispatchedRequest(HttpServletRequest req) throws ServletException {
        this.req = req;
        this.findOriginalRequest((ServletRequest)req);
    }

    private void findOriginalRequest(ServletRequest req) throws ServletException {
        ServletRequest temp;
        block4: {
            temp = null;
            if (req instanceof HttpServletRequestImpl) {
                this.orgreq = (HttpServletRequestImpl)req;
                this.requestReplaced = false;
                return;
            }
            try {
                temp = ((ServletRequestWrapper)req).getRequest();
            }
            catch (ClassCastException cce) {
                RequestProcessor proc = (RequestProcessor)Thread.currentThread();
                this.orgreq = proc.getRequest();
                this.requestReplaced = false;
                return;
            }
            while (true) {
                if (temp instanceof HttpServletRequestImpl) break block4;
                if (!(temp instanceof ServletRequestWrapper)) break;
                temp = ((ServletRequestWrapper)temp).getRequest();
            }
            RequestProcessor proc = (RequestProcessor)Thread.currentThread();
            this.orgreq = proc.getRequest();
            this.requestReplaced = false;
            return;
        }
        this.orgreq = (HttpServletRequestImpl)temp;
        this.requestReplaced = true;
    }

    protected final void setQueryString(String query) {
        WebProperties props = PropertyUtil.getContextProperties();
        if (query != null && !props.TOMCAT_COMPATIBLE_QUERY_STRING.value) {
            this.orgreq.setQueryString(query);
        }
        if (query == null || query.trim().length() <= 0) {
            return;
        }
        Hashtable newParams = null;
        if (WebProperties.J2EE_COMPATIBLE.value && query.indexOf(59) > -1) {
            newParams = new Hashtable();
        } else if (props.URL_ENCODE_JSP_PARAM.value) {
            try {
                newParams = RequestUtil.parseQueryString(query, this.orgreq.getRequestQueryEncoding());
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            newParams = HttpUtils.parseQueryString((String)query);
        }
        Hashtable oldParams = (Hashtable)this.savedParameters.clone();
        Hashtable resultParams = RequestUtil.mergeParameters(newParams, oldParams);
        this.orgreq.setParameter(resultParams);
    }

    abstract HttpServletRequest getRequest(String var1, String var2, String var3, String var4, String var5);

    abstract void restore();
}

