/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.DispatchedRequest;
import jeus.servlet.filter.FilterFactory;

final class ForwardedRequest
extends DispatchedRequest {
    private String savedRequestURI = null;
    private String savedContextPath = null;
    private String savedServletPath = null;
    private String savedPathInfo = null;
    private String savedLookupPath = null;
    private Context savedContext = null;
    private Context ctx = null;

    ForwardedRequest(HttpServletRequest req, Context ctx, boolean isGetNamedDispatcher) throws ServletException {
        super(req);
        this.isGetNamedDispatcher = isGetNamedDispatcher;
        this.ctx = ctx;
    }

    HttpServletRequest getRequest(String ctxPath, String path, String query, String spath, String ppath) {
        if (!this.isGetNamedDispatcher) {
            this.savedLookupPath = this.orgreq.getLookupPath();
            this.savedRequestURI = this.orgreq.getRequestURI();
            this.savedServletPath = this.orgreq.getServletPath();
            this.savedPathInfo = this.orgreq.getPathInfo();
            this.savedQueryString = this.orgreq.getQueryString();
            this.savedParameters = new Hashtable();
            this.savedParameters.putAll(this.orgreq.getParameterMap());
            this.savedContextPath = this.orgreq.getContextPath();
            this.orgreq.setLookupPath(path);
            this.orgreq.setServletPath(spath);
            this.orgreq.setPathInfo(ppath);
            this.orgreq.setContextPath(ctxPath);
            if (ctxPath != null) {
                if (ctxPath.equals("/")) {
                    this.orgreq.setRequestURI(path);
                } else {
                    this.orgreq.setRequestURI(ctxPath + path);
                }
            }
            this.setQueryString(query);
            if (this.orgreq.getAttribute("javax.servlet.forward.request_uri") == null) {
                this.orgreq.setAttribute("javax.servlet.forward.request_uri", this.savedRequestURI);
                this.orgreq.setAttribute("javax.servlet.forward.context_path", this.savedContextPath);
                this.orgreq.setAttribute("javax.servlet.forward.servlet_path", this.savedServletPath);
                this.orgreq.setAttribute("javax.servlet.forward.path_info", this.savedPathInfo);
                this.orgreq.setAttribute("javax.servlet.forward.query_string", this.savedQueryString);
                if (this.requestReplaced) {
                    this.req.setAttribute("javax.servlet.forward.request_uri", (Object)this.savedRequestURI);
                    this.req.setAttribute("javax.servlet.forward.context_path", (Object)this.savedContextPath);
                    this.req.setAttribute("javax.servlet.forward.servlet_path", (Object)this.savedServletPath);
                    this.req.setAttribute("javax.servlet.forward.path_info", (Object)this.savedPathInfo);
                    this.req.setAttribute("javax.servlet.forward.query_string", (Object)this.savedQueryString);
                }
            }
        }
        this.savedContext = this.orgreq.getContext();
        this.orgreq.setContext(this.ctx);
        Integer disInt = (Integer)this.orgreq.getAttribute("jeus.web.DISPATCHER_TYPE");
        if (disInt != null && disInt != 1) {
            String requestPath = "";
            if (spath != null) {
                requestPath = requestPath + spath;
            }
            if (ppath != null) {
                requestPath = requestPath + ppath;
            }
            this.orgreq.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.FORWARD_INTEGER);
            this.orgreq.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", requestPath);
            if (this.requestReplaced) {
                this.req.setAttribute("jeus.web.DISPATCHER_TYPE", (Object)FilterFactory.FORWARD_INTEGER);
                this.req.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", (Object)requestPath);
            }
        }
        return this.req;
    }

    void restore() {
        if (!this.isGetNamedDispatcher) {
            this.orgreq.setRequestURI(this.savedRequestURI);
            this.orgreq.setContextPath(this.savedContextPath);
            this.orgreq.setServletPath(this.savedServletPath);
            this.orgreq.setPathInfo(this.savedPathInfo);
            this.orgreq.setQueryString(this.savedQueryString);
            this.orgreq.setParameter(this.savedParameters);
            this.orgreq.setLookupPath(this.savedLookupPath);
        }
        this.orgreq.setContext(this.savedContext);
    }
}

