/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpUtils;

public class HttpServletRequestWrapperInclude
extends HttpServletRequestWrapper {
    private Hashtable parameters = null;
    private Object old_request_uri;
    private Object old_context_path;
    private Object old_servlet_path;
    private Object old_path_info;
    private Object old_query_string;
    private String queryString = null;

    HttpServletRequestWrapperInclude(HttpServletRequest request) {
        super(request);
        this.setRequest((ServletRequest)request);
        this.parameters = new Hashtable();
        this.parameters.putAll(this.getRequest().getParameterMap());
        this.queryString = request.getQueryString();
    }

    void addQueryString(String query) {
        if (query == null || query.trim().length() <= 0) {
            return;
        }
        this.queryString = query;
        Hashtable newParams = HttpUtils.parseQueryString((String)query);
        Enumeration e = newParams.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.parameters.put(key, newParams.get(key));
        }
    }

    void saveAttributes() {
        this.old_request_uri = this.getRequest().getAttribute("javax.servlet.include.request_uri");
        this.old_context_path = this.getRequest().getAttribute("javax.servlet.include.context_path");
        this.old_servlet_path = this.getRequest().getAttribute("javax.servlet.include.servlet_path");
        this.old_path_info = this.getRequest().getAttribute("javax.servlet.include.path_info");
        this.old_query_string = this.getRequest().getAttribute("javax.servlet.include.query_string");
    }

    void restoreAttributes() {
        this.getRequest().setAttribute("javax.servlet.include.request_uri", this.old_request_uri);
        this.getRequest().setAttribute("javax.servlet.include.context_path", this.old_context_path);
        this.getRequest().setAttribute("javax.servlet.include.servlet_path", this.old_servlet_path);
        this.getRequest().setAttribute("javax.servlet.include.path_info", this.old_path_info);
        this.getRequest().setAttribute("javax.servlet.include.query_string", this.old_query_string);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return (Map)this.parameters.clone();
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }
}

