/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import jeus.server.enginecontainer.InvocationManager;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.connection.SSLSupport;
import jeus.servlet.connection.SSLSupport14;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.loader.ContextLoader;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.NotAllowedAddressException;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.logging.AccessLogger;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.webservices.spi.EWSProvider;
import sun.security.action.GetBooleanAction;

public abstract class RequestProcessor
extends Thread {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    protected AccessLogger accessLogger;
    protected SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    protected ContextGroup contextGroup;
    protected ThreadPoolManager poolManager;
    protected HttpServletRequestImpl request;
    protected HttpServletResponseImpl response;
    protected boolean running;
    protected boolean enableAccessControl;
    protected Vector allowedServer;
    private boolean deleted;
    boolean active = false;
    boolean blocked = false;
    boolean reconnecting = false;
    protected long startTime;
    protected long endTime;
    protected String threadId;
    protected long requestNums;
    protected long totalRequestNums;
    protected long threadProcTime;
    protected long totalThreadProcTime;
    protected long totalAvgProcTime;
    protected int step = 0;
    private boolean datasourcePrepared = false;
    private WebServerOutputStream outputStream;
    private static final boolean UsingUnavailMapping503 = AccessController.doPrivileged(new GetBooleanAction("jeus.servlet.engine.UsingUnavailMapping503"));
    private SSLSupport sslSupport;

    RequestProcessor(ThreadPoolManager manager, ContextGroup ctxGroup) {
        this.poolManager = manager;
        this.contextGroup = ctxGroup;
        this.accessLogger = this.contextGroup.getAccessLogger();
        this.allowedServer = this.poolManager.getAllowedServer();
        this.enableAccessControl = this.poolManager.isEnableAccessControl();
    }

    public void terminate() {
        this.running = false;
        if (!this.active) {
            this.interrupt();
        }
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getThreadPoolId() {
        if (this.poolManager == null) {
            return null;
        }
        return this.poolManager.getThreadPoolId();
    }

    public String getListenerId() {
        if (this.poolManager == null) {
            return null;
        }
        return this.poolManager.getListenerId();
    }

    HttpServletRequestImpl getRequest() {
        return this.request;
    }

    HttpServletResponseImpl getResponse() {
        return this.response;
    }

    public String checkBlockedThreadState() {
        String state = null;
        if (!this.deleted) {
            long now = System.currentTimeMillis();
            long diff = now - this.startTime;
            this.totalRequestNums += this.requestNums;
            this.totalThreadProcTime += this.threadProcTime;
            long avgProcTime = 0L;
            if (this.requestNums > 0L) {
                avgProcTime = this.threadProcTime / this.requestNums;
            }
            if (this.totalRequestNums > 0L) {
                this.totalAvgProcTime = this.totalThreadProcTime / this.totalRequestNums;
            }
            state = "[" + this.threadId + "]";
            state = state + "[active , " + this.df.format(new Date(this.startTime)) + ", " + diff + " ms]";
            state = state + "[req=" + this.requestNums + ", avg=" + avgProcTime + " ms, total=" + this.totalRequestNums + ", total avgTime=" + this.totalThreadProcTime + "ms, " + this.step + "]";
            state = this.request != null ? state + "[" + this.request.getRequestURI() + "]" : state + "[unknowm-state]";
        }
        return state;
    }

    public ThreadStateInfo getThreadState(int mode) {
        ThreadStateInfo threadInfo = new ThreadStateInfo(this.threadId, mode);
        threadInfo.alive = this.isAlive();
        if (mode == ThreadStateInfo.GET_RUNNING_STATE) {
            threadInfo.active = this.active;
            threadInfo.blocked = this.blocked;
            threadInfo.reconnecting = this.reconnecting;
            long now = System.currentTimeMillis();
            if (this.active) {
                threadInfo.elapsedTime = now - this.startTime;
                if (this.request != null && this.step > 1 && this.step < 8) {
                    threadInfo.runningApp = this.request.getRequestURI();
                    threadInfo.qString = this.request.getQueryString();
                } else {
                    threadInfo.runningApp = "unknown";
                }
            } else {
                threadInfo.elapsedTime = now - this.endTime;
                threadInfo.runningApp = null;
            }
        } else if (mode == ThreadStateInfo.GET_PROCESSING_INFO) {
            this.totalRequestNums += this.requestNums;
            this.totalThreadProcTime += this.threadProcTime;
            long avgProcTime = 0L;
            if (this.requestNums > 0L) {
                avgProcTime = this.threadProcTime / this.requestNums;
            }
            if (this.totalRequestNums > 0L) {
                this.totalAvgProcTime = this.totalThreadProcTime / this.totalRequestNums;
            }
            threadInfo.requestCount = this.requestNums;
            threadInfo.avgProcTime = avgProcTime;
            threadInfo.totalRequestCount = this.totalRequestNums;
            threadInfo.totalAvgProcTime = this.totalAvgProcTime;
            this.requestNums = 0L;
            this.threadProcTime = 0L;
        } else if (mode == ThreadStateInfo.GET_ALL_INFO || mode == ThreadStateInfo.GET_ALL2_INFO) {
            threadInfo.active = this.active;
            threadInfo.blocked = this.blocked;
            threadInfo.reconnecting = this.reconnecting;
            long now = System.currentTimeMillis();
            if (this.active) {
                threadInfo.elapsedTime = now - this.startTime;
                threadInfo.checkTime = this.startTime;
                threadInfo.step = this.step;
                if (this.request != null && this.step > 1 && this.step < 8) {
                    threadInfo.runningApp = this.request.getRequestURI();
                    threadInfo.qString = this.request.getQueryString();
                } else {
                    threadInfo.runningApp = "unknown";
                }
            } else {
                threadInfo.elapsedTime = now - this.endTime;
                threadInfo.checkTime = this.endTime;
                threadInfo.runningApp = null;
                threadInfo.qString = null;
            }
            this.totalRequestNums += this.requestNums;
            this.totalThreadProcTime += this.threadProcTime;
            long avgProcTime = 0L;
            if (this.requestNums > 0L) {
                avgProcTime = this.threadProcTime / this.requestNums;
            }
            if (this.totalRequestNums > 0L) {
                this.totalAvgProcTime = this.totalThreadProcTime / this.totalRequestNums;
            }
            threadInfo.requestCount = this.requestNums;
            threadInfo.avgProcTime = avgProcTime;
            threadInfo.totalRequestCount = this.totalRequestNums;
            threadInfo.totalAvgProcTime = this.totalAvgProcTime;
            this.requestNums = 0L;
            this.threadProcTime = 0L;
        }
        return threadInfo;
    }

    protected final void prepareDataSourceConnections() {
        InvocationManager.preInvoke(true);
        this.datasourcePrepared = true;
    }

    protected final void cleanupDataSourceConnections() {
        if (this.datasourcePrepared) {
            InvocationManager.postInvoke();
            this.datasourcePrepared = false;
        }
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void clearing() {
        this.deleted = true;
    }

    protected void initRun() {
    }

    protected void doWorkRelatedReload(Context ctx) {
        ContextLoader contextLoader = ctx.getContextLoader();
        if (contextLoader != null && contextLoader.isReloadable() && contextLoader.isCheckOnDemand() && contextLoader.modified()) {
            ctx.execReload();
        }
        ctx.increaseExecutionThread();
    }

    final long checkIdleTime(long interval) {
        if (this.reconnecting || interval <= 0L) {
            return -1L;
        }
        long lastAccessTime = this.startTime > this.endTime ? this.startTime : this.endTime;
        long nowTime = System.currentTimeMillis();
        long idleTime = nowTime - lastAccessTime;
        if (idleTime > interval) {
            this.running = false;
            return idleTime;
        }
        return -1L;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void socketClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void sendError(Throwable t) {
        this.sendError(t, t.getMessage());
    }

    protected final void sendError(Throwable t, String msg) {
        block15: {
            try {
                if (msg == null) {
                    msg = t.getMessage();
                }
                if (t instanceof FileNotFoundException) {
                    this.response.sendError(404, msg, t);
                } else if (t instanceof UnavailableException) {
                    if (UsingUnavailMapping503) {
                        this.response.sendError(503, msg, t);
                    } else {
                        this.response.sendError(404, msg, t);
                    }
                } else if (t instanceof ServletException) {
                    ServletException e = (ServletException)t;
                    Throwable rc = e.getRootCause();
                    if (rc != null && rc instanceof FileNotFoundException) {
                        this.response.sendError(404, msg, e);
                    } else {
                        this.response.sendError(500, msg, e);
                    }
                } else if (t instanceof NotAllowedAddressException) {
                    this.response.sendError(403, msg);
                } else {
                    this.response.sendError(500, msg, t);
                }
            }
            catch (Throwable tt) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3829_LEVEL)) break block15;
                logger.log(JeusMessage_WebContainer2._3829_LEVEL, JeusMessage_WebContainer2._3829, tt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket checkStep(Socket socket, Throwable t) {
        if (this.step < 2) {
            if (this.enableAccessControl && t instanceof NotAllowedAddressException) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3327_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3327_LEVEL, JeusMessage_WebContainer2._3327, (Object[])new String[]{this.threadId, socket.getInetAddress().getHostAddress()});
                }
                this.sendError(t, null);
                Context ctx = this.request.getContext();
                try {
                    if (ctx != null) {
                        WebAppContextSwitch.preContextSwitch(ctx.getContextLoader());
                    }
                    this.response.finish();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (ctx != null) {
                        WebAppContextSwitch.postContextSwitch();
                    }
                }
                this.socketClose(socket);
                return null;
            }
            this.socketClose(socket);
            String cause = "";
            if (t != null) {
                cause = t.toString();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(JeusMessage_WebContainer2._3322_LEVEL, JeusMessage_WebContainer2._3322, (Object[])new String[]{this.threadId, cause}, t);
            } else if (logger.isLoggable(JeusMessage_WebContainer2._3322_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3322_LEVEL, JeusMessage_WebContainer2._3322, (Object[])new String[]{this.threadId, cause});
            }
            return null;
        }
        String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3323, (Object)this.threadId);
        logger.log(JeusMessage_WebContainer2._3323_LEVEL, msg, t);
        this.sendError(t, msg);
        return socket;
    }

    protected ExecutionWrapper getExecutionWrapper() throws FileNotFoundException, ServletException {
        ExecutionWrapper wrapper = null;
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null && (wrapper = provider.getRegisteredEndpointWrapper(this.request)) != null) {
            return wrapper;
        }
        Context ctx = this.request.getContext();
        if (ctx == null) {
            throw new FileNotFoundException(this.request.getRequestURI());
        }
        wrapper = ctx.getServletByPath(this.request);
        return wrapper;
    }

    protected void incrementProcessingTime(long processingTime) {
        Context ctx = this.request.getContext();
        if (ctx != null) {
            ctx.processingTime += processingTime;
        }
    }

    protected void setContextClassLoader() {
        Context ctx = this.request.getContext();
        if (ctx != null) {
            this.setContextClassLoader(ctx.getContextLoader());
        }
    }

    protected void setSSLAttribute() {
        if (this.sslSupport == null) {
            return;
        }
        try {
            Object sslO = this.sslSupport.getCipherSuite();
            if (sslO != null) {
                this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
            }
            if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
            }
            if ((sslO = this.sslSupport.getKeySize()) != null) {
                this.request.setAttribute("javax.servlet.request.key_size", sslO);
            }
            if ((sslO = this.sslSupport.getSessionId()) != null) {
                this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void setSSLSupport(Socket socket, HttpServletRequestImpl request) {
        if (!(socket instanceof SSLSocket)) {
            this.sslSupport = null;
            request.setSslSupport(this.sslSupport);
            return;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        float version = JeusBootstrapPropertyValues.JAVA_VERSION;
        this.sslSupport = (double)version == 1.3 ? new SSLSupport(sslSocket) : ((double)version == 1.4 ? new SSLSupport14(sslSocket) : ((double)version == 1.5 ? new SSLSupport14(sslSocket) : new SSLSupport14(sslSocket)));
        request.setSslSupport(this.sslSupport);
    }

    public Socket doSocketFilter(Socket soc) throws NotAllowedAddressException {
        InetAddress inetAddr = soc.getInetAddress();
        String addr = inetAddr.getHostAddress();
        if (this.allowedServer.contains(addr)) {
            return soc;
        }
        byte[] elements = inetAddr.getAddress();
        int el1 = elements[0] < 0 ? 256 + elements[0] : elements[0];
        int el2 = elements[1] < 0 ? 256 + elements[1] : elements[1];
        int el3 = elements[2] < 0 ? 256 + elements[2] : elements[2];
        String part1 = String.valueOf(el1);
        String part2 = String.valueOf(el2);
        String part3 = String.valueOf(el3);
        StringBuffer netAddr = new StringBuffer(part1);
        netAddr.append(".").append(part2).append(".").append(part3).append(".*");
        addr = netAddr.toString();
        if (this.allowedServer.contains(addr)) {
            return soc;
        }
        netAddr.setLength(0);
        netAddr.append(part1).append(".").append(part2).append(".*.*");
        addr = netAddr.toString();
        if (this.allowedServer.contains(addr)) {
            return soc;
        }
        netAddr.setLength(0);
        netAddr.append(part1).append(".*.*.*");
        addr = netAddr.toString();
        if (this.allowedServer.contains(addr)) {
            return soc;
        }
        addr = inetAddr.getHostAddress();
        throw new NotAllowedAddressException(addr + ":Not allowed");
    }

    protected void prepareRequest() throws Throwable {
        String protocol = this.request.getProtocol();
        if (protocol == null) {
            this.request.setProtocolInt(9);
        } else if (protocol.equals("HTTP/1.1")) {
            this.request.setProtocolInt(11);
        } else if (protocol.equals("HTTP/1.0")) {
            this.request.setProtocolInt(10);
        } else if (protocol.equals("HTTP/0.9")) {
            this.request.setProtocolInt(9);
        } else if (protocol.equals("")) {
            this.request.setProtocolInt(33);
        } else {
            this.request.setProtocolInt(0);
        }
        String connection = this.request.getHeader("Connection");
        if (connection != null) {
            if (connection.equals("close")) {
                this.request.setConnectionHeader(2);
            } else {
                this.request.setConnectionHeader(1);
            }
        } else {
            this.request.setConnectionHeader(0);
        }
    }

    protected boolean postRequest(ExecutionWrapper wapper) throws IOException {
        String contextPath = this.request.getContextPath();
        if (contextPath != null && contextPath.equals(this.request.getRequestURI())) {
            this.sendRedirectWithSlash();
            return false;
        }
        if (wapper != null && wapper.isResourceServlet()) {
            File file;
            String path = this.request.getServletPath();
            Context context = this.request.getContext();
            if (context != null && path != null && !path.endsWith("/") && (file = new File(context.getCtxDocBase().getFile() + Context.normPath(path))).exists() && file.isDirectory()) {
                this.sendRedirectWithSlash();
                return false;
            }
        }
        return true;
    }

    private void sendRedirectWithSlash() throws IOException {
        StringBuffer redirectPath = this.request.getRequestURL();
        redirectPath.append('/');
        String query = this.request.getQueryString();
        if (query != null) {
            redirectPath.append('?').append(query);
        }
        this.response.sendRedirect(redirectPath.toString());
    }

    protected void doTransactionRollback() throws SystemException {
        Transaction tx = null;
        try {
            tx = TxHelper.getTransactionManager().getTransaction();
            if (tx != null) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3961_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3961_LEVEL, JeusMessage_WebContainer2._3961, (Object)this.threadId);
                }
                tx.rollback();
            }
        }
        catch (SystemException e) {
            throw e;
        }
        finally {
            ThreadContexts.initNextTimeout();
        }
    }

    public WebProperties getContextGroupProperties() {
        return this.contextGroup.getContextGroupProperties();
    }

    public WebProperties getContainerProperties() {
        return this.contextGroup.getContainerManager().getContainerProperties();
    }

    protected void setThreadId(int num) {
        String threadNum;
        try {
            String pattern = "";
            for (int i = 0; i < String.valueOf(this.poolManager.getMaxThreadNum()).length(); ++i) {
                pattern = pattern + "0";
            }
            DecimalFormat formatter = new DecimalFormat(pattern);
            threadNum = formatter.format(num);
        }
        catch (Exception e) {
            threadNum = String.valueOf(num);
        }
        this.threadId = this.poolManager.getThreadPoolId() + "-w" + threadNum;
        this.setName(this.threadId);
    }

    protected void setThreadId() {
        this.setThreadId(this.poolManager.getAndIncrementThreadId());
    }

    protected void initializeReqRes(boolean keepAlive) {
        if (this.contextGroup == null || this.poolManager == null) {
            return;
        }
        HttpServletRequestImpl newRequest = this.createRequest(this.contextGroup, this.poolManager);
        if (this.request != null && keepAlive) {
            newRequest.copySocket(this.request);
        }
        this.request = newRequest;
        if (this.outputStream == null) {
            this.outputStream = this.createOutputStream(null, this.poolManager.getOutputBufferSize());
        }
        this.response = this.createResponse(this.contextGroup, this.outputStream);
        this.request.setResponse(this.response);
        this.response.setRequest(this.request);
        this.outputStream.setRequestAndResponse(this.request, this.response);
    }

    protected abstract HttpServletRequestImpl createRequest(ContextGroup var1, ThreadPoolManager var2);

    protected abstract HttpServletResponseImpl createResponse(ContextGroup var1, WebServerOutputStream var2);

    protected abstract WebServerOutputStream createOutputStream(OutputStream var1, int var2);
}

